
package de.caff.asteroid;

/**
 *  Automatically start game when start game message is displayed.
 *
 *  This needs a patched mameaster which understands the additional start key.
 *
  *  @see de.caff.asteroid.GameData#BUTTON_START
 */
public class AutoStarter
        implements FrameListener,
                   GameData
{
  /** Communication for key press. */
  private Communication com;

  /**
   *  Constructor.
   *  @param com communictaion access
   */
  private AutoStarter(Communication com)
  {
    this.com = com;
  }

  /**
   * Called each time a frame is received.
   * <p/>
   * <b>ATTENTION:</b> this is called from the communication thread!
   * Implementing classes must be aware of this and take care by synchronization or similar!
   *
   * @param frame the received frame
   */
  public void frameReceived(FrameInfo frame)
  {
    if (frame.isGameStartDisplayed()) {
      com.pushButton(BUTTON_START);
    }
  }

  /**
   *  Install an auto starter onthe given communication.
   *  @param com communication where to add autos tarter
   */
  public static void install(Communication com)
  {
    AutoStarter starter = new AutoStarter(com);
    com.addFrameListener(starter);
  }
}
