
package de.caff.asteroid;

/**
 *  Frame listener called on each frame received.
 *
 *  @see de.caff.asteroid.Communication#addFrameListener(FrameListener)
 *  @see de.caff.asteroid.Communication#removeFrameListener(FrameListener)
 */
public interface FrameListener
{
  /**
   *  Called each time a frame is received.
   *
   *  <b>ATTENTION:</b> this is called from the communication thread!
   *  Implementing classes must be aware of this and take care by synchronization or similar!
   *  @param frame the received frame
   */
  public void frameReceived(FrameInfo frame);
}
