
package de.caff.asteroid;

import java.awt.*;

/**
 *  Some useful constants of the Asteroids game.
 */
public interface GameData
{
  /** Size of the vector ram. */
  int VECTORRAM_SIZE = 1024;
  /** Extent of x and y coordinates. */
  int EXTENT = 1024;
  /** Border above and below y because of 4/3 screen aspect ratio. */
  int BORDER_Y = EXTENT/8;
  /** The minimal y coordinate used. */
  int MIN_Y = BORDER_Y;
  /** The screen extend in x direction. */
  int EXTENT_X = EXTENT;
  /** The screen extent in y direction. */
  int EXTENT_Y = EXTENT - 2*BORDER_Y;
  /** The maximal y coordinate used. */
  int MAX_Y = BORDER_Y + EXTENT_Y - 1;
  /** No button pressed. */
  int NO_BUTTON         = 0;
  /** Hyperspace button pressed. */
  int BUTTON_HYPERSPACE = 0x01;
  /** Fire button pressed. */
  int BUTTON_FIRE       = 0x01 << 1;
  /** Thrust button pressed. */
  int BUTTON_THRUST     = 0x01 << 2;
  /** Left button pressed. */
  int BUTTON_RIGHT      = 0x01 << 3;
  /** Right button pressed. */
  int BUTTON_LEFT       = 0x01 << 4;
  /** Start button pressed (requires mameaster patch). */
  int BUTTON_START      = 0x01 << 5;
  /** Port used by mame. */
  int MAME_PORT = 1979;
  /** Location of score text during play. */
  Point SCORE_LOCATION_GAME  = new Point(160, 852);
  /** Location of score text in highscore and teaser display. */
  Point SCORE_LOCATION_OTHER = new Point(100, 876);
  /** Highscore location in game. */
  Point HIGHSCORE_LOCATION   = new Point(480, 876);
  /** Location of 'some other number in right top'. */
  Point SONIRT_LOCATION      = new Point(768, 876);
  /** Location of name input for hall of fame. */
  Point NAME_INPUT_LOCATION  = new Point(400, 228);
}
