/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyGC {
    public static RubyModule createGCModule(Ruby runtime) {
        RubyModule result = runtime.defineModule("GC");
        runtime.setGC(result);
        result.defineAnnotatedMethods(RubyGC.class);
        return result;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject start(IRubyObject recv) {
        System.gc();
        return recv.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(IRubyObject recv) {
        System.gc();
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject enable(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.enable will not work on JRuby", "GC.enable");
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject disable(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.disable will not work on JRuby", "GC.disable");
        return recv.getRuntime().getNil();
    }
}

