/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private final Node receiverNode;
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        this(position, receiverNode, name, argsNode, null);
    }

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode) {
        super(position, NodeType.CALLNODE);
        this.receiverNode = receiverNode;
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = new CallSite.InlineCachingCallSite(name, CallType.NORMAL);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public void setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        this.callAdapter = new CallSite.InlineCachingCallSite(this.callAdapter.methodName, CallType.NORMAL);
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "CallNode: " + this.getName();
    }
}

