/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Arrays;

public class CodegenUtils {
    public static String c(String p) {
        return p.replace('/', '.');
    }

    public static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    public static String ci(Class n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + CodegenUtils.ci(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + CodegenUtils.p(n) + ";";
    }

    public static String sig(Class retval, Class ... params) {
        StringBuffer signature = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            signature.append(CodegenUtils.ci(params[i]));
        }
        signature.append(")").append(CodegenUtils.ci(retval));
        return signature.toString();
    }

    public static String sig(Class retval) {
        StringBuffer signature = new StringBuffer("()");
        signature.append(CodegenUtils.ci(retval));
        return signature.toString();
    }

    public static Class[] params(Class ... classes) {
        return classes;
    }

    public static Class[] params(Class cls, int times) {
        Object[] classes = new Class[times];
        Arrays.fill(classes, cls);
        return classes;
    }

    public static Class[] params(Class cls1, Class clsFill, int times) {
        Object[] classes = new Class[times + 1];
        Arrays.fill(classes, clsFill);
        classes[0] = cls1;
        return classes;
    }
}

