/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaAccessibleObject
extends RubyObject {
    protected JavaAccessibleObject(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static void registerRubyMethods(Ruby runtime, RubyClass result) {
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaAccessibleObject.class);
        result.defineFastMethod("==", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("eql?", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("equal?", callbackFactory.getFastMethod("same", IRubyObject.class));
        result.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        result.defineFastMethod("accessible?", callbackFactory.getFastMethod("isAccessible"));
        result.defineFastMethod("accessible=", callbackFactory.getFastMethod("setAccessible", IRubyObject.class));
        result.defineFastMethod("annotations", callbackFactory.getFastMethod("annotations"));
        result.defineFastMethod("annotations?", callbackFactory.getFastMethod("annotations_p"));
        result.defineFastMethod("declared_annotations?", callbackFactory.getFastMethod("declared_annotations_p"));
        result.defineFastMethod("annotation", callbackFactory.getFastMethod("annotation", IRubyObject.class));
        result.defineFastMethod("annotation_present?", callbackFactory.getFastMethod("annotation_present_p", IRubyObject.class));
        result.defineFastMethod("declaring_class", callbackFactory.getFastMethod("declaring_class"));
        result.defineFastMethod("modifiers", callbackFactory.getFastMethod("modifiers"));
        result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("synthetic?", callbackFactory.getFastMethod("synthetic_p"));
        result.defineFastMethod("to_string", callbackFactory.getFastMethod("to_string"));
        result.defineFastMethod("to_s", callbackFactory.getFastMethod("to_string"));
    }

    protected abstract AccessibleObject accessibleObject();

    public boolean equals(Object other) {
        return other instanceof JavaAccessibleObject && this.accessibleObject() == ((JavaAccessibleObject)other).accessibleObject();
    }

    public int hashCode() {
        return this.accessibleObject().hashCode();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    public IRubyObject op_equal(IRubyObject other) {
        return other instanceof JavaAccessibleObject && this.accessibleObject().equals(((JavaAccessibleObject)other).accessibleObject()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject same(IRubyObject other) {
        return this.getRuntime().newBoolean(this.equals(other));
    }

    public RubyBoolean isAccessible() {
        return new RubyBoolean(this.getRuntime(), this.accessibleObject().isAccessible());
    }

    public IRubyObject setAccessible(IRubyObject object) {
        this.accessibleObject().setAccessible(object.isTrue());
        return object;
    }

    public IRubyObject annotation(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotation(((JavaClass)annoClass).javaClass()));
    }

    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotations());
    }

    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getAnnotations().length > 0);
    }

    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getDeclaredAnnotations());
    }

    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getDeclaredAnnotations().length > 0);
    }

    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.accessibleObject().isAnnotationPresent(((JavaClass)annoClass).javaClass()));
    }

    public IRubyObject declaring_class() {
        Class<?> clazz = ((Member)((Object)this.accessibleObject())).getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(((Member)((Object)this.accessibleObject())).getModifiers());
    }

    public IRubyObject name() {
        return this.getRuntime().newString(((Member)((Object)this.accessibleObject())).getName());
    }

    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(((Member)((Object)this.accessibleObject())).isSynthetic());
    }

    public RubyString to_string() {
        return this.getRuntime().newString(this.accessibleObject().toString());
    }
}

