/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import org.jruby.Ruby;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyWarnings
implements IRubyWarnings {
    private Ruby runtime;

    public RubyWarnings(Ruby runtime) {
        this.runtime = runtime;
    }

    public void warn(IRubyWarnings.ID id, ISourcePosition position, String message, Object ... data) {
        this.warn(id, position.getFile(), position.getEndLine(), message, data);
    }

    public void warn(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        if (this.runtime.getVerbose().isNil()) {
            return;
        }
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(fileName).append(':').append(lineNumber + 1).append(' ');
        buffer.append("warning: ").append(message).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }

    public boolean isVerbose() {
        return this.runtime.getVerbose().isTrue();
    }

    public void warn(IRubyWarnings.ID id, String message, Object ... data) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warn(id, context.getFile(), context.getLine(), message, data);
    }

    public void warning(IRubyWarnings.ID id, String message, Object ... data) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warning(id, context.getFile(), context.getLine(), message, data);
    }

    public void warning(IRubyWarnings.ID id, ISourcePosition position, String message, Object ... data) {
        this.warning(id, position.getFile(), position.getEndLine(), message, data);
    }

    public void warning(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        if (this.isVerbose()) {
            this.warn(id, fileName, lineNumber, message, data);
        }
    }
}

