require 'zlib'
require 'stringio' 
require '../tracker'

$force = true # need to override game start detection

File.open(ARGV[0]) do |f|
  file = ARGV[0] =~ /\.gz$/ ? Zlib::GzipReader.new(f) : f
  file = StringIO.new(file.read) if file.kind_of? Zlib::GzipReader # need to get seek method
  file.seek(-1025,IO::SEEK_END) # position to last frame
  game = Tracker.new.parse(file.read)
  if game[:score] < 50000 # calculate score from complete game if 99999er warp likely
    tracker = Tracker.new
    file.seek(0x39,IO::SEEK_SET) # position to first frame
    game = tracker.parse(file.read(1025)) until file.eof?
  end
  puts "#{game[:score]} #{ARGV[0]}"
end
