class PlayerState
  def []=(key, value)
    @semaphore.synchronize do
      @state[key] = value
    end
    return value
  end    

  def [](key)
    return_value = nil
    @semaphore.synchronize do
      return_value = @state[key]
    end
    return return_value
  end    

  def get
    return_value = nil
    @semaphore.synchronize do
      return_value = @state.dup
    end
    return return_value
  end

  def initialize
    @semaphore = Mutex.new
    @state = { :strategy => :idle, :hyperjump_count => 0, :valid_targets => [] }
  end
end