class Vector

  SHOT_VELOCITY = 8 # from the forums ... let's trust the guys until further notice :-)

  # translation table from SHIP_DX to possible internal angle index
  # internal angle index has 8 bit resolution
  # 0 is "right" and increases couter-clockwise by (360/256)°
  POSSIBLE_INDICES_BY_SHIP_DX = {
    [-440, -1472]=>[180, 181, 182, 183],
    [-1504, -296]=>[136, 137, 138, 139],
    [-440, 1472]=>[73, 74, 75, 76],
    [0, -1536]=>[192],
    [-1088, -1088]=>[160, 161, 162, 163],
    [-1088, 1088]=>[93, 94, 95, 96],
    [976, 1192]=>[36, 37, 38, 39],
    [-1504, 296]=>[117, 118, 119, 120],
    [0, 1536]=>[64],
    [976, -1192]=>[217, 218, 219, 220],
    [440, -1472]=>[201, 202, 203, 204],
    [-1416, 584]=>[109, 110, 111, 112],
    [-1280, 856]=>[101, 102, 103, 104],
    [-584, 1416]=>[77, 78, 79, 80],
    [440, 1472]=>[52, 53, 54, 55],
    [296, -1504]=>[197, 198, 199, 200],
    [-152, -1528]=>[188, 189, 190, 191],
    [-1360, 720]=>[105, 106, 107, 108],
    [1528, -152]=>[249, 250, 251, 252],
    [1416, -584]=>[237, 238, 239, 240],
    [1280, -856]=>[229, 230, 231, 232],
    [584, -1416]=>[205, 206, 207, 208],
    [-1528, 152]=>[121, 122, 123, 124],
    [-1472, 440]=>[113, 114, 115, 116],
    [-976, 1192]=>[89, 90, 91, 92],
    [-720, 1360]=>[81, 82, 83, 84],
    [-296, 1504]=>[69, 70, 71, 72],
    [1088, 1088]=>[32, 33, 34, 35],
    [-856, -1280]=>[168, 169, 170, 171],
    [152, 1528]=>[60, 61, 62, 63],
    [1536, 0]=>[253, 254, 255, 0, 1, 2, 3],
    [1360, -720]=>[233, 234, 235, 236],
    [-1192, -976]=>[156, 157, 158, 159],
    [-856, 1280]=>[85, 86, 87, 88],
    [720, 1360]=>[44, 45, 46, 47],
    [856, 1280]=>[40, 41, 42, 43],
    [1472, 440]=>[12, 13, 14, 15],
    [1504, 296]=>[8, 9, 10, 11],
    [1504, -296]=>[245, 246, 247, 248],
    [1472, -440]=>[241, 242, 243, 244],
    [856, -1280]=>[213, 214, 215, 216],
    [720, -1360]=>[209, 210, 211, 212],
    [-720, -1360]=>[172, 173, 174, 175],
    [-976, -1192]=>[164, 165, 166, 167],
    [-1472, -440]=>[140, 141, 142, 143],
    [-1528, -152]=>[132, 133, 134, 135],
    [-1536, 0]=>[129, 130, 131, 125, 126, 127, 128],
    [-1192, 976]=>[97, 98, 99, 100],
    [1192, 976]=>[28, 29, 30, 31],
    [1360, 720]=>[20, 21, 22, 23],
    [1192, -976]=>[225, 226, 227, 228],
    [152, -1528]=>[193, 194, 195, 196],
    [-1360, -720]=>[148, 149, 150, 151],
    [-152, 1528]=>[65, 66, 67, 68],
    [296, 1504]=>[56, 57, 58, 59],
    [1088, -1088]=>[221, 222, 223, 224],
    [-296, -1504]=>[184, 185, 186, 187],
    [-584, -1416]=>[176, 177, 178, 179],
    [-1280, -856]=>[152, 153, 154, 155],
    [-1416, -584]=>[144, 145, 146, 147],
    [584, 1416]=>[48, 49, 50, 51],
    [1280, 856]=>[24, 25, 26, 27],
    [1416, 584]=>[16, 17, 18, 19],
    [1528, 152]=>[4, 5, 6, 7]
  }

  # translation table from SHIP_DX to medium internal angle index
  # can be used as approximation when internal angle is not calibrated
  MEDIUM_INDICES_BY_SHIP_DX = {
    [-440, 1472]=>75,
    [-1504, -296]=>138,
    [-440, -1472]=>182,
    [976, 1192]=>38,
    [-1088, 1088]=>95,
    [-1088, -1088]=>162,
    [0, -1536]=>192,
    [-1504, 296]=>119,
    [440, 1472]=>54,
    [-584, 1416]=>79,
    [-1280, 856]=>103,
    [-1416, 584]=>111,
    [440, -1472]=>203,
    [976, -1192]=>219,
    [0, 1536]=>64,
    [-1360, 720]=>107,
    [-152, -1528]=>190,
    [296, -1504]=>199,
    [1088, 1088]=>34,
    [-296, 1504]=>71,
    [-720, 1360]=>83,
    [-976, 1192]=>91,
    [-1472, 440]=>115,
    [-1528, 152]=>123,
    [584, -1416]=>207,
    [1280, -856]=>231,
    [1416, -584]=>239,
    [1528, -152]=>251,
    [1536, 0]=>0,
    [152, 1528]=>62,
    [-856, -1280]=>170,
    [1504, 296]=>10,
    [1472, 440]=>14,
    [856, 1280]=>42,
    [720, 1360]=>46,
    [-856, 1280]=>87,
    [-1192, -976]=>158,
    [1360, -720]=>235,
    [1360, 720]=>22,
    [1192, 976]=>30,
    [-1192, 976]=>99,
    [-1536, 0]=>125,
    [-1528, -152]=>134,
    [-1472, -440]=>142,
    [-976, -1192]=>166,
    [-720, -1360]=>174,
    [720, -1360]=>211,
    [856, -1280]=>215,
    [1472, -440]=>243,
    [1504, -296]=>247,
    [296, 1504]=>58,
    [-152, 1528]=>67,
    [-1360, -720]=>150,
    [152, -1528]=>195,
    [1192, -976]=>227,
    [1528, 152]=>6,
    [1416, 584]=>18,
    [1280, 856]=>26,
    [584, 1416]=>50,
    [-1416, -584]=>146,
    [-1280, -856]=>154,
    [-584, -1416]=>178,
    [-296, -1504]=>186,
    [1088, -1088]=>223
  }
  
  # when ship fires, game[:shot_angle_index] can be used as an index for this
  # table to get shot data (initial d, m, velocity, angle)
  SHOT_ANGLES_BY_INDEX = {
    100=>{:angle_rad_to_ship=>2.46685171136624,
    :angle_rad=>2.45697548927701,
    :initial_dx=>-16,
    :mx=>-6.125,
    :my=>5.0,
    :initial_dy=>12,
    :velocity=>7.90668230043423},
    33=>{:angle_rad_to_ship=>0.811033571919126,
    :angle_rad=>0.807616728724167,
    :initial_dx=>13,
    :mx=>5.5,
    :my=>5.75,
    :initial_dy=>14,
    :velocity=>7.95691523141977},
    234=>{:angle_rad_to_ship=>-0.561163412288352,
    :angle_rad=>-0.548549402450528,
    :initial_dx=>16,
    :mx=>6.75,
    :my=>-4.125,
    :initial_dy=>-11,
    :velocity=>7.91063366614837},
    167=>{:angle_rad_to_ship=>-2.18829856694197,
    :angle_rad=>-2.18922432116742,
    :initial_dx=>-12,
    :mx=>-4.625,
    :my=>-6.5,
    :initial_dy=>-17,
    :velocity=>7.97750744280443},
    134=>{:angle_rad_to_ship=>-2.97449085365869,
    :angle_rad=>-2.9841757808632,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>-1.25,
    :initial_dy=>-4,
    :velocity=>7.97358921690853},
    201=>{:angle_rad_to_ship=>-1.35471135449811,
    :angle_rad=>-1.34871442488942,
    :initial_dx=>4,
    :mx=>1.75,
    :my=>-7.75,
    :initial_dy=>-20,
    :velocity=>7.94512429103535},
    67=>{:angle_rad_to_ship=>1.6559557194146,
    :angle_rad=>1.64999539776435,
    :initial_dx=>-2,
    :mx=>-0.625,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.89976265466248},
    0=>{:angle_rad_to_ship=>0.0,
    :angle_rad=>0.0,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>0.0,
    :initial_dy=>0,
    :velocity=>7.875},
    168=>{:angle_rad_to_ship=>-2.17187008129265,
    :angle_rad=>-2.16745672267221,
    :initial_dx=>-12,
    :mx=>-4.5,
    :my=>-6.625,
    :initial_dy=>-17,
    :velocity=>8.00878423982067},
    34=>{:angle_rad_to_ship=>0.837076247879878,
    :angle_rad=>0.841518946098625,
    :initial_dx=>13,
    :mx=>5.25,
    :my=>5.875,
    :initial_dy=>14,
    :velocity=>7.87896725465971},
    235=>{:angle_rad_to_ship=>-0.52807444842636,
    :angle_rad=>-0.52694322718943,
    :initial_dx=>17,
    :mx=>6.875,
    :my=>-4.0,
    :initial_dy=>-10,
    :velocity=>7.95396913496652},
    101=>{:angle_rad_to_ship=>2.48370404840758,
    :angle_rad=>2.47916635975664,
    :initial_dx=>-16,
    :mx=>-6.25,
    :my=>4.875,
    :initial_dy=>12,
    :velocity=>7.92641943124385},
    135=>{:angle_rad_to_ship=>-2.96279959878687,
    :angle_rad=>-2.96873204680265,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>-1.375,
    :initial_dy=>-4,
    :velocity=>7.99413847765974},
    202=>{:angle_rad_to_ship=>-1.34310700702624,
    :angle_rad=>-1.33342207982173,
    :initial_dx=>4,
    :mx=>1.875,
    :my=>-7.75,
    :initial_dy=>-20,
    :velocity=>7.97358921690853},
    68=>{:angle_rad_to_ship=>1.66804952504646,
    :angle_rad=>1.66574803313765,
    :initial_dx=>-2,
    :mx=>-0.75,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.91063366614837},
    1=>{:angle_rad_to_ship=>0.0121945174482518,
    :angle_rad=>0.01587168299179,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>0.125,
    :initial_dy=>0,
    :velocity=>7.87599200101168},
    102=>{:angle_rad_to_ship=>2.51013915465069,
    :angle_rad=>2.50123618851895,
    :initial_dx=>-16,
    :mx=>-6.375,
    :my=>4.75,
    :initial_dy=>11,
    :velocity=>7.95003930807892},
    35=>{:angle_rad_to_ship=>0.871392454591689,
    :angle_rad=>0.86388826603478,
    :initial_dx=>12,
    :mx=>5.125,
    :my=>6.0,
    :initial_dy=>15,
    :velocity=>7.89085705104331},
    236=>{:angle_rad_to_ship=>-0.501264264871582,
    :angle_rad=>-0.491809175988699,
    :initial_dx=>17,
    :mx=>7.0,
    :my=>-3.75,
    :initial_dy=>-10,
    :velocity=>7.9411900871343},
    169=>{:angle_rad_to_ship=>-2.13570072882567,
    :angle_rad=>-2.13271788905171,
    :initial_dx=>-11,
    :mx=>-4.25,
    :my=>-6.75,
    :initial_dy=>-17,
    :velocity=>7.97652806677191},
    2=>{:angle_rad_to_ship=>0.0365690559135414,
    :angle_rad=>0.0475831032769834,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>0.375,
    :initial_dy=>0,
    :velocity=>7.88392351561074},
    69=>{:angle_rad_to_ship=>1.70414658096645,
    :angle_rad=>1.69710444385814,
    :initial_dx=>-3,
    :mx=>-1.0,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.93823815465371},
    136=>{:angle_rad_to_ship=>-2.9280322201093,
    :angle_rad=>-2.93809960833223,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>-1.625,
    :initial_dy=>-5,
    :velocity=>8.0409110180377},
    203=>{:angle_rad_to_ship=>-1.30558920934307,
    :angle_rad=>-1.2990041681202,
    :initial_dx=>5,
    :mx=>2.125,
    :my=>-7.625,
    :initial_dy=>-20,
    :velocity=>7.91557009949378},
    170=>{:angle_rad_to_ship=>-2.11322789678485,
    :angle_rad=>-2.11121582706548,
    :initial_dx=>-11,
    :mx=>-4.125,
    :my=>-6.875,
    :initial_dy=>-18,
    :velocity=>8.01755885541229},
    103=>{:angle_rad_to_ship=>2.54362360263602,
    :angle_rad=>2.53604798998482,
    :initial_dx=>-17,
    :mx=>-6.5,
    :my=>4.5,
    :initial_dy=>11,
    :velocity=>7.90569415042095},
    36=>{:angle_rad_to_ship=>0.888479771920149,
    :angle_rad=>0.886179162482116,
    :initial_dx=>12,
    :mx=>5.0,
    :my=>6.125,
    :initial_dy=>15,
    :velocity=>7.90668230043423},
    237=>{:angle_rad_to_ship=>-0.490668058188071,
    :angle_rad=>-0.477831054992115,
    :initial_dx=>17,
    :mx=>7.0,
    :my=>-3.625,
    :initial_dy=>-10,
    :velocity=>7.88293251271378},
    137=>{:angle_rad_to_ship=>-2.91390333382114,
    :angle_rad=>-2.91951075168431,
    :initial_dx=>-20,
    :mx=>-7.75,
    :my=>-1.75,
    :initial_dy=>-5,
    :velocity=>7.94512429103535},
    70=>{:angle_rad_to_ship=>1.73989755279627,
    :angle_rad=>1.72821319952149,
    :initial_dx=>-4,
    :mx=>-1.25,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.97358921690853},
    3=>{:angle_rad_to_ship=>0.060900208277988,
    :angle_rad=>0.063406951966832,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>0.5,
    :initial_dy=>1,
    :velocity=>7.89085705104331},
    204=>{:angle_rad_to_ship=>-1.294127987713,
    :angle_rad=>-1.28385757386413,
    :initial_dx=>5,
    :mx=>2.25,
    :my=>-7.625,
    :initial_dy=>-20,
    :velocity=>7.95003930807892},
    238=>{:angle_rad_to_ship=>-0.452778471823536,
    :angle_rad=>-0.442374222976745,
    :initial_dx=>17,
    :mx=>7.125,
    :my=>-3.375,
    :initial_dy=>-9,
    :velocity=>7.88392351561074},
    104=>{:angle_rad_to_ship=>2.57025517375617,
    :angle_rad=>2.55795683451263,
    :initial_dx=>-17,
    :mx=>-6.625,
    :my=>4.375,
    :initial_dy=>10,
    :velocity=>7.93922225410021},
    171=>{:angle_rad_to_ship=>-2.08702699740664,
    :angle_rad=>-2.08994244104142,
    :initial_dx=>-10,
    :mx=>-4.0,
    :my=>-7.0,
    :initial_dy=>-18,
    :velocity=>8.06225774829855},
    37=>{:angle_rad_to_ship=>0.905506898964361,
    :angle_rad=>0.908370032961746,
    :initial_dx=>12,
    :mx=>4.875,
    :my=>6.25,
    :initial_dy=>15,
    :velocity=>7.92641943124385},
    4=>{:angle_rad_to_ship=>0.0851593926197067,
    :angle_rad=>0.0949517063427563,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>0.75,
    :initial_dy=>1,
    :velocity=>7.91063366614837},
    71=>{:angle_rad_to_ship=>1.75390714405738,
    :angle_rad=>1.74638848874508,
    :initial_dx=>-4,
    :mx=>-1.375,
    :my=>7.75,
    :initial_dy=>19,
    :velocity=>7.87103074571558},
    138=>{:angle_rad_to_ship=>-2.89088339416838,
    :angle_rad=>-2.88903837781173,
    :initial_dx=>-20,
    :mx=>-7.75,
    :my=>-2.0,
    :initial_dy=>-5,
    :velocity=>8.00390529679106},
    205=>{:angle_rad_to_ship=>-1.26019772642387,
    :angle_rad=>-1.25397184092668,
    :initial_dx=>6,
    :mx=>2.5,
    :my=>-7.625,
    :initial_dy=>-20,
    :velocity=>8.02437692285202},
    239=>{:angle_rad_to_ship=>-0.431573051223505,
    :angle_rad=>-0.421419206887804,
    :initial_dx=>18,
    :mx=>7.25,
    :my=>-3.25,
    :initial_dy=>-9,
    :velocity=>7.94512429103535},
    105=>{:angle_rad_to_ship=>2.5868004264519,
    :angle_rad=>2.57967109133298,
    :initial_dx=>-17,
    :mx=>-6.75,
    :my=>4.25,
    :initial_dy=>10,
    :velocity=>7.97652806677191},
    172=>{:angle_rad_to_ship=>-2.06634800028073,
    :angle_rad=>-2.0626055027836,
    :initial_dx=>-10,
    :mx=>-3.75,
    :my=>-7.0,
    :initial_dy=>-18,
    :velocity=>7.9411900871343},
    38=>{:angle_rad_to_ship=>0.932161359640912,
    :angle_rad=>0.930439861724054,
    :initial_dx=>11,
    :mx=>4.75,
    :my=>6.375,
    :initial_dy=>15,
    :velocity=>7.95003930807892},
    5=>{:angle_rad_to_ship=>0.121352000570764,
    :angle_rad=>0.12630811706324,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>1.0,
    :initial_dy=>2,
    :velocity=>7.93823815465371},
    72=>{:angle_rad_to_ship=>1.78946527266884,
    :angle_rad=>1.77747954527915,
    :initial_dx=>-5,
    :mx=>-1.625,
    :my=>7.75,
    :initial_dy=>19,
    :velocity=>7.91853048235593},
    139=>{:angle_rad_to_ship=>-2.8649243145079,
    :angle_rad=>-2.86980049491509,
    :initial_dx=>-20,
    :mx=>-7.625,
    :my=>-2.125,
    :initial_dy=>-6,
    :velocity=>7.91557009949378},
    206=>{:angle_rad_to_ship=>-1.24147015974706,
    :angle_rad=>-1.23412150740817,
    :initial_dx=>6,
    :mx=>2.625,
    :my=>-7.5,
    :initial_dy=>-19,
    :velocity=>7.94610753765641},
    106=>{:angle_rad_to_ship=>2.61950103976151,
    :angle_rad=>2.61464942640036,
    :initial_dx=>-18,
    :mx=>-6.875,
    :my=>4.0,
    :initial_dy=>10,
    :velocity=>7.95396913496652},
    173=>{:angle_rad_to_ship=>-2.05031561878749,
    :angle_rad=>-2.04143682880104,
    :initial_dx=>-10,
    :mx=>-3.625,
    :my=>-7.125,
    :initial_dy=>-18,
    :velocity=>7.99413847765974},
    39=>{:angle_rad_to_ship=>0.966016773981716,
    :angle_rad=>0.965251663189927,
    :initial_dx=>11,
    :mx=>4.5,
    :my=>6.5,
    :initial_dy=>16,
    :velocity=>7.90569415042095},
    240=>{:angle_rad_to_ship=>-0.409646108624838,
    :angle_rad=>-0.406970785368771,
    :initial_dx=>18,
    :mx=>7.25,
    :my=>-3.125,
    :initial_dy=>-8,
    :velocity=>7.89481633731906},
    140=>{:angle_rad_to_ship=>-2.84222641953244,
    :angle_rad=>-2.83964149175954,
    :initial_dx=>-20,
    :mx=>-7.625,
    :my=>-2.375,
    :initial_dy=>-6,
    :velocity=>7.98631642248164},
    73=>{:angle_rad_to_ship=>1.80119876285376,
    :angle_rad=>1.79287822870038,
    :initial_dx=>-5,
    :mx=>-1.75,
    :my=>7.75,
    :initial_dy=>19,
    :velocity=>7.94512429103535},
    6=>{:angle_rad_to_ship=>0.133350254171552,
    :angle_rad=>0.141897054604164,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>1.125,
    :initial_dy=>2,
    :velocity=>7.95495128834866},
    207=>{:angle_rad_to_ship=>-1.20362249297668,
    :angle_rad=>-1.19908737667631,
    :initial_dx=>7,
    :mx=>2.875,
    :my=>-7.375,
    :initial_dy=>-19,
    :velocity=>7.91557009949378},
    107=>{:angle_rad_to_ship=>2.64604098010397,
    :angle_rad=>2.63601159871559,
    :initial_dx=>-18,
    :mx=>-7.0,
    :my=>3.875,
    :initial_dy=>9,
    :velocity=>8.00097650290263},
    174=>{:angle_rad_to_ship=>-2.00813421854278,
    :angle_rad=>-2.00647919982584,
    :initial_dx=>-9,
    :mx=>-3.375,
    :my=>-7.25,
    :initial_dy=>-19,
    :velocity=>7.99706977586166},
    40=>{:angle_rad_to_ship=>0.992894389832651,
    :angle_rad=>0.987160507717735,
    :initial_dx=>10,
    :mx=>4.375,
    :my=>6.625,
    :initial_dy=>16,
    :velocity=>7.93922225410021},
    241=>{:angle_rad_to_ship=>-0.382743509845576,
    :angle_rad=>-0.371708950118585,
    :initial_dx=>18,
    :mx=>7.375,
    :my=>-2.875,
    :initial_dy=>-8,
    :velocity=>7.91557009949378},
    141=>{:angle_rad_to_ship=>-2.81984209919315,
    :angle_rad=>-2.82476816772157,
    :initial_dx=>-20,
    :mx=>-7.625,
    :my=>-2.5,
    :initial_dy=>-7,
    :velocity=>8.02437692285202},
    7=>{:angle_rad_to_ship=>0.171148605416182,
    :angle_rad=>0.17559216195018,
    :initial_dx=>19,
    :mx=>7.75,
    :my=>1.375,
    :initial_dy=>3,
    :velocity=>7.87103074571558},
    208=>{:angle_rad_to_ship=>-1.19250233545344,
    :angle_rad=>-1.18445911197358,
    :initial_dx=>7,
    :mx=>3.0,
    :my=>-7.375,
    :initial_dy=>-19,
    :velocity=>7.96182296964709},
    74=>{:angle_rad_to_ship=>1.82750465722828,
    :angle_rad=>1.82731293943922,
    :initial_dx=>-5,
    :mx=>-2.0,
    :my=>7.625,
    :initial_dy=>19,
    :velocity=>7.88293251271378},
    175=>{:angle_rad_to_ship=>-1.99742381992177,
    :angle_rad=>-1.9922155336827,
    :initial_dx=>-9,
    :mx=>-3.25,
    :my=>-7.25,
    :initial_dy=>-19,
    :velocity=>7.94512429103535},
    108=>{:angle_rad_to_ship=>2.65655793173726,
    :angle_rad=>2.6497834776011,
    :initial_dx=>-18,
    :mx=>-7.0,
    :my=>3.75,
    :initial_dy=>9,
    :velocity=>7.9411900871343},
    41=>{:angle_rad_to_ship=>1.00312990242302,
    :angle_rad=>1.00041304514495,
    :initial_dx=>10,
    :mx=>4.25,
    :my=>6.625,
    :initial_dy=>16,
    :velocity=>7.87103074571558},
    242=>{:angle_rad_to_ship=>-0.355957738167985,
    :angle_rad=>-0.351444794003552,
    :initial_dx=>18,
    :mx=>7.5,
    :my=>-2.75,
    :initial_dy=>-7,
    :velocity=>7.98827265433523},
    142=>{:angle_rad_to_ship=>-2.78977597414411,
    :angle_rad=>-2.79014785958624,
    :initial_dx=>-19,
    :mx=>-7.5,
    :my=>-2.75,
    :initial_dy=>-7,
    :velocity=>7.98827265433523},
    8=>{:angle_rad_to_ship=>0.183110817262484,
    :angle_rad=>0.191184459597014,
    :initial_dx=>19,
    :mx=>7.75,
    :my=>1.5,
    :initial_dy=>3,
    :velocity=>7.89382670192347},
    209=>{:angle_rad_to_ship=>-1.17692771605854,
    :angle_rad=>-1.16382554142613,
    :initial_dx=>7,
    :mx=>3.125,
    :my=>-7.25,
    :initial_dy=>-19,
    :velocity=>7.89481633731906},
    75=>{:angle_rad_to_ship=>1.85074614931869,
    :angle_rad=>1.8425884854696,
    :initial_dx=>-6,
    :mx=>-2.125,
    :my=>7.625,
    :initial_dy=>19,
    :velocity=>7.91557009949378},
    109=>{:angle_rad_to_ship=>2.69407267843262,
    :angle_rad=>2.6849871816973,
    :initial_dx=>-18,
    :mx=>-7.125,
    :my=>3.5,
    :initial_dy=>8,
    :velocity=>7.93823815465371},
    176=>{:angle_rad_to_ship=>-1.97103698382887,
    :angle_rad=>-1.97158977537013,
    :initial_dx=>-8,
    :mx=>-3.125,
    :my=>-7.375,
    :initial_dy=>-19,
    :velocity=>8.0097596718004},
    42=>{:angle_rad_to_ship=>1.03037682652431,
    :angle_rad=>1.0358412530088,
    :initial_dx=>10,
    :mx=>4.0,
    :my=>6.75,
    :initial_dy=>16,
    :velocity=>7.84617741323761},
    243=>{:angle_rad_to_ship=>-0.333244301111673,
    :angle_rad=>-0.321750554396642,
    :initial_dx=>18,
    :mx=>7.5,
    :my=>-2.5,
    :initial_dy=>-7,
    :velocity=>7.90569415042095},
    143=>{:angle_rad_to_ship=>-2.76329866224833,
    :angle_rad=>-2.76988370347121,
    :initial_dx=>-19,
    :mx=>-7.375,
    :my=>-2.875,
    :initial_dy=>-8,
    :velocity=>7.91557009949378},
    9=>{:angle_rad_to_ship=>0.218668945873942,
    :angle_rad=>0.22208190190548,
    :initial_dx=>19,
    :mx=>7.75,
    :my=>1.75,
    :initial_dy=>4,
    :velocity=>7.94512429103535},
    210=>{:angle_rad_to_ship=>-1.14416883366802,
    :angle_rad=>-1.13511345376396,
    :initial_dx=>8,
    :mx=>3.375,
    :my=>-7.25,
    :initial_dy=>-19,
    :velocity=>7.99706977586166},
    76=>{:angle_rad_to_ship=>1.87368119516987,
    :angle_rad=>1.87274748862515,
    :initial_dx=>-6,
    :mx=>-2.375,
    :my=>7.625,
    :initial_dy=>19,
    :velocity=>7.98631642248164},
    110=>{:angle_rad_to_ship=>2.71496516046292,
    :angle_rad=>2.70590978055885,
    :initial_dx=>-19,
    :mx=>-7.25,
    :my=>3.375,
    :initial_dy=>8,
    :velocity=>7.99706977586166},
    177=>{:angle_rad_to_ship=>-1.94909031813636,
    :angle_rad=>-1.94250527691348,
    :initial_dx=>-8,
    :mx=>-2.875,
    :my=>-7.375,
    :initial_dy=>-19,
    :velocity=>7.91557009949378},
    43=>{:angle_rad_to_ship=>1.06369782240256,
    :angle_rad=>1.05754405392864,
    :initial_dx=>9,
    :mx=>3.875,
    :my=>6.875,
    :initial_dy=>17,
    :velocity=>7.8918470588323},
    244=>{:angle_rad_to_ship=>-0.302884868374971,
    :angle_rad=>-0.301951161830249,
    :initial_dx=>19,
    :mx=>7.625,
    :my=>-2.375,
    :initial_dy=>-6,
    :velocity=>7.98631642248164},
    144=>{:angle_rad_to_ship=>-2.74135199655582,
    :angle_rad=>-2.74079920501456,
    :initial_dx=>-19,
    :mx=>-7.375,
    :my=>-3.125,
    :initial_dy=>-8,
    :velocity=>8.0097596718004},
    10=>{:angle_rad_to_ship=>0.233179800646816,
    :angle_rad=>0.241117678451468,
    :initial_dx=>19,
    :mx=>7.625,
    :my=>1.875,
    :initial_dy=>4,
    :velocity=>7.85214938726971},
    211=>{:angle_rad_to_ship=>-1.12327635163773,
    :angle_rad=>-1.1141908549024,
    :initial_dx=>8,
    :mx=>3.5,
    :my=>-7.125,
    :initial_dy=>-18,
    :velocity=>7.93823815465371},
    77=>{:angle_rad_to_ship=>1.90404062790657,
    :angle_rad=>1.89254688119154,
    :initial_dx=>-7,
    :mx=>-2.5,
    :my=>7.5,
    :initial_dy=>18,
    :velocity=>7.90569415042095},
    178=>{:angle_rad_to_ship=>-1.92261300624058,
    :angle_rad=>-1.92224112079845,
    :initial_dx=>-7,
    :mx=>-2.75,
    :my=>-7.5,
    :initial_dy=>-19,
    :velocity=>7.98827265433523},
    44=>{:angle_rad_to_ship=>1.08012826860683,
    :angle_rad=>1.0789871508062,
    :initial_dx=>9,
    :mx=>3.75,
    :my=>7.0,
    :initial_dy=>17,
    :velocity=>7.9411900871343},
    245=>{:angle_rad_to_ship=>-0.279949822523791,
    :angle_rad=>-0.271792158674699,
    :initial_dx=>19,
    :mx=>7.625,
    :my=>-2.125,
    :initial_dy=>-6,
    :velocity=>7.91557009949378},
    111=>{:angle_rad_to_ship=>2.74772404285343,
    :angle_rad=>2.73462186822102,
    :initial_dx=>-19,
    :mx=>-7.25,
    :my=>3.125,
    :initial_dy=>7,
    :velocity=>7.89481633731906},
    145=>{:angle_rad_to_ship=>-2.71496516046292,
    :angle_rad=>-2.72017344670199,
    :initial_dx=>-19,
    :mx=>-7.25,
    :my=>-3.25,
    :initial_dy=>-9,
    :velocity=>7.94512429103535},
    11=>{:angle_rad_to_ship=>0.268366210905907,
    :angle_rad=>0.271792158674699,
    :initial_dx=>19,
    :mx=>7.625,
    :my=>2.125,
    :initial_dy=>5,
    :velocity=>7.91557009949378},
    212=>{:angle_rad_to_ship=>-1.08576160494236,
    :angle_rad=>-1.0789871508062,
    :initial_dx=>9,
    :mx=>3.75,
    :my=>-7.0,
    :initial_dy=>-18,
    :velocity=>7.9411900871343},
    78=>{:angle_rad_to_ship=>1.92675406496288,
    :angle_rad=>1.92224112079845,
    :initial_dx=>-7,
    :mx=>-2.75,
    :my=>7.5,
    :initial_dy=>18,
    :velocity=>7.98827265433523},
    179=>{:angle_rad_to_ship=>-1.89254688119154,
    :angle_rad=>-1.88762081266312,
    :initial_dx=>-7,
    :mx=>-2.5,
    :my=>-7.625,
    :initial_dy=>-20,
    :velocity=>8.02437692285202},
    45=>{:angle_rad_to_ship=>1.11264316799731,
    :angle_rad=>1.10714871779409,
    :initial_dx=>8,
    :mx=>3.5,
    :my=>7.0,
    :initial_dy=>17,
    :velocity=>7.82623792124926},
    246=>{:angle_rad_to_ship=>-0.256708330433386,
    :angle_rad=>-0.256516612644324,
    :initial_dx=>19,
    :mx=>7.625,
    :my=>-2.0,
    :initial_dy=>-5,
    :velocity=>7.88293251271378},
    112=>{:angle_rad_to_ship=>2.76329866224833,
    :angle_rad=>2.75525543876848,
    :initial_dx=>-19,
    :mx=>-7.375,
    :my=>3.0,
    :initial_dy=>7,
    :velocity=>7.96182296964709},
    146=>{:angle_rad_to_ship=>-2.70425476184191,
    :angle_rad=>-2.70590978055885,
    :initial_dx=>-19,
    :mx=>-7.25,
    :my=>-3.375,
    :initial_dy=>-9,
    :velocity=>7.99706977586166},
    12=>{:angle_rad_to_ship=>0.279949822523791,
    :angle_rad=>0.286938752930769,
    :initial_dx=>19,
    :mx=>7.625,
    :my=>2.25,
    :initial_dy=>5,
    :velocity=>7.95003930807892},
    213=>{:angle_rad_to_ship=>-1.07524465330907,
    :angle_rad=>-1.06521527192069,
    :initial_dx=>9,
    :mx=>3.875,
    :my=>-7.0,
    :initial_dy=>-18,
    :velocity=>8.00097650290263},
    79=>{:angle_rad_to_ship=>1.95353983664047,
    :angle_rad=>1.94250527691348,
    :initial_dx=>-8,
    :mx=>-2.875,
    :my=>7.375,
    :initial_dy=>18,
    :velocity=>7.91557009949378},
    180=>{:angle_rad_to_ship=>-1.87016256085225,
    :angle_rad=>-1.87274748862515,
    :initial_dx=>-6,
    :mx=>-2.375,
    :my=>-7.625,
    :initial_dy=>-20,
    :velocity=>7.98631642248164},
    46=>{:angle_rad_to_ship=>1.12900316127745,
    :angle_rad=>1.12842210381815,
    :initial_dx=>8,
    :mx=>3.375,
    :my=>7.125,
    :initial_dy=>17,
    :velocity=>7.88392351561074},
    247=>{:angle_rad_to_ship=>-0.230402436058862,
    :angle_rad=>-0.22208190190548,
    :initial_dx=>19,
    :mx=>7.75,
    :my=>-1.75,
    :initial_dy=>-5,
    :velocity=>7.94512429103535},
    113=>{:angle_rad_to_ship=>2.77441881977157,
    :angle_rad=>2.76988370347121,
    :initial_dx=>-19,
    :mx=>-7.375,
    :my=>2.875,
    :initial_dy=>7,
    :velocity=>7.91557009949378},
    147=>{:angle_rad_to_ship=>-2.6620733615972,
    :angle_rad=>-2.67095215158365,
    :initial_dx=>-18,
    :mx=>-7.125,
    :my=>-3.625,
    :initial_dy=>-10,
    :velocity=>7.99413847765974},
    13=>{:angle_rad_to_ship=>0.321750554396642,
    :angle_rad=>0.321750554396642,
    :initial_dx=>18,
    :mx=>7.5,
    :my=>2.5,
    :initial_dy=>6,
    :velocity=>7.90569415042095},
    214=>{:angle_rad_to_ship=>-1.04870471296661,
    :angle_rad=>-1.04385309960547,
    :initial_dx=>10,
    :mx=>4.0,
    :my=>-6.875,
    :initial_dy=>-18,
    :velocity=>7.95396913496652},
    80=>{:angle_rad_to_ship=>1.98044243541973,
    :angle_rad=>1.97776711216367,
    :initial_dx=>-8,
    :mx=>-3.125,
    :my=>7.25,
    :initial_dy=>18,
    :velocity=>7.89481633731906},
    181=>{:angle_rad_to_ship=>-1.84746466587679,
    :angle_rad=>-1.8425884854696,
    :initial_dx=>-6,
    :mx=>-2.125,
    :my=>-7.625,
    :initial_dy=>-20,
    :velocity=>7.91557009949378},
    47=>{:angle_rad_to_ship=>1.17227388112848,
    :angle_rad=>1.16382554142613,
    :initial_dx=>7,
    :mx=>3.125,
    :my=>7.25,
    :initial_dy=>18,
    :velocity=>7.89481633731906},
    248=>{:angle_rad_to_ship=>-0.218668945873942,
    :angle_rad=>-0.206683218484249,
    :initial_dx=>19,
    :mx=>7.75,
    :my=>-1.625,
    :initial_dy=>-5,
    :velocity=>7.91853048235593},
    114=>{:angle_rad_to_ship=>2.81226648654196,
    :angle_rad=>2.80491783420307,
    :initial_dx=>-19,
    :mx=>-7.5,
    :my=>2.625,
    :initial_dy=>6,
    :velocity=>7.94610753765641},
    14=>{:angle_rad_to_ship=>0.333244301111673,
    :angle_rad=>0.336674819386727,
    :initial_dx=>18,
    :mx=>7.5,
    :my=>2.625,
    :initial_dy=>6,
    :velocity=>7.94610753765641},
    215=>{:angle_rad_to_ship=>-1.016004099657,
    :angle_rad=>-1.00887476453808,
    :initial_dx=>10,
    :mx=>4.25,
    :my=>-6.75,
    :initial_dy=>-17,
    :velocity=>7.97652806677191},
    81=>{:angle_rad_to_ship=>2.0023693780184,
    :angle_rad=>1.9922155336827,
    :initial_dx=>-9,
    :mx=>-3.25,
    :my=>7.25,
    :initial_dy=>18,
    :velocity=>7.94512429103535},
    148=>{:angle_rad_to_ship=>-2.64604098010397,
    :angle_rad=>-2.6497834776011,
    :initial_dx=>-18,
    :mx=>-7.0,
    :my=>-3.75,
    :initial_dy=>-10,
    :velocity=>7.9411900871343},
    182=>{:angle_rad_to_ship=>-1.82150558621631,
    :angle_rad=>-1.82335060257296,
    :initial_dx=>-5,
    :mx=>-2.0,
    :my=>-7.75,
    :initial_dy=>-20,
    :velocity=>8.00390529679106},
    48=>{:angle_rad_to_ship=>1.18350272358882,
    :angle_rad=>1.17845618257938,
    :initial_dx=>7,
    :mx=>3.0,
    :my=>7.25,
    :initial_dy=>18,
    :velocity=>7.84617741323761},
    249=>{:angle_rad_to_ship=>-0.183110817262484,
    :angle_rad=>-0.17559216195018,
    :initial_dx=>19,
    :mx=>7.75,
    :my=>-1.375,
    :initial_dy=>-4,
    :velocity=>7.87103074571558},
    115=>{:angle_rad_to_ship=>2.83099405321877,
    :angle_rad=>2.82476816772157,
    :initial_dx=>-20,
    :mx=>-7.625,
    :my=>2.5,
    :initial_dy=>6,
    :velocity=>8.02437692285202},
    82=>{:angle_rad_to_ship=>2.02357479861843,
    :angle_rad=>2.01317054977164,
    :initial_dx=>-9,
    :mx=>-3.375,
    :my=>7.125,
    :initial_dy=>17,
    :velocity=>7.88392351561074},
    15=>{:angle_rad_to_ship=>0.371517855146709,
    :angle_rad=>0.371708950118585,
    :initial_dx=>18,
    :mx=>7.375,
    :my=>2.875,
    :initial_dy=>7,
    :velocity=>7.91557009949378},
    216=>{:angle_rad_to_ship=>-0.99945884696127,
    :angle_rad=>-0.987160507717735,
    :initial_dx=>10,
    :mx=>4.375,
    :my=>-6.625,
    :initial_dy=>-17,
    :velocity=>7.93922225410021},
    149=>{:angle_rad_to_ship=>-2.62536198297805,
    :angle_rad=>-2.62244653934327,
    :initial_dx=>-18,
    :mx=>-7.0,
    :my=>-4.0,
    :initial_dy=>-10,
    :velocity=>8.06225774829855},
    183=>{:angle_rad_to_ship=>-1.79848564656355,
    :angle_rad=>-1.79287822870038,
    :initial_dx=>-5,
    :mx=>-1.75,
    :my=>-7.75,
    :initial_dy=>-20,
    :velocity=>7.94512429103535},
    49=>{:angle_rad_to_ship=>1.19927847164819,
    :angle_rad=>1.19908737667631,
    :initial_dx=>7,
    :mx=>2.875,
    :my=>7.375,
    :initial_dy=>18,
    :velocity=>7.91557009949378},
    250=>{:angle_rad_to_ship=>-0.169101226001377,
    :angle_rad=>-0.157416872726591,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>-1.25,
    :initial_dy=>-4,
    :velocity=>7.97358921690853},
    116=>{:angle_rad_to_ship=>2.8649243145079,
    :angle_rad=>2.85465390065902,
    :initial_dx=>-20,
    :mx=>-7.625,
    :my=>2.25,
    :initial_dy=>5,
    :velocity=>7.95003930807892},
    83=>{:angle_rad_to_ship=>2.06146438498297,
    :angle_rad=>2.04862738178701,
    :initial_dx=>-10,
    :mx=>-3.625,
    :my=>7.0,
    :initial_dy=>17,
    :velocity=>7.88293251271378},
    150=>{:angle_rad_to_ship=>-2.59916108359984,
    :angle_rad=>-2.60117315331921,
    :initial_dx=>-18,
    :mx=>-6.875,
    :my=>-4.125,
    :initial_dy=>-11,
    :velocity=>8.01755885541229},
    16=>{:angle_rad_to_ship=>0.387293603206076,
    :angle_rad=>0.392340144215516,
    :initial_dx=>18,
    :mx=>7.25,
    :my=>3.0,
    :initial_dy=>7,
    :velocity=>7.84617741323761},
    217=>{:angle_rad_to_ship=>-0.972827275841122,
    :angle_rad=>-0.965251663189927,
    :initial_dx=>11,
    :mx=>4.5,
    :my=>-6.5,
    :initial_dy=>-17,
    :velocity=>7.90569415042095},
    184=>{:angle_rad_to_ship=>-1.78435676027539,
    :angle_rad=>-1.77428937205246,
    :initial_dx=>-5,
    :mx=>-1.625,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>8.0409110180377},
    50=>{:angle_rad_to_ship=>1.23755202568322,
    :angle_rad=>1.23412150740817,
    :initial_dx=>6,
    :mx=>2.625,
    :my=>7.5,
    :initial_dy=>18,
    :velocity=>7.94610753765641},
    251=>{:angle_rad_to_ship=>-0.133350254171552,
    :angle_rad=>-0.12630811706324,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>-1.0,
    :initial_dy=>-3,
    :velocity=>7.93823815465371},
    117=>{:angle_rad_to_ship=>2.87638553613797,
    :angle_rad=>2.86980049491509,
    :initial_dx=>-20,
    :mx=>-7.625,
    :my=>2.125,
    :initial_dy=>5,
    :velocity=>7.91557009949378},
    218=>{:angle_rad_to_ship=>-0.939342827855798,
    :angle_rad=>-0.930439861724054,
    :initial_dx=>11,
    :mx=>4.75,
    :my=>-6.375,
    :initial_dy=>-16,
    :velocity=>7.95003930807892},
    17=>{:angle_rad_to_ship=>0.39852244566642,
    :angle_rad=>0.406970785368771,
    :initial_dx=>18,
    :mx=>7.25,
    :my=>3.125,
    :initial_dy=>7,
    :velocity=>7.89481633731906},
    84=>{:angle_rad_to_ship=>2.07206059166648,
    :angle_rad=>2.0626055027836,
    :initial_dx=>-10,
    :mx=>-3.75,
    :my=>7.0,
    :initial_dy=>17,
    :velocity=>7.9411900871343},
    151=>{:angle_rad_to_ship=>-2.57668825155902,
    :angle_rad=>-2.57967109133298,
    :initial_dx=>-17,
    :mx=>-6.75,
    :my=>-4.25,
    :initial_dy=>-11,
    :velocity=>7.97652806677191},
    51=>{:angle_rad_to_ship=>1.24904577239825,
    :angle_rad=>1.24904577239825,
    :initial_dx=>6,
    :mx=>2.5,
    :my=>7.5,
    :initial_dy=>18,
    :velocity=>7.90569415042095},
    252=>{:angle_rad_to_ship=>-0.0972531982515658,
    :angle_rad=>-0.0949517063427563,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>-0.75,
    :initial_dy=>-2,
    :velocity=>7.91063366614837},
    118=>{:angle_rad_to_ship=>2.91390333382114,
    :angle_rad=>2.90421840661662,
    :initial_dx=>-20,
    :mx=>-7.75,
    :my=>1.875,
    :initial_dy=>4,
    :velocity=>7.97358921690853},
    185=>{:angle_rad_to_ship=>-1.74958938159782,
    :angle_rad=>-1.74365693358204,
    :initial_dx=>-4,
    :mx=>-1.375,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.99413847765974},
    219=>{:angle_rad_to_ship=>-0.912907721612687,
    :angle_rad=>-0.908370032961746,
    :initial_dx=>12,
    :mx=>4.875,
    :my=>-6.25,
    :initial_dy=>-16,
    :velocity=>7.92641943124385},
    85=>{:angle_rad_to_ship=>2.09887077522126,
    :angle_rad=>2.09773955398433,
    :initial_dx=>-10,
    :mx=>-4.0,
    :my=>6.875,
    :initial_dy=>17,
    :velocity=>7.95396913496652},
    152=>{:angle_rad_to_ship=>-2.54051889909204,
    :angle_rad=>-2.54493225771248,
    :initial_dx=>-17,
    :mx=>-6.625,
    :my=>-4.5,
    :initial_dy=>-12,
    :velocity=>8.00878423982067},
    18=>{:angle_rad_to_ship=>0.441793165517444,
    :angle_rad=>0.442374222976745,
    :initial_dx=>17,
    :mx=>7.125,
    :my=>3.375,
    :initial_dy=>8,
    :velocity=>7.88392351561074},
    52=>{:angle_rad_to_ship=>1.29084650427111,
    :angle_rad=>1.28385757386413,
    :initial_dx=>5,
    :mx=>2.25,
    :my=>7.625,
    :initial_dy=>19,
    :velocity=>7.95003930807892},
    253=>{:angle_rad_to_ship=>-0.0851593926197067,
    :angle_rad=>-0.0791990709694515,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>-0.625,
    :initial_dy=>-2,
    :velocity=>7.89976265466248},
    119=>{:angle_rad_to_ship=>2.92550768129301,
    :angle_rad=>2.91951075168431,
    :initial_dx=>-20,
    :mx=>-7.75,
    :my=>1.75,
    :initial_dy=>4,
    :velocity=>7.94512429103535},
    186=>{:angle_rad_to_ship=>-1.737898126726,
    :angle_rad=>-1.72821319952149,
    :initial_dx=>-4,
    :mx=>-1.25,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.97358921690853},
    220=>{:angle_rad_to_ship=>-0.896055384571344,
    :angle_rad=>-0.886179162482116,
    :initial_dx=>12,
    :mx=>5.0,
    :my=>-6.125,
    :initial_dy=>-16,
    :velocity=>7.90668230043423},
    86=>{:angle_rad_to_ship=>2.13195973908325,
    :angle_rad=>2.11934572924542,
    :initial_dx=>-11,
    :mx=>-4.125,
    :my=>6.75,
    :initial_dy=>16,
    :velocity=>7.91063366614837},
    153=>{:angle_rad_to_ship=>-2.52409041344272,
    :angle_rad=>-2.52316465921727,
    :initial_dx=>-17,
    :mx=>-6.5,
    :my=>-4.625,
    :initial_dy=>-12,
    :velocity=>7.97750744280443},
    19=>{:angle_rad_to_ship=>0.45815315879759,
    :angle_rad=>0.463647609000806,
    :initial_dx=>17,
    :mx=>7.0,
    :my=>3.5,
    :initial_dy=>8,
    :velocity=>7.82623792124926},
    53=>{:angle_rad_to_ship=>1.30243011588899,
    :angle_rad=>1.2990041681202,
    :initial_dx=>5,
    :mx=>2.125,
    :my=>7.625,
    :initial_dy=>19,
    :velocity=>7.91557009949378},
    254=>{:angle_rad_to_ship=>-0.0487418513099316,
    :angle_rad=>-0.0475831032769834,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>-0.375,
    :initial_dy=>-1,
    :velocity=>7.88392351561074},
    120=>{:angle_rad_to_ship=>2.96279959878687,
    :angle_rad=>2.95337114828502,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>1.5,
    :initial_dy=>3,
    :velocity=>8.01658437241198},
    187=>{:angle_rad_to_ship=>-1.70255859327282,
    :angle_rad=>-1.69710444385814,
    :initial_dx=>-3,
    :mx=>-1.0,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.93823815465371},
    221=>{:angle_rad_to_ship=>-0.871392454591689,
    :angle_rad=>-0.86388826603478,
    :initial_dx=>12,
    :mx=>5.125,
    :my=>-6.0,
    :initial_dy=>-15,
    :velocity=>7.89085705104331},
    87=>{:angle_rad_to_ship=>2.14869826375714,
    :angle_rad=>2.14117960844484,
    :initial_dx=>-11,
    :mx=>-4.25,
    :my=>6.625,
    :initial_dy=>16,
    :velocity=>7.87103074571558},
    154=>{:angle_rad_to_ship=>-2.50048388473009,
    :angle_rad=>-2.50123618851895,
    :initial_dx=>-16,
    :mx=>-6.375,
    :my=>-4.75,
    :initial_dy=>-12,
    :velocity=>7.95003930807892},
    20=>{:angle_rad_to_ship=>0.490668058188071,
    :angle_rad=>0.491809175988699,
    :initial_dx=>17,
    :mx=>7.0,
    :my=>3.75,
    :initial_dy=>9,
    :velocity=>7.9411900871343},
    255=>{:angle_rad_to_ship=>-0.0365690559135414,
    :angle_rad=>-0.0317353735284579,
    :initial_dx=>19,
    :mx=>7.875,
    :my=>-0.25,
    :initial_dy=>-1,
    :velocity=>7.87896725465971},
    54=>{:angle_rad_to_ship=>1.33761652614808,
    :angle_rad=>1.32967864834343,
    :initial_dx=>4,
    :mx=>1.875,
    :my=>7.625,
    :initial_dy=>19,
    :velocity=>7.85214938726971},
    121=>{:angle_rad_to_ship=>2.97449085365869,
    :angle_rad=>2.96873204680265,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>1.375,
    :initial_dy=>3,
    :velocity=>7.99413847765974},
    188=>{:angle_rad_to_ship=>-1.66688504231226,
    :angle_rad=>-1.66574803313765,
    :initial_dx=>-2,
    :mx=>-0.75,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.91063366614837},
    88=>{:angle_rad_to_ship=>2.17859832290886,
    :angle_rad=>2.16745672267221,
    :initial_dx=>-12,
    :mx=>-4.5,
    :my=>6.625,
    :initial_dy=>16,
    :velocity=>8.00878423982067},
    155=>{:angle_rad_to_ship=>-2.47428651861144,
    :angle_rad=>-2.47916635975664,
    :initial_dx=>-16,
    :mx=>-6.25,
    :my=>-4.875,
    :initial_dy=>-13,
    :velocity=>7.92641943124385},
    21=>{:angle_rad_to_ship=>0.507098504392337,
    :angle_rad=>0.513252272866261,
    :initial_dx=>17,
    :mx=>6.875,
    :my=>3.875,
    :initial_dy=>9,
    :velocity=>7.8918470588323},
    222=>{:angle_rad_to_ship=>-0.845155989785846,
    :angle_rad=>-0.841518946098625,
    :initial_dx=>13,
    :mx=>5.25,
    :my=>-5.875,
    :initial_dy=>-15,
    :velocity=>7.87896725465971},
    122=>{:angle_rad_to_ship=>3.00983038711187,
    :angle_rad=>2.99969559898563,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>1.125,
    :initial_dy=>2,
    :velocity=>7.95495128834866},
    189=>{:angle_rad_to_ship=>-1.65393755868334,
    :angle_rad=>-1.64876296062644,
    :initial_dx=>-2,
    :mx=>-0.625,
    :my=>-8.0,
    :initial_dy=>-20,
    :velocity=>8.02437692285202},
    55=>{:angle_rad_to_ship=>1.35212738092095,
    :angle_rad=>1.34871442488942,
    :initial_dx=>4,
    :mx=>1.75,
    :my=>7.75,
    :initial_dy=>19,
    :velocity=>7.94512429103535},
    89=>{:angle_rad_to_ship=>2.19520667642154,
    :angle_rad=>2.18922432116742,
    :initial_dx=>-12,
    :mx=>-4.625,
    :my=>6.5,
    :initial_dy=>16,
    :velocity=>7.97750744280443},
    156=>{:angle_rad_to_ship=>-2.44836952774881,
    :angle_rad=>-2.44485037205978,
    :initial_dx=>-16,
    :mx=>-6.125,
    :my=>-5.125,
    :initial_dy=>-13,
    :velocity=>7.98631642248164},
    22=>{:angle_rad_to_ship=>0.540419500270584,
    :angle_rad=>0.534955073786096,
    :initial_dx=>16,
    :mx=>6.75,
    :my=>4.0,
    :initial_dy=>10,
    :velocity=>7.84617741323761},
    223=>{:angle_rad_to_ship=>-0.819283493301566,
    :angle_rad=>-0.807616728724167,
    :initial_dx=>13,
    :mx=>5.5,
    :my=>-5.75,
    :initial_dy=>-15,
    :velocity=>7.95691523141977},
    123=>{:angle_rad_to_ship=>3.02168866822477,
    :angle_rad=>3.01528453652655,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>1.0,
    :initial_dy=>2,
    :velocity=>7.93823815465371},
    190=>{:angle_rad_to_ship=>-1.61837943007188,
    :angle_rad=>-1.61763703971087,
    :initial_dx=>-1,
    :mx=>-0.375,
    :my=>-8.0,
    :initial_dy=>-20,
    :velocity=>8.00878423982067},
    56=>{:angle_rad_to_ship=>1.38768550953241,
    :angle_rad=>1.37961186719788,
    :initial_dx=>3,
    :mx=>1.5,
    :my=>7.75,
    :initial_dy=>19,
    :velocity=>7.89382670192347},
    23=>{:angle_rad_to_ship=>0.56766642437188,
    :angle_rad=>0.570383281649942,
    :initial_dx=>16,
    :mx=>6.625,
    :my=>4.25,
    :initial_dy=>10,
    :velocity=>7.87103074571558},
    90=>{:angle_rad_to_ship=>2.21912831588216,
    :angle_rad=>2.21115279186574,
    :initial_dx=>-12,
    :mx=>-4.75,
    :my=>6.375,
    :initial_dy=>15,
    :velocity=>7.95003930807892},
    157=>{:angle_rad_to_ship=>-2.41495031290807,
    :angle_rad=>-2.42276265396817,
    :initial_dx=>-15,
    :mx=>-6.0,
    :my=>-5.25,
    :initial_dy=>-14,
    :velocity=>7.97260935955099},
    224=>{:angle_rad_to_ship=>-0.793801326945095,
    :angle_rad=>-0.785398163397448,
    :initial_dx=>14,
    :mx=>5.625,
    :my=>-5.625,
    :initial_dy=>-15,
    :velocity=>7.95495128834866},
    124=>{:angle_rad_to_ship=>3.05745441305862,
    :angle_rad=>3.04664094724704,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>0.75,
    :initial_dy=>1,
    :velocity=>7.91063366614837},
    191=>{:angle_rad_to_ship=>-1.60649543947422,
    :angle_rad=>-1.60203616022516,
    :initial_dx=>-1,
    :mx=>-0.25,
    :my=>-8.0,
    :initial_dy=>-20,
    :velocity=>8.00390529679106},
    57=>{:angle_rad_to_ship=>1.39964772137871,
    :angle_rad=>1.39520416484472,
    :initial_dx=>3,
    :mx=>1.375,
    :my=>7.75,
    :initial_dy=>19,
    :velocity=>7.87103074571558},
    91=>{:angle_rad_to_ship=>2.24553726901845,
    :angle_rad=>2.23322262062805,
    :initial_dx=>-13,
    :mx=>-4.875,
    :my=>6.25,
    :initial_dy=>15,
    :velocity=>7.92641943124385},
    158=>{:angle_rad_to_ship=>-2.39818659741371,
    :angle_rad=>-2.40060970543926,
    :initial_dx=>-15,
    :mx=>-5.875,
    :my=>-5.375,
    :initial_dy=>-14,
    :velocity=>7.96280415431649},
    24=>{:angle_rad_to_ship=>0.577901936962246,
    :angle_rad=>0.583635819077161,
    :initial_dx=>16,
    :mx=>6.625,
    :my=>4.375,
    :initial_dy=>10,
    :velocity=>7.93922225410021},
    225=>{:angle_rad_to_ship=>-0.768450633591043,
    :angle_rad=>-0.763179598070729,
    :initial_dx=>14,
    :mx=>5.75,
    :my=>-5.5,
    :initial_dy=>-14,
    :velocity=>7.95691523141977},
    125=>{:angle_rad_to_ship=>3.08213899428114,
    :angle_rad=>3.07917384359384,
    :initial_dx=>-20,
    :mx=>-8.0,
    :my=>0.5,
    :initial_dy=>1,
    :velocity=>8.0156097709407},
    192=>{:angle_rad_to_ship=>-1.5707963267949,
    :angle_rad=>-1.5707963267949,
    :initial_dx=>0,
    :mx=>0.0,
    :my=>-8.0,
    :initial_dy=>-20,
    :velocity=>8.0},
    58=>{:angle_rad_to_ship=>1.43744607262334,
    :angle_rad=>1.42889927219073,
    :initial_dx=>2,
    :mx=>1.125,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.95495128834866},
    159=>{:angle_rad_to_ship=>-2.38139923551929,
    :angle_rad=>-2.37841305551906,
    :initial_dx=>-15,
    :mx=>-5.75,
    :my=>-5.5,
    :initial_dy=>-14,
    :velocity=>7.95691523141977},
    25=>{:angle_rad_to_ship=>0.604779552813181,
    :angle_rad=>0.60554466360497,
    :initial_dx=>16,
    :mx=>6.5,
    :my=>4.5,
    :initial_dy=>11,
    :velocity=>7.90569415042095},
    226=>{:angle_rad_to_ship=>-0.751512833493331,
    :angle_rad=>-0.740982948150537,
    :initial_dx=>14,
    :mx=>5.875,
    :my=>-5.375,
    :initial_dy=>-14,
    :velocity=>7.96280415431649},
    92=>{:angle_rad_to_ship=>2.27165073467935,
    :angle_rad=>2.26753860832491,
    :initial_dx=>-13,
    :mx=>-5.125,
    :my=>6.125,
    :initial_dy=>15,
    :velocity=>7.98631642248164},
    126=>{:angle_rad_to_ship=>3.10589354091047,
    :angle_rad=>3.09475194067382,
    :initial_dx=>-20,
    :mx=>-8.0,
    :my=>0.375,
    :initial_dy=>0,
    :velocity=>8.00878423982067},
    193=>{:angle_rad_to_ship=>-1.55889212723659,
    :angle_rad=>-1.55517259817442,
    :initial_dx=>0,
    :mx=>0.125,
    :my=>-8.0,
    :initial_dy=>-20,
    :velocity=>8.00097650290263},
    59=>{:angle_rad_to_ship=>1.44944432622413,
    :angle_rad=>1.44448820973166,
    :initial_dx=>2,
    :mx=>1.0,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.93823815465371},
    227=>{:angle_rad_to_ship=>-0.726642340681726,
    :angle_rad=>-0.718829999621625,
    :initial_dx=>15,
    :mx=>6.0,
    :my=>-5.25,
    :initial_dy=>-14,
    :velocity=>7.97260935955099},
    160=>{:angle_rad_to_ship=>-2.35619449019234,
    :angle_rad=>-2.35619449019234,
    :initial_dx=>-15,
    :mx=>-5.625,
    :my=>-5.625,
    :initial_dy=>-15,
    :velocity=>7.95495128834866},
    26=>{:angle_rad_to_ship=>0.638634967153985,
    :angle_rad=>0.640356465070843,
    :initial_dx=>15,
    :mx=>6.375,
    :my=>4.75,
    :initial_dy=>11,
    :velocity=>7.95003930807892},
    93=>{:angle_rad_to_ship=>2.29743866747662,
    :angle_rad=>2.28962632641652,
    :initial_dx=>-14,
    :mx=>-5.25,
    :my=>6.0,
    :initial_dy=>15,
    :velocity=>7.97260935955099},
    127=>{:angle_rad_to_ship=>3.12968845403148,
    :angle_rad=>3.12596892496932,
    :initial_dx=>-20,
    :mx=>-8.0,
    :my=>0.125,
    :initial_dy=>0,
    :velocity=>8.00097650290263},
    194=>{:angle_rad_to_ship=>-1.53509721411557,
    :angle_rad=>-1.52395561387893,
    :initial_dx=>0,
    :mx=>0.375,
    :my=>-8.0,
    :initial_dy=>-20,
    :velocity=>8.00878423982067},
    60=>{:angle_rad_to_ship=>1.48563693417519,
    :angle_rad=>1.47584462045214,
    :initial_dx=>1,
    :mx=>0.75,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.91063366614837},
    161=>{:angle_rad_to_ship=>-2.3309897448654,
    :angle_rad=>-2.33397592486563,
    :initial_dx=>-14,
    :mx=>-5.5,
    :my=>-5.75,
    :initial_dy=>-15,
    :velocity=>7.95691523141977},
    27=>{:angle_rad_to_ship=>0.665289427830536,
    :angle_rad=>0.662426293833151,
    :initial_dx=>15,
    :mx=>6.25,
    :my=>4.875,
    :initial_dy=>12,
    :velocity=>7.92641943124385},
    228=>{:angle_rad_to_ship=>-0.70085440788445,
    :angle_rad=>-0.696742281530011,
    :initial_dx=>15,
    :mx=>6.125,
    :my=>-5.125,
    :initial_dy=>-13,
    :velocity=>7.98631642248164},
    94=>{:angle_rad_to_ship=>2.32230916028823,
    :angle_rad=>2.31177927494543,
    :initial_dx=>-14,
    :mx=>-5.375,
    :my=>5.875,
    :initial_dy=>14,
    :velocity=>7.96280415431649},
    128=>{:angle_rad_to_ship=>3.14159265358979,
    :angle_rad=>3.14159265358979,
    :initial_dx=>-20,
    :mx=>-8.0,
    :my=>0.0,
    :initial_dy=>0,
    :velocity=>8.0},
    195=>{:angle_rad_to_ship=>-1.51134266748624,
    :angle_rad=>-1.50837751679894,
    :initial_dx=>1,
    :mx=>0.5,
    :my=>-8.0,
    :initial_dy=>-20,
    :velocity=>8.0156097709407},
    61=>{:angle_rad_to_ship=>1.50989611851691,
    :angle_rad=>1.50738937482806,
    :initial_dx=>1,
    :mx=>0.5,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.89085705104331},
    162=>{:angle_rad_to_ship=>-2.31420238297097,
    :angle_rad=>-2.31177927494543,
    :initial_dx=>-14,
    :mx=>-5.375,
    :my=>-5.875,
    :initial_dy=>-15,
    :velocity=>7.96280415431649},
    28=>{:angle_rad_to_ship=>0.682316554874748,
    :angle_rad=>0.684617164312781,
    :initial_dx=>15,
    :mx=>6.125,
    :my=>5.0,
    :initial_dy=>12,
    :velocity=>7.90668230043423},
    229=>{:angle_rad_to_ship=>-0.674740942223553,
    :angle_rad=>-0.662426293833151,
    :initial_dx=>15,
    :mx=>6.25,
    :my=>-4.875,
    :initial_dy=>-13,
    :velocity=>7.92641943124385},
    95=>{:angle_rad_to_ship=>2.33924696038594,
    :angle_rad=>2.33397592486563,
    :initial_dx=>-14,
    :mx=>-5.5,
    :my=>5.75,
    :initial_dy=>14,
    :velocity=>7.95691523141977},
    196=>{:angle_rad_to_ship=>-1.48665808626373,
    :angle_rad=>-1.47584462045214,
    :initial_dx=>1,
    :mx=>0.75,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.91063366614837},
    62=>{:angle_rad_to_ship=>1.53422727088135,
    :angle_rad=>1.52321322351791,
    :initial_dx=>0,
    :mx=>0.375,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.88392351561074},
    129=>{:angle_rad_to_ship=>-3.10589354091047,
    :angle_rad=>-3.11035282015952,
    :initial_dx=>-20,
    :mx=>-8.0,
    :my=>-0.25,
    :initial_dy=>-1,
    :velocity=>8.00390529679106},
    230=>{:angle_rad_to_ship=>-0.648331989087261,
    :angle_rad=>-0.640356465070843,
    :initial_dx=>15,
    :mx=>6.375,
    :my=>-4.75,
    :initial_dy=>-12,
    :velocity=>7.95003930807892},
    163=>{:angle_rad_to_ship=>-2.29743866747662,
    :angle_rad=>-2.28962632641652,
    :initial_dx=>-14,
    :mx=>-5.25,
    :my=>-6.0,
    :initial_dy=>-15,
    :velocity=>7.97260935955099},
    29=>{:angle_rad_to_ship=>0.699403872203208,
    :angle_rad=>0.706908060760116,
    :initial_dx=>15,
    :mx=>6.0,
    :my=>5.125,
    :initial_dy=>12,
    :velocity=>7.89085705104331},
    96=>{:angle_rad_to_ship=>2.36459765373999,
    :angle_rad=>2.35619449019234,
    :initial_dx=>-15,
    :mx=>-5.625,
    :my=>5.625,
    :initial_dy=>14,
    :velocity=>7.95495128834866},
    130=>{:angle_rad_to_ship=>-3.09400955031281,
    :angle_rad=>-3.09475194067382,
    :initial_dx=>-20,
    :mx=>-8.0,
    :my=>-0.375,
    :initial_dy=>-1,
    :velocity=>8.00878423982067},
    197=>{:angle_rad_to_ship=>-1.45089234142987,
    :angle_rad=>-1.44448820973166,
    :initial_dx=>2,
    :mx=>1.0,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.93823815465371},
    63=>{:angle_rad_to_ship=>1.55860180934664,
    :angle_rad=>1.55492464380311,
    :initial_dx=>0,
    :mx=>0.125,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.87599200101168},
    97=>{:angle_rad_to_ship=>2.39007982009646,
    :angle_rad=>2.37841305551906,
    :initial_dx=>-15,
    :mx=>-5.75,
    :my=>5.5,
    :initial_dy=>13,
    :velocity=>7.95691523141977},
    164=>{:angle_rad_to_ship=>-2.26401945263588,
    :angle_rad=>-2.26753860832491,
    :initial_dx=>-13,
    :mx=>-5.125,
    :my=>-6.125,
    :initial_dy=>-16,
    :velocity=>7.98631642248164},
    30=>{:angle_rad_to_ship=>0.733720078915018,
    :angle_rad=>0.729277380696272,
    :initial_dx=>14,
    :mx=>5.875,
    :my=>5.25,
    :initial_dy=>13,
    :velocity=>7.87896725465971},
    231=>{:angle_rad_to_ship=>-0.624410349626641,
    :angle_rad=>-0.618427994372519,
    :initial_dx=>16,
    :mx=>6.5,
    :my=>-4.625,
    :initial_dy=>-12,
    :velocity=>7.97750744280443},
    198=>{:angle_rad_to_ship=>-1.43903406031697,
    :angle_rad=>-1.42889927219073,
    :initial_dx=>2,
    :mx=>1.125,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.95495128834866},
    64=>{:angle_rad_to_ship=>1.5707963267949,
    :angle_rad=>1.5707963267949,
    :initial_dx=>0,
    :mx=>0.0,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.875},
    131=>{:angle_rad_to_ship=>-3.05845142170135,
    :angle_rad=>-3.06362601975825,
    :initial_dx=>-20,
    :mx=>-8.0,
    :my=>-0.625,
    :initial_dy=>-2,
    :velocity=>8.02437692285202},
    165=>{:angle_rad_to_ship=>-2.23810246177325,
    :angle_rad=>-2.23322262062805,
    :initial_dx=>-13,
    :mx=>-4.875,
    :my=>-6.25,
    :initial_dy=>-16,
    :velocity=>7.92641943124385},
    31=>{:angle_rad_to_ship=>0.759762754875771,
    :angle_rad=>0.763179598070729,
    :initial_dx=>14,
    :mx=>5.75,
    :my=>5.5,
    :initial_dy=>13,
    :velocity=>7.95691523141977},
    232=>{:angle_rad_to_ship=>-0.60780199611396,
    :angle_rad=>-0.596660395877315,
    :initial_dx=>16,
    :mx=>6.625,
    :my=>-4.5,
    :initial_dy=>-12,
    :velocity=>8.00878423982067},
    98=>{:angle_rad_to_ship=>2.41595231658074,
    :angle_rad=>2.41231527289352,
    :initial_dx=>-15,
    :mx=>-5.875,
    :my=>5.25,
    :initial_dy=>13,
    :velocity=>7.87896725465971},
    199=>{:angle_rad_to_ship=>-1.40369452686379,
    :angle_rad=>-1.39793572000775,
    :initial_dx=>3,
    :mx=>1.375,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>7.99413847765974},
    65=>{:angle_rad_to_ship=>1.60736538270844,
    :angle_rad=>1.60253170032335,
    :initial_dx=>-1,
    :mx=>-0.25,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.87896725465971},
    132=>{:angle_rad_to_ship=>-3.04550393807243,
    :angle_rad=>-3.04664094724704,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>-0.75,
    :initial_dy=>-2,
    :velocity=>7.91063366614837},
    32=>{:angle_rad_to_ship=>0.785398163397448,
    :angle_rad=>0.785398163397448,
    :initial_dx=>14,
    :mx=>5.625,
    :my=>5.625,
    :initial_dy=>14,
    :velocity=>7.95495128834866},
    233=>{:angle_rad_to_ship=>-0.577901936962246,
    :angle_rad=>-0.570383281649942,
    :initial_dx=>16,
    :mx=>6.625,
    :my=>-4.25,
    :initial_dy=>-11,
    :velocity=>7.87103074571558},
    99=>{:angle_rad_to_ship=>2.44218878138659,
    :angle_rad=>2.43468459282968,
    :initial_dx=>-15,
    :mx=>-6.0,
    :my=>5.125,
    :initial_dy=>12,
    :velocity=>7.89085705104331},
    166=>{:angle_rad_to_ship=>-2.2119050956546,
    :angle_rad=>-2.21115279186574,
    :initial_dx=>-12,
    :mx=>-4.75,
    :my=>-6.375,
    :initial_dy=>-16,
    :velocity=>7.95003930807892},
    200=>{:angle_rad_to_ship=>-1.39200327199198,
    :angle_rad=>-1.38257482149013,
    :initial_dx=>3,
    :mx=>1.5,
    :my=>-7.875,
    :initial_dy=>-20,
    :velocity=>8.01658437241198},
    66=>{:angle_rad_to_ship=>1.61953817810483,
    :angle_rad=>1.61837943007188,
    :initial_dx=>-1,
    :mx=>-0.375,
    :my=>7.875,
    :initial_dy=>19,
    :velocity=>7.88392351561074},
    133=>{:angle_rad_to_ship=>-3.00983038711187,
    :angle_rad=>-3.01528453652655,
    :initial_dx=>-20,
    :mx=>-7.875,
    :my=>-1.0,
    :initial_dy=>-3,
    :velocity=>7.93823815465371}
  }

  def self.distance(x1,y1, x2,y2, r = nil)
    return nil, nil, nil unless x1 && y1 && x2 && y2

    dx = x2 - x1
    dy = y2 - y1
    dist = dx*dx + dy*dy # Quadrat des Abstands zu diesem Asteroiden

    # reduce dist by object radius if given
    dist -= r if r

    # return (dist < 0 ? 0 : Math.sqrt(dist)), dx, dy
    return (dist < 0 ? 0 : dist), dx, dy
  end

  def self.distance_normalized(x1,y1, x2,y2, r = nil)
    return nil, nil, nil unless x1 && y1 && x2 && y2

    dx = x2 - x1
    while dx < -512 do
      dx += 1024 # dx normalisieren auf -512 ... 511
    end
    while dx > 511 do
      dx -= 1024
    end

    dy = y2 - y1
    while dy < -384 do
      dy += 768 # dy normalisieren auf -384 ... 383
    end
    while dy > 383 do
      dy -= 768
    end

    dist = dx*dx + dy*dy # Quadrat des Abstands zu diesem Asteroiden

    # reduce dist by object radius if given
    dist -= r if r

    # return (dist < 0 ? 0 : Math.sqrt(dist)), dx, dy
    return (dist < 0 ? 0 : dist), dx, dy
  end
  
  def self.motion_prediction(object, frames = 1)
    vx, vy = object[:nvx], object[:nvy]
    if object[:mx] && object[:my]
      vx += object[:mx]*frames
      vy += object[:my]*frames
    end
    
    while vx < -512 do
      vx += 1024 # dx normalisieren auf 0 ... 1023
    end
    while vx > 511 do
      vx -= 1024
    end

    while vy < -384 do
      vy += 768 # dy normalisieren auf 0 ... 767
    end
    while vy > 383 do
      vy -= 768
    end
    
    return vx, vy
  end
  
  def self.target_angle(game, target)
    return nil unless game[:shot_angle_index] && target

    ship = game[:ship]
    shot = SHOT_ANGLES_BY_INDEX[game[:shot_angle_index]]
    
    vx, vy = ship[:nvx]+shot[:initial_dx], ship[:nvy]+shot[:initial_dy]

    t = dx = dy = 0; 5.times do # do no more than 5 iterations
      target_vx, target_vy = motion_prediction(target, t)
      dist, dx, dy = self.distance(vx, vy, target_vx, target_vy)
      # length of projection of m on d (additional shot speed from ship movement)
      p = ((ship[:mx]||0)*dx + (ship[:my]||0)*dy) / dist
      t_last, t = t, (dist / (shot[:velocity]+p)).round
      break if (t-t_last).abs <= 1
    end

    # mathematisch wird hier das Kreuzprodukt aus den Vektoren 
    # (ship_mx/y+shot_mx/y)/0 und target_dx/y/0 berechnet (hgb)
    return (shot[:mx]+(ship[:mx]||0)) * dy - (shot[:my]+(ship[:my]||0)) * dx
  end
  
  def self.shot_will_hit?(ship, shot_angle_index, target, shot_lifetime = 69, additional_turn_t = 0)
    return nil unless !ship.empty? && shot_angle_index && target

    shot = SHOT_ANGLES_BY_INDEX[shot_angle_index]

    shot_vx, shot_vy = shot[:initial_dx], shot[:initial_dy]
  
    shot_mx = shot[:mx]+(ship[:mx]||0)
    shot_my = shot[:my]+(ship[:my]||0)
    # shots have a maximum speed per x/y component!
    # see http://www.heise.de/ct/foren/S-Komponentenweise-Abriegelung-der-Geschwindigkeit/forum-135513/msg-14875815/read/
    shot_mx = shot_mx > 13.875 ? 13.875 : shot_mx
    shot_mx = shot_mx < -13.875 ? -13.875 : shot_mx
    shot_my = shot_my > 13.875 ? 13.875 : shot_my
    shot_my = shot_my < -13.875 ? -13.875 : shot_my
    shot_to_target_mx = shot_mx-(target[:mx]||0)
    shot_to_target_my = shot_my-(target[:my]||0)
    # shot is travelling with shot_to_target_m relative to target
    
    target_vx, target_vy = motion_prediction(target, frames = additional_turn_t)

    divider = (shot_to_target_mx**2 + shot_to_target_my**2)
    return false if divider == 0.0
    
    # vgl. http://www.mathe.timmermann.org/analytische-geometrie.htm 9.2
    t = (( -shot_to_target_mx*(shot_vx-target_vx) - shot_to_target_my*(shot_vy-target_vy) ) /
         divider)
    
    # shot does not reliably travel farther than 69 frames!
    # asteroids will not reliably detect collisions in the last frame, so we are using 68
    # and it does not fly backwards either :-)
    return false if t > (shot_lifetime-1) || t < 0
    
    # perpendicular base point q ("Lotfußpunkt")
    qx = shot_vx + t * shot_to_target_mx
    qy = shot_vy + t * shot_to_target_my
  
    # squared distance
    dist = ((target_vx-qx)**2 + (target_vy-qy)**2).abs
    
    # reduce dist by squared object radius if given
    if target[:r] && target[:r] > 0 
      # dist = Math.sqrt(dist) if dist > 0
      dist -= target[:r]
    end

    return dist <= 0 ? t+additional_turn_t : false
  end

  def self.will_collide?(object1, object2)
    return nil unless object1 && object2 && !object1.empty? && !object2.empty?

    object1_vx, object1_vy = object1[:nvx], object1[:nvy]
  
    object1_to_object2_mx = (object1[:mx]||0)-(object2[:mx]||0)
    object1_to_object2_my = (object1[:my]||0)-(object2[:my]||0)
    # object1 is travelling with object1_to_object2_my relative to object2
    
    object2_vx, object2_vy = object2[:nvx], object2[:nvy]

    divider = (object1_to_object2_mx**2 + object1_to_object2_my**2)
    
    return false if divider == 0.0

    # vgl. http://www.mathe.timmermann.org/analytische-geometrie.htm 9.2
    t = (( -object1_to_object2_mx*(object1_vx-object2_vx) - object1_to_object2_my*(object1_vy-object2_vy) ) /
         divider)
    
    return false if t < 0 # objects do not fly backwards :-)
    
    # perpendicular base point q ("Lotfußpunkt")
    qx = object1_vx + t * object1_to_object2_mx
    qy = object1_vy + t * object1_to_object2_my
  
    # squared distance
    dist = ((object2_vx-qx)**2 + (object2_vy-qy)**2).abs
    
    # reduce dist by squared object collision radii if given
    if object1[:r_coll] || object2[:r_coll]
      # dist = Math.sqrt(dist) if dist > 0
      dist -= object1[:r_coll]*2 if object1[:r_coll]
      dist -= object2[:r_coll]*2 if object2[:r_coll]
    end

    return dist <= 0 ? t : false
  end
    
end
