#ifndef INHABITANTS_H
#define INHABITANTS_H

class Inhabitant
{
public:
	Inhabitant(const short& xPos, const short& yPos, const short& sz);
	virtual ~Inhabitant() = 0;
	void position(short* xPos, short* yPos, short* sz = 0) const;
	void speed(float* xSp, float* ySp) const;
	const bool upToDate() const;
	void outOfDate();
	void invalidate();
	enum Destiny {WillHit, MissLeft, MissRight};
	Destiny willHit(const Inhabitant& thing, int* numFrames = 0, float* smallestDistance = 0, const bool sniper = false) const;
protected:
	short compensateScreenWrap(const short& dist, const short& bounds, const short& tolerance) const;
	short compensateScreenWrap(const short& pos, const short& bounds) const;
	void speedMonitoring(const short& xPos, const short& yPos, float* xSp, float* ySp) const;
	void store(const short& xPos, const short& yPos, const float& xSp, const float& ySp, const short& sz);
	float distance(const short& x1, const short& y1, const short& x2, const short& y2) const;
	static const short xRes = 1024;
	static const short yRes = 768;
	static const unsigned char history = 10;
	static const unsigned char jumpiness = 16;  // a shot from a fast ship can jump 16 pixel in one frame
	unsigned short x[history];
	unsigned short y[history];
	unsigned char curr; /** array position of x and y value for current frame */
	unsigned short size;
	float xSpeed;
	float ySpeed;
private:
	const unsigned char oldestEntry() const;
	unsigned char age; // how far back in history can we go (max = history - 1)
	bool uptodate;

	// disallow copying
	Inhabitant(const Inhabitant&);
	// Inhabitant operator=(const Inhabitant&); not allowed in pure virtual classes
};

class Living
 : public Inhabitant
{
public:
	virtual ~Living() = 0;
protected:
	Living(const short& xPos, const short& yPos, const short& sz);
	void set(const short& xPos, const short& yPos, const short& sz);

};

class Dead
 : public Inhabitant
{
public:
	Dead(const short& xPos, const short& yPos, const short& sz);
	virtual ~Dead() = 0;
protected:
	bool couldBeAt(const short& xPos, const short& yPos, const short& sz);
};

class Shot
 : public Dead
{
public:
	Shot(const short& xPos, const short& yPos);
	virtual ~Shot();
	bool couldBeAt(const short& xPos, const short& yPos);
};

class Saucer
 : public Living
{
public:
	static Saucer& instance();
	void set(const short& xPos, const short& yPos, const short& sz);
private:
	Saucer();
	virtual ~Saucer();
};

class Ship
 : public Living
{
public:
	static Ship& instance();
	void set(const short& xPos, const short& yPos, const short& xDir, const short& yDir);
	enum Action {TurnLeft, TurnRight, Shoot};
	Action aim(const Inhabitant& thing);
	bool tooFarAwayFrom(const Inhabitant& thing);
	bool thrust(bool slow = false);
private:
	Ship();
	virtual ~Ship();
	static const unsigned short shipSize = 27;
	short xDirection;
	short yDirection;
};

class Asteroid
 : public Dead
{
public:
	enum Form {Type1, Type2, Type3, Type4};
	Asteroid(const short& xPos, const short& yPos, const Form& f, const short& sz);
	virtual ~Asteroid();
	bool couldBeAt(const short& xPos, const short& yPos, const short& sz, const Form& f);
	void position(short* xPos, short* yPos, Form* f, short* sz) const;
	short distanceToShip();
private:
	Form form;
};

#endif // INHABITANTS_H
