#ifndef PLAYER_H
#define PLAYER_H

// player.h: Beispielspieler für Asteroids
// Harald Bögeholz / c't
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes für sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#pragma pack(1)
struct FramePacket
{
	unsigned short vectorram[512];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurück
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drücken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drücken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};

#endif // PLAYER_H
