#ifndef PILOT_H
#define PILOT_H

#include "player.h"
#include "inhabitants.h"
#include <vector>
using namespace std;

class Pilot
{
public:
	static Pilot& instance();
	void updateSpace(const unsigned short* vector_ram);
	void react(KeysPacket& keys);
private:
	Pilot();
	~Pilot();
	void shotPos(int xPos, int yPos);
	void asteroidPos(int xPos, int yPos, Asteroid::Form f, int size);
	bool nearestShotIsDangerous();
	bool alreadyShot(const Inhabitant* toCheck) const;
	Inhabitant* analyseSpace(KeysPacket& keys);
	void steer(KeysPacket& keys, const Inhabitant* target);
	unsigned char curr;
	vector<Shot*> shot;
	vector<Asteroid*> asteroid;
	bool firedInPrevFrame;
	bool firedInThisFrame;
};
 
#endif // PILOT_H
