// comm.h: Kommunikation fr Asteroids-Spieler
// Harald Bgeholz / c't

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
    {
    private:
        static const char KEY_HYPERSPACE = 1;
        static const char KEY_FIRE = 2;
        static const char KEY_THRUST = 4;
        static const char KEY_RIGHT = 8;
        static const char KEY_LEFT = 0x10;
        
        char signature[6];
        char keys;
    public:
        char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.
        
        KeysPacket(void);
        void clear(void);         // alle Tasten loslassen
        void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
        void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
        void thrust(bool b);      // Beschleunigen ...
        void right(bool b);       // rechts drehen ...
        void left(bool b);        // links drehen
    };
#pragma pack()

class Communication
{
public:
    Communication(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};
