// game.cpp: Spielstatus fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <math.h>

#include "game.h"

void GameStatus::InterpretScreen(FramePacket &packet, GameStatus* previousgame)
{
	unsigned short *vector_ram = (unsigned short *) packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	clear();
	if ((unsigned char) packet.vectorram[1] != 0xe0 && (unsigned char) packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
                if (previousgame)
                    asteroids[nasteroids].set(vx, vy, 1, vs, previousgame->asteroids[nasteroids]);
                else
                    asteroids[nasteroids].set(vx, vy, 1, vs);
				nasteroids++;
				break;
			case 0x8ff:
                if (previousgame)
                    asteroids[nasteroids].set(vx, vy, 2, vs, previousgame->asteroids[nasteroids]);
                else
                    asteroids[nasteroids].set(vx, vy, 2, vs);
                nasteroids++;
				break;
			case 0x90d:
                if (previousgame)
                    asteroids[nasteroids].set(vx, vy, 3, vs, previousgame->asteroids[nasteroids]);
                else
                    asteroids[nasteroids].set(vx, vy, 3, vs);
                    nasteroids++;
				break;
			case 0x91a:
                if (previousgame)
                    asteroids[nasteroids].set(vx, vy, 4, vs, previousgame->asteroids[nasteroids]);
                else
                    asteroids[nasteroids].set(vx, vy, 4, vs);
                    nasteroids++;
				break;
			case 0x929:
				if (previousgame && previousgame->saucer_present)
				{
					saucer_dx = vx - previousgame->saucer_x;
					saucer_dy = vy - previousgame->saucer_y;
				}
				saucer_present = true;
				saucer_x = vx;
				saucer_y = vy;
				saucer_size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				shots[nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					ship_present = true;
					ship_x = vx;
					ship_y = vy;
					ship_dx = v1x - dx;
					ship_dy = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}

Asteroid::Asteroid()
:	x(0)
,	y(0)
,	dx(0)
,	dy(0)
,	type(0)
,	sf(0)
{
}

void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
    this->dx = 0;
    this->dy = 0;
}

void Asteroid::set(int x, int y, int type, int sf, Asteroid& previous)
{
    set(x, y, type, sf);
	
	if (previous.type == this->type && previous.sf == this->sf)
	{
		this->dx = this->x - previous.x;
		this->dy = this->y - previous.y;
	}
    
    if (this->dx * this->dx + this->dy *this->dy > 64)
    {
		this->dx = 0;
		this->dy = 0;
    }
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
}
