// player.cpp: Spieler fr Asteroids
// Michael Drr

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <math.h>

#include "OSUtils.h"

#include "player.h"

const int MAX_INT = 0x7fffffff;

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	GameStatus gamestatus1, gamestatus2;
	GameStatus *game = &gamestatus1, *previousgame = &gamestatus2;
    Target target;
	char prevframe = 0;
	int t = 0;
    float shot_v = 8.0;
    
    memset(&gamestatus1, 0, sizeof(GameStatus));
    memset(&gamestatus2, 0, sizeof(GameStatus));

    keys.clear();   // alle Tasten loslassen
    
	for (;;)
	{
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
//        tick
		comm.SendPacket(keys);
		comm.ReceivePacket(frame);

		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;

            game->InterpretScreen(frame, NULL);
		}
        else
        {
            GameStatus* g = previousgame;
            previousgame = game;
            game = g;

            game->InterpretScreen(frame, previousgame);
        }        

		keys.clear();   // alle Tasten loslassen
		if (game->ship_present)
		{
            if (SearchTarget(game, target))
            {
//                printf("Target: x = %d; y = %d; dx = %d; dy = %d\n", target.x, target.y, target.dx, target.dy);
                
                int deltaX = target.x - game->ship_x;
                int deltaY = target.y - game->ship_y;
                int a = deltaX * deltaX + deltaY * deltaY;
                int b = 2 * (target.dx * deltaX + target.dy * deltaY);
                int c = target.dx * target.dx + target.dy * target.dy - shot_v * shot_v;
                int det = b * b - 4 * a * c;
                
                float f = 0.0;
                if (det >= 0)
                {
                    float sqrtdet = sqrt(det);
                    float f1 = 2.0 * a / (-b + sqrtdet);
                    float f2 = 2.0 * a / (-b - sqrtdet);
                    if (f1 < 0.0) f = f2;
                    else if (f2 < 0.0) f = f1;
                    else if (f1 < f2) f = f1;
                    else f = f2;
                }
                        
                int min_dx = target.x + int(f + 0.5) * target.dx - game->ship_x;
                int min_dy = target.y + int(f + 0.5) * target.dy - game->ship_y;
            
                // Schiff in Richtung auf das Ziel drehen
                // mathematisch wird hier das Kreuzprodukt aus den Vektoren 
                // ship_dx/y/0 und min_dx/y/0 berechnet
                if (game->ship_dx * min_dy - game->ship_dy * min_dx > 0)
                    keys.left(true);
                else
                    keys.right(true);
            }

//			if (min_dist < 27*27)  // Flucht, wenn Kollision unausweichlich
//				keys.hyperspace(true);

			//if (min_dist > 400*400) // beschleunigen, wenn nichts in der Nhe
			//	keys.thrust(true);

			if (t % 2 == 0)  // Feuerknopf drcken, so schnell es geht
				keys.fire(true);
		}
	}
}

int Player::SearchTarget(GameStatus* game, Target& target)
{
    int max_rate = 0;
    for (int i = 0; i < game->nasteroids; ++i)
    {
        int rate = RateAsteroid(game, &game->asteroids[i]);
        if (rate > max_rate)
        {
            max_rate = rate;
            target.x = game->asteroids[i].x;
            target.y = game->asteroids[i].y;
            target.dx = game->asteroids[i].dx;
            target.dy = game->asteroids[i].dy;
        }
    }
    if (game->saucer_present)
    {
        int rate = RateSaucer(game);
        if (rate > max_rate)
        {
            max_rate= rate;
            target.x = game->saucer_x;
            target.y = game->saucer_y;
            target.dx = game->saucer_dx;
            target.dy = game->saucer_dy;
            
            printf("Saucer target: x = %d; y = %d; dx = %d; dy = %d\n", target.x, target.y, target.dx, target.dy);
        }
    }
    
    return 1;
}

int Player::RateAsteroid(GameStatus* game, Asteroid* asteroid)
{
    int col = Collision(game, asteroid);
    
    if (col < 0 || col > 100)
    {
        int dx = asteroid->x - game->ship_x;
        while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
        while (dx > 511) dx -= 1024;
        int dy = asteroid->y - game->ship_y;
        while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
        while (dy > 383) dy -= 768;
        int dist = dx * dx + dy * dy;
        switch (asteroid->sf)
        {	
            // Abstand um den ungefhren Radius des Asteroiden korrigieren
            case 0:  // groer Asteroid
                dist -= 40*40;
                break;
            case 15: // mittlerer Asteroid
                dist -= 20*20;
                break;
            case 14: // kleiner Asteroid
                dist -= 8*8;
                break;
        }
        return 512 * 512 + 384 * 384 - dist;
    }
    else
    {
//        printf("Kollision: %d\n", col);
        return 512 * 512 + 384 * 384 + 500 - col;
    }
}

int Player::RateSaucer(GameStatus* game)
{
    if (game->saucer_present)
    {
        int dx = game->saucer_x - game->ship_x;
        while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
        while (dx > 511) dx -= 1024;
        int dy = game->saucer_y - game->ship_y;
        while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
        while (dy > 383) dy -= 768;
        int dist = dx * dx + dy * dy;
        switch (game->saucer_size)
        {	// Abstand um den ungefhren Radius des UFOs korrigieren
            case 15: // groes UFO
                dist -= 20*12;
                break;
            case 14: // kleines UFO
                dist -= 10*6;
                break;
        }
        return 512 * 512 + 384 * 384;
    }
    else
        return -1;
}

int Player::Collision(GameStatus* game, Asteroid* asteroid)
{
    int dist = 27;     // Radius des Raumschiffs
    switch (asteroid->sf)
    {	// Abstand um den ungefhren Radius des Asteroiden korrigieren
        case 0:  // groer Asteroid
            dist += 40;
            break;
        case 15: // mittlerer Asteroid
            dist += 20;
            break;
        case 14: // kleiner Asteroid
            dist += 8;
            break;
    }

    int dx = asteroid->x - game->ship_x;
    while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
    while (dx > 511) dx -= 1024;
    int dy = asteroid->y - game->ship_y;
    while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
    while (dy > 383) dy -= 768;
    int a = asteroid->dx * asteroid->dx + asteroid->dy * asteroid->dy;
    int b = 2 * (dx * asteroid->dx + dy * asteroid->dy);
    int c = dx * dx + dy * dy - dist * dist;
    int det = b * b - 4 * a * c;
    
    if (det >= 0)
    {
        float sqrtdet = sqrt(det);
        float f1 = (-b + sqrtdet) / 2.0 / a;
        float f2 = (-b - sqrtdet) / 2.0 / a;
        if (f1 < 0.0) return int(f2 + 0.5);
        else if (f2 < 0.0) return int(f1 + 0.5);
        else if (f1 < f2) return int(f1 + 0.5);
        else return int(f2 + 0.5);
    }
    else
        return -1;
}

