// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#if defined(WINDOWS) || defined(_WIN32)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include "Point.h"
#include "Vector.h"

static const int MAX_ASTEROIDS = 27;
static const int MAX_SHOTS = 7;
static const int ANZAHL_GS = 5;

class GameStatus;

class GameObject
{
public:
	Point p;
	Point oldp;
	Vector v;
	double r;
	double dist;
	int tracked;
	
	Point nextPos(int _latenz);
	void setK(Point _p);	// Koordinaten in Bezug auf (_kx/_ky)
};

class Asteroid : public GameObject
{
public:
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
	int kk;
	int ws;

	void set(int _x, int _y, int _type, int _sf);
	bool track(Asteroid &_ast, int _latenz);
};

class Shot : public GameObject
{
public:
	int kk;

	void set(int &_x, int &_y);
	bool track(Shot &_shot, GameStatus &_gs);
};

class Ufo : public GameObject
{
public:
	bool present;

	void set(int &_x, int &_y, int &_sf);
	bool track(Ufo &_ufo);
};

class Angle
{
public:
	Point d;
	Point p;
	Vector v;
	double w;
};

class Ship : public GameObject
{
public:
	Vector d;	// ist der Blick-Vektor

	int status;

	bool present;
	bool fire;
	bool hyperspace;
	bool trust;
	int turnDir;
	int sw;
	Angle sa[256];

	void set(int _x, int _y, int _dx, int _dy);
	bool track(Ship &_ship1, Ship &_ship3);
	bool willHitObject(GameObject &_go, int _sw);
};

class GameStatus
{
public:
	Ship ship;
	Ufo ufo;
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	int latenz;
	void clear(void);
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;
	static const char KEY_ONEPLAYER = 0x20;

	char signature[6];
public:
	char keys;
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
	void onePlayer(bool b);	  // Spiel mit einem Spieler Starten
};
#pragma pack()

class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);

private:
	SOCKET sd;
	ADDRESS server_ip;
};
