#ifndef POINT_H
#define POINT_H

#include <iostream>

using namespace std;

class Point
{
friend class Vector;

private:
	int _dimensions;

public:
	double x;
	double y;
    double z;

	Point();
	Point(int a);
	Point(double a);
	Point(int a, int b);
	Point(double a, double b);
	Point(int a, int b, int c);
	Point(double a, double b, double c);
	Point(int n, int a[]);
	Point(int n, double a[]);

	friend istream& operator>>(istream&, Point&);
	friend ostream& operator<<(ostream&, Point);

	int dimensions()
	{
		return _dimensions;
	}

	int SetDimensions(int);

	int operator==(Point);
	int operator!=(Point);

	Vector operator-(Point);
	Point  operator+(Vector);
	Point  operator-(Vector);
	Point& operator+=(Vector);
	Point& operator-=(Vector);

	friend Point operator*(int, Point);
	friend Point operator*(double, Point);
	friend Point operator*(Point, int);
	friend Point operator*(Point, double);
	friend Point operator/(Point, int);
	friend Point operator/(Point, double);
	friend Point operator+(Point, Point);

	friend Point AffineSum(int, int[], Point[]);
	friend Point AffineSum(int, double[], Point[]);

	friend double Difference(Point, Point);
	friend double Difference2(Point, Point);
	double IsLeft(Point, Point);
};

#endif // POINT_H