
#include "StdAfx.h"
#include "GameEngine.h"
#include "Calculator.h"
#include "Asteroid.h"
#include "Matrix2D.h"



Asteroid::Asteroid(bool withoutNewId)
: MovingEntity(withoutNewId), mType(1), mScaleFactor(1)
{
}

Asteroid::~Asteroid(void)
{
}

Asteroid& Asteroid::operator=(const Asteroid& rhs)
{
    if (&rhs == this) { return *this; }
	
	*(dynamic_cast<MovingEntity*>(this)) = *(dynamic_cast<MovingEntity*>(const_cast<Asteroid*>(&rhs)));
	mScaleFactor = rhs.mScaleFactor;
	mType = rhs.mType;

    return *this; 
}

int Asteroid::getType(void) const
{
	return mType;
}

void Asteroid::setType(int type)
{
	mType = type;
}

int Asteroid::getScaleFactor(void) const
{
	return mScaleFactor;
}

void Asteroid::setScaleFactor(int scaleFactor)
{
	mScaleFactor = scaleFactor;
}

void Asteroid::set(double x, double y, int type, int scaleFactor)
{
	setPosition(Vector2D(x, y));
	setType(type);
	setScaleFactor(scaleFactor);
}

float Asteroid::getRadius(void) const
{

	float radius = 0.0f; 

	switch(mScaleFactor)
	{
	case 15: radius = 20.0f; break; // Mittlerer Asteroid
	case 14: radius = 8.0f; break;  // Kleiner Asteroid
	default: radius = 40.0f;  // im Zweifelsfall, den ungnstigsten Fall zurckgeben
	}

	return radius;
}


void Asteroid::writeStatusToLog() const
{
	char buffer[300] = { 0 };

	sprintf_s(buffer, 300, 
			  "Asteriod(%d): Position=[%4.2f, %4.2f], Velocity=[%4.4f, %4.4f], Speed=%4.4f, Rotation=%4.4f, Type=%d, SF=%d, velPos=%d\n"
			  "   mAlreadyUnderFire=%d, mFireAndForgetCounter=%d, mShotCalculationMethod=%d\n", 
			  getId(),
			  getPosition().getX(), 
			  getPosition().getY(), 
			  getVelocity().getX(),
			  getVelocity().getY(),
			  getSpeed(),
			  Calculator::calculateRotationInDeg(getVelocity()),
			  mType,
			  mScaleFactor,
			  mCurrentVelocityPos,
			  getAlreadyUnderFire(),
			  getFireAndForgetCounter(),
			  mShotCalculationMethod);

	GameEngine::log(buffer);
}

