// AsteroidsRC.cpp : Definiert den Einstiegspunkt fr die Konsolenanwendung.
//

#include "stdafx.h"

#include "GameEngine.h"

#include "Vector2D.h"
#include "Calculator.h"

#include "Asteroid.h"
#include "SpaceShip.h"
#include "PositionCalculator.h"


int main(int argc, char* argv[])
{
	///////////////////////////////////////////////
	//             !!!
	//			Vorsicht: Schrittcounter in SpaceShip.update wieder auf 0 setzen
	//             !!!
	/////////////////////////////////////////////////////////////////////
/*
	KeysPacket keys;
	SpaceShip spaceship;

	spaceship.setPosition(Vector2D(524, 396));
	spaceship.setRotationCounter(160);
//	spaceship.setScreenHeading(Vector2D(0.884, -0.468));

	PositionCalculator::initializePositionArray();

	GameEngine* ge = GameEngine::Instance();

	ge->getGameStatus()->setSpaceShipIsPresent(true);

	ge->getGameStatus()->mAsteroids[0].set(865, 129, 2, 0);
	ge->getGameStatus()->mNasteroids++;
	ge->getGameStatus()->calculateAsteroids(1, 1);

	std::list<Asteroid*>::iterator iter = ge->getGameStatus()->getAsteroidList()->begin();
	(*iter)->setVelocity(Vector2D(-1.25, 0.75));

	for (int i = 0; i < 100; i++)
	{
		spaceship.update(1, &keys);
		(*iter)->setPosition((*iter)->predictPosition(1));
	}

	return 0;
*/
	///////////////////////////////////////////////////////////////////
	if (argc != 2)
	{
		fprintf(stderr, "Aufruf: asteroidrc <IP-Adresse>\n");
		exit(1);
	}

	unsigned long server_ip = inet_addr(argv[1]);
	if (server_ip == INADDR_NONE)
	{
		fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", argv[1]);
		exit(1);
	}

	WSADATA wsadata;
	if (WSAStartup(MAKEWORD(2,2), &wsadata))
	{
		fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
		exit(2);
	}

	SOCKET sd;
	sd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sd == INVALID_SOCKET)
	{
		fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
		exit(2);
	}

	unsigned long enable_nonblocking = 1;
	if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
	{
		fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
		exit(1);
	}

	sockaddr_in sa;
	memset(&sa, 0, sizeof sa);
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = 0;
	sa.sin_port = 0;

	if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
	{
		fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
		exit(2);
	}

	GameEngine* gameEngine = GameEngine::Instance();
	gameEngine->SetConnection(sd, server_ip);
	gameEngine->Run();

	// Wieder aufrumen
	WSACleanup();

	return 0;
}

