

#include "StdAfx.h"
#include "Vector2D.h"
#include "SpaceShip.h"
#include "Saucer.h"
#include "Matrix2D.h"
#include "Calculator.h"
#include "GlobalSettings.h"
#include "PositionCalculator.h"

#include "GameEngine.h"


GameEngine GameEngine::mInstance;
HANDLE GameEngine::mLogFile = INVALID_HANDLE_VALUE;


GameEngine* GameEngine::Instance()
{
	return &mInstance;
}

GameEngine::GameEngine()
{
}

void GameEngine::SetConnection(SOCKET sd, ADDRESS server_ip)
{
	mSd = sd;
	mServerIp = server_ip;
}


GameEngine::~GameEngine(void)
{
}

GameStatus* GameEngine::getGameStatus()
{
	return &mGameStatus;
}

void GameEngine::Run()
{
	FramePacket frame;
	KeysPacket keys;
	unsigned char prevframe = 0, frameno = 0;
	int time = 0;
	int latenz = 0;
	int frameCount = 0;

	int counter = 0;
	bool gameStarted = false;

	char debugMsg[255] = { 0 };

	PositionCalculator::initializePositionArray();

/*
	for (int i = 0; i < 256; i++)
	{
		sprintf_s(debugMsg, 255, "RotationArray[%d] = %3.5ff;\n", i, PositionCalculator::getRotation(i)); 
		GameEngine::log(debugMsg);
	}

	return;
*/

	for (;;)
	{
		++time;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung

		SendPacket(keys);
		ReceivePacket(frame);

		latenz = keys.ping - frame.ping;
		if (latenz < 0)
		{
			latenz = 256 - keys.ping + frame.ping;
		}
		if (latenz != 0)
		{
			printf("Latenz %d\n", latenz);
		}

		frameno = frame.frameno;
		if (frameno != static_cast<unsigned char>(prevframe + 1))
		{
			printf("%d Frames verloren.\n", frameno - prevframe - 1);
		}


		// Aktuellen Frame interpretiern
		InterpretScreen(frame);

		// Aktuelle Geschwindigkeit der Objekte berechenen. Die Anzahl der vergangenen Frames 
		// wird mitbergeben. Die Geschwindigkeit wird dann gemittelt
		frameCount = frameno - prevframe;
		if (frameCount < 0)
		{
			frameCount = 256 - prevframe + frameno;
		}

		calculateVelocities(frameCount, latenz);

		if (GlobalSettings::Instance()->writeLog)
		{
			sprintf_s(debugMsg, sizeof(debugMsg), "\nGameEngine::Run(): Received Frame: %d\n", frameno);
			log(debugMsg);
			mGameStatus.writeStatusToLog();
		}

		keys.clear();

		if (mGameStatus.getSpaceShipIsPresent())
		{
			// Aktionen durchfhren
			mGameStatus.getSpaceShip()->update(time, &keys);
		}

		//////////////////////////////////////////////////////////////
		// Ein paar Ausgaben um zu wissen wo wir stehen
		if (mGameStatus.getSpaceShip()->getUpdateCounter() == 30) 
		{ 
			printf("Start\n");
			gameStarted = true;
			counter = 0; 
		}
		if (counter == 17800)
		{
			printf("Ende\n");
		}

		if (gameStarted)
		{
			counter++;
			if ((counter % 1000) == 0) { printf("counter=%d\n", counter); }
		}

		//////////////////////////////////////////////////////////////
		if (GlobalSettings::Instance()->writeLog)
		{
			log("GameEngine::Run(): Verschicke Keys: ");		
			keys.writeStatusToLog();
		}

		// Framenummer aktualisieren
		prevframe = frameno;

		// Alle Obejekte merken um in der nchsten Runde daraus die Geschwindigkeit und die 
		// Flugbahn zu berechnen
		mPrevSpaceShipPosition = mGameStatus.getSpaceShip()->getPosition();
		mPrevSaucerPosition = mGameStatus.getSaucer()->getPosition();
	}

	CloseHandle(mLogFile);
}


void GameEngine::calculateVelocities(const int& frameRate, const int& latenz)
{
	// Geschwindigkeit des raumschiffs bestimmen
	if (mGameStatus.getSpaceShipIsPresent())
	{
		mGameStatus.getSpaceShip()->calculateVelocityFromPrevPosition(mPrevSpaceShipPosition, frameRate);
	}

	// Geschwindigkeit des Ufos bestimmen
	if (mGameStatus.getSaucer()->getIsPresent())
	{
		mGameStatus.getSaucer()->calculateVelocityFromPrevPosition(mPrevSaucerPosition, frameRate);
	}

	// Asteroid erzeugen und berechnen lassen
	mGameStatus.calculateAsteroids(frameRate, latenz);

	// Fr die Sche das gleiche
	mGameStatus.calculateShots(frameRate);
}


void GameEngine::InterpretScreen(FramePacket &packet)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	mGameStatus.clear();

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = (vector_ram[pc] & 0x3ff) - 128;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				mGameStatus.mAsteroids[mGameStatus.mNasteroids++].set(static_cast<double>(vx), static_cast<double>(vy), 1, vs);
				break;
			case 0x8ff:
				mGameStatus.mAsteroids[mGameStatus.mNasteroids++].set(static_cast<double>(vx), static_cast<double>(vy), 2, vs);
				break;
			case 0x90d:
				mGameStatus.mAsteroids[mGameStatus.mNasteroids++].set(static_cast<double>(vx), static_cast<double>(vy), 3, vs);
				break;
			case 0x91a:
				mGameStatus.mAsteroids[mGameStatus.mNasteroids++].set(static_cast<double>(vx), static_cast<double>(vy), 4, vs);
				break;
			case 0x929:
				mGameStatus.getSaucer()->setIsPresent(true);
				mGameStatus.getSaucer()->setPosition(Vector2D(static_cast<double>(vx), static_cast<double>(vy)));
				mGameStatus.getSaucer()->setSize(vs);
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
			{
//				printf("Schu: vx=%d, vy=%d\n", vx, vy);
				mGameStatus.mShots[mGameStatus.mNshots++].set(static_cast<double>(vx), static_cast<double>(vy));
			}
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					mGameStatus.setSpaceShipIsPresent(true);
					mGameStatus.getSpaceShip()->setPosition(Vector2D(static_cast<double>(vx), static_cast<double>(vy)));
					mGameStatus.getSpaceShip()->setScreenHeading(Vector2D(static_cast<double>(v1x - dx), static_cast<double>(v1y - dy)));
//					printf("vx=%d, vy=%d, v1x=%d, v1y=%d, dx=%d, dy=%d\n", vx, vy, v1x, v1y, dx, dy);
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   
}


void GameEngine::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = mServerIp;
	if (sizeof packet != sendto(mSd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
	}
}


void GameEngine::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(mSd, &readfds);
		FD_SET(mSd, &exceptfds);
		select(static_cast<unsigned int>(mSd) + 1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(mSd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(mSd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(static_cast<unsigned int>(mSd) + 1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(mSd, &readfds));
}

void GameEngine::log(char* msg)
{
	if ((mLogFile == INVALID_HANDLE_VALUE) && (GlobalSettings::Instance()->writeLog))
	{
		mLogFile = CreateFile("AsteroidsRC.log", // file name
								  GENERIC_WRITE, // access mode
								  FILE_SHARE_READ, // share mode
								  NULL, // SD
								  OPEN_ALWAYS, // how to create
								  FILE_ATTRIBUTE_NORMAL, // file attributes
								  NULL // handle to template file
								 );
		SetFilePointer(mLogFile, 0, NULL, FILE_END);
	}

	// Dump wird nur geschrieben, wenn eingeschaltet und das Raumschiff anwesend ist
	if ((!GlobalSettings::Instance()->writeLog) || (!Instance()->getGameStatus()->getSpaceShipIsPresent())) 
	{ 
		return; 
	}

	if (mLogFile != INVALID_HANDLE_VALUE) 
	{ 
		DWORD bytesWritten = 0;

		WriteFile(mLogFile, msg, static_cast<DWORD>(strlen(msg)), &bytesWritten, NULL);
	}
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}


void KeysPacket::writeStatusToLog() const
{
	char buffer[255] = { 0 };
	
	DWORD msgSize = sprintf_s(buffer, 255, 
		"KeysPacket: Left=%d, Right=%d, Fire=%d\n", 
		isLeft(), isRight(), isFire());

	GameEngine::log(buffer);
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

bool KeysPacket::isLeft(void) const
{
	if ((keys & KEY_LEFT) == KEY_LEFT) { return true; }

	return false;
}

bool KeysPacket::isFire(void) const
{
	if ((keys & KEY_FIRE) == KEY_FIRE) { return true; }

	return false;
}


bool KeysPacket::isRight(void) const
{
	if ((keys & KEY_RIGHT) == KEY_RIGHT) { return true; }

	return false;
}


void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void KeysPacket::clearNavigationCommands(void)
{
	keys &= ~KEY_RIGHT;
	keys &= ~KEY_LEFT;
}

