
#include "StdAfx.h"
#include <math.h>

#include "GlobalSettings.h"
#include "PositionCalculator.h"
#include "Calculator.h"
#include "MovingEntity.h"


int MovingEntity::nextValidId = 3; // 1 und 2 sind fr das Raumschiff und das Ufo reserviert


MovingEntity::MovingEntity(bool withoutNewId)
: mCurrentVelocityPos(0), mVelocityCalcCounter(0), mCreationState(NewEntity), mSpeed(0.0),
  mId(0), mFireAndForgetCounter(0), mAlreadyUnderFire(false), mRendezvousTime(0.0), 
  mShotCalculationMethod(MovingEntity::Unkown)
{
	if (!withoutNewId)
	{
		mId = nextValidId++;
	}
}

MovingEntity::~MovingEntity(void)
{
}

MovingEntity& MovingEntity::operator=(const MovingEntity& rhs)
{
    if (&rhs == this) { return *this; }

	mPosition = rhs.mPosition;
	mHeading= rhs.mHeading;  
	mVelocity = rhs.mVelocity;	

	for (int i = 0; i < VELOCITY_SAMPLE_COUNT; i++)
	{
		mVelocities[i] = rhs.mVelocities[i];
	}

	mCurrentVelocityPos = rhs.mCurrentVelocityPos;
	mVelocityCalcCounter = rhs.mVelocityCalcCounter;
	mCreationState = rhs.mCreationState;

	mId = rhs.mId;
	mFireAndForgetCounter = rhs.mFireAndForgetCounter;
	mAlreadyUnderFire = rhs.mAlreadyUnderFire;
	mRendezvousTime = rhs.mRendezvousTime;

	mSpeed = rhs.mSpeed;

    return *this; 
}

void MovingEntity::fireAndForget(const int& frames)
{
	mFireAndForgetCounter = frames;
}

bool MovingEntity::getAlreadyUnderFire(void) const
{
	return mAlreadyUnderFire;
}

void MovingEntity::setAlreadyUnderFire(bool underFire)
{
	mAlreadyUnderFire = underFire;
}

int MovingEntity::getFireAndForgetCounter(void) const
{
	return mFireAndForgetCounter;
}

MovingEntity::CreationState MovingEntity::getCreationState(void) const
{
	return mCreationState;
}

void MovingEntity::setCreationState(const CreationState& state)
{
	mCreationState = state;
}

Vector2D MovingEntity::getPosition(void) const
{
	return mPosition;
}

Vector2D MovingEntity::predictPosition(const int& framesInFuture) const
{
	return (mPosition + getVelocity() * framesInFuture); 
}

void MovingEntity::setPosition(const Vector2D& position)
{
	mPosition = position;
}

Vector2D MovingEntity::getHeading(void) const
{
	return mHeading;
}

void MovingEntity::setHeading(const Vector2D& heading)
{
	mHeading = heading;
	mHeading.normalize();
}

int MovingEntity::getVelocityCalcCounter(void) const
{
	return mVelocityCalcCounter;
}

int MovingEntity::getId(void) const
{
	return mId;
}

void MovingEntity::setId(const int& id)
{
	mId = id;
}



Vector2D MovingEntity::getVelocity(void) const
{
	Vector2D velocity;
	int counter = mVelocityCalcCounter;
	
	if (counter > VELOCITY_SAMPLE_COUNT) { counter = VELOCITY_SAMPLE_COUNT; }

	velocity = mVelocities[0];

	if (counter == 0) { return velocity; }

	for (int i = 1; i < counter; i++)
	{
		velocity = velocity + mVelocities[i];
	}

	return (velocity / static_cast<double>(counter));
}

void MovingEntity::setVelocity(const Vector2D& velocity, const int& count)
{
	mVelocity = velocity;
	
	mVelocityCalcCounter = count % (VELOCITY_SAMPLE_COUNT + 1);

	for (int i = 0; i < mVelocityCalcCounter; i++)
	{
		mVelocities[i] = mVelocity;
		mCurrentVelocityPos++;
	}

	// Geschwindigkeit des Objekts berechnen
	mSpeed = getVelocity().getLength();
}

void MovingEntity::decreaseFireAndForgetCounter(const int& frames)
{
	mFireAndForgetCounter -= frames;
	if (mFireAndForgetCounter < -1)
	{
		mAlreadyUnderFire = false;
	}
}

void MovingEntity::calculateVelocityFromPrevPosition(const Vector2D& prevPosition, int frameCount)
{
	if (frameCount == 0) return;

	// TODO: Feststellen, ob das Objekt den Bildschirmrand berschritten hat.
	double diffX = (mPosition.getX() - prevPosition.getX()) / frameCount;
	double diffY = (mPosition.getY() - prevPosition.getY()) / frameCount;

	if (abs(diffX) > 200) 
	{	// Objekt hat die X-Seite gewechselt
		double prevX = prevPosition.getX();
		double currX = mPosition.getX();
		double worldWidth = static_cast<double>(GlobalSettings::Instance()->worldWidth);

		if (prevX > currX)
		{	// rechts raus
			diffX = worldWidth - prevX + currX;
		}
		else
		{	// links raus
			diffX = currX - worldWidth - prevX;
		}
	}

	if (abs(diffY) > 200) 
	{	// Objekt hat die Y-Seite gewechselt
		double prevY = prevPosition.getY();
		double currY = mPosition.getY();
		double worldHeight = static_cast<double>(GlobalSettings::Instance()->worldHeight);

		if (prevY > currY)
		{	// oben raus
			diffY = worldHeight - prevY + currY;
		}
		else
		{	// unten raus
			diffY = currY - worldHeight - prevY;
		}
	}

	mVelocity.setX(diffX);
	mVelocity.setY(diffY);

	mVelocities[mCurrentVelocityPos++] = mVelocity;

	mCurrentVelocityPos %= VELOCITY_SAMPLE_COUNT;

	mVelocityCalcCounter++;

	// Geschwindigkeit des Objekts berechnen
	mSpeed = getVelocity().getLength();

	decreaseFireAndForgetCounter();
}


float MovingEntity::getRadius(void) const
{
	return 10.0;
}

double MovingEntity::getRendezvousTime(void) const
{
	return mRendezvousTime;
}

void MovingEntity::setRendezvousTime(const double& time)
{
	mRendezvousTime = time;
}

double MovingEntity::getSpeed(void) const
{
	return mSpeed;
}

