
#include "StdAfx.h"
#include "GameEngine.h"
#include "Matrix2D.h"

#include "Saucer.h"


Saucer::Saucer(void)
: mSize(15), mIsPresent(false)
{
	setId(MovingEntity::SaucerId);
}

Saucer::~Saucer(void)
{
}

Saucer& Saucer::operator=(const Saucer& rhs)
{
    if (&rhs == this) { return *this; }
	
	*(dynamic_cast<MovingEntity*>(this)) = *(dynamic_cast<MovingEntity*>(const_cast<Saucer*>(&rhs)));

	mSize = rhs.mSize;
	mIsPresent = rhs.mIsPresent;

    return *this; 
}

void Saucer::setSize(int size)
{
	mSize = size;
}

int Saucer::getSize(void) const
{
	return mSize;
}

float Saucer::getRadius(void) const
{

	if (mSize == 14) { return 7; } // klein
	else { return 14; } // gro
}

bool Saucer::getIsPresent(void) const
{
	return mIsPresent;
}

void Saucer::setIsPresent(bool isPresent)
{
	mIsPresent = isPresent;
}

void Saucer::writeStatusToLog() const
{
	char buffer[255] = { 0 };
	DWORD bytesWritten = 0;
	DWORD msgSize = sprintf_s(buffer, 255, 
			  "Saucer(%d): Position=[%4.2f, %4.2f], Velocity=[%4.4f, %4.4f], Speed=%4.4f, AlreadyUnderFire=%d, FireAndForgetCounter=%d\n", 
			  getId(),
			  getPosition().getX(), 
			  getPosition().getY(), 
			  getVelocity().getX(),
			  getVelocity().getY(),
			  getSpeed(),
			  getAlreadyUnderFire(),
			  getFireAndForgetCounter());

	GameEngine::log(buffer);
}


