
#include "StdAfx.h"
#include <math.h>

#include "GlobalSettings.h"
#include "SpaceShip.h"
#include "Saucer.h"
#include "GameEngine.h"
#include "Calculator.h"
#include "Matrix2D.h"
#include "Shot.h"
#include "PositionCalculator.h"

#include "Steering.h"

Steering::Steering(MovingEntity* agent)
: mObstacleAvoidanceIsOn(false), mEmergencyJumpIsOn(false), mSeekIsOn(false), mEmergencyJumpLock(0)
{
	mAgent = agent;
}

Steering::~Steering(void)
{
}

void Steering::setEmergencyJumpOn(bool emOn)
{
	mEmergencyJumpIsOn = emOn;
}

bool Steering::getEmergencyJumpOn(void) const
{
	return mEmergencyJumpIsOn;
}

void Steering::setObstacleAvoidanceOn(bool avoidanceOn)
{
	mObstacleAvoidanceIsOn = avoidanceOn;
}

bool Steering::getObstacleAvoidanceOn(void) const
{
	return mObstacleAvoidanceIsOn;
}

void Steering::setSeekOn(bool seekOn)
{
	mSeekIsOn = seekOn;
}

bool Steering::getSeekOn(void) const
{
	return mSeekIsOn;
}

bool Steering::emergencyJump(void)
{
	// damit sperren wir fr eine gewisse Zeit den Hypersprung, damit nicht mehrere hintereinander
	// ausgefhrt werden
	mEmergencyJumpLock--;

	if ((mEmergencyJumpIsOn == false) || (mEmergencyJumpLock > 0))
	{	// Hypersprung ausgeschaltet
		return false;
	}

	GameStatus* gameStatus = GameEngine::Instance()->getGameStatus();
	GlobalSettings* globalSettings = GlobalSettings::Instance();

	Vector2D vecToObstacle;
	double emRadius = globalSettings->emergencyJumpRadius;
	double emRadiusShotSq = 9 * emRadius * emRadius;
	double range = 0.0;

	////////////////////////////////////////////////////////////////////////////////
	// Test, ob ein Schu innerhalb des Notfallradius ist
	std::list<Shot*>* shotList = gameStatus->getShotList();
	std::list<Shot*>::iterator iterShots;

	MovingEntity localSpaceShip(true);
	double rotEntity = 0.0;
	double px = 0.0, py = 0.0;

	for (iterShots = shotList->begin(); iterShots != shotList->end(); iterShots++)
	{
//		if ((*iterShots)->getSender() == Shot::SpaceShip)
		if ((*iterShots)->getVelocityCalcCounter() < 4)
		{	// Sche, die gerade eben erzeugt wurden nicht betrachten
			continue;
		}

		localSpaceShip = *mAgent;
		rotEntity = Calculator::calculateRotationInRad((*iterShots)->getVelocity());

		// lokales Raumschiff in den lokalen Raum des Objekts verfrachten 
		PositionCalculator::tansferEntityToLocalSpace((*iterShots)->getPosition(), rotEntity, &localSpaceShip);

		px = localSpaceShip.getPosition().getX();
		py = localSpaceShip.getPosition().getY();

		if ((px > 0) && (abs(py) < mAgent->getRadius()) &&
			(localSpaceShip.getPosition().getLengthSq() < emRadiusShotSq))
		{
			mEmergencyJumpLock = globalSettings->emergencyJumpLock;
			return true;
		}
	}

	////////////////////////////////////////////////////////////////////////
	// Test, ob ein Asteroid innerhalb des Radius liegt
	int count = gameStatus->getAsteroidsCount();
	Asteroid* allAsteroids = gameStatus->getAsteroids();

	for (int i = 0; i < count; i++)
	{
		// Vektor vom Schiff zum Hindernis berechnen
		vecToObstacle = Vector2D::subtract((allAsteroids + i)->getPosition(), mAgent->getPosition());

		// Radius des Asteroiden mit einbeziehen
		range = emRadius + (allAsteroids + i)->getRadius();

		// Test, ob das Hindernis im Bereich der DetectionBox liegt
		if (vecToObstacle.getLengthSq() < (range * range))
		{
			mEmergencyJumpLock = globalSettings->emergencyJumpLock;
			return true;
		}
	}

	// Zum Schlu noch das Ufo betrachten
	if (gameStatus->getSaucer()->getIsPresent())
	{
		// Vektor vom Schiff zum Hindernis berechnen
		vecToObstacle = Vector2D::subtract(gameStatus->getSaucer()->getPosition(), mAgent->getPosition());

		// Radius des Ufos mit einbeziehen
		range = emRadius + gameStatus->getSaucer()->getRadius();

		// Test, ob das Hindernis im Bereich der DetectionBox liegt
		if (vecToObstacle.getLengthSq() < (range * range))
		{
			mEmergencyJumpLock = globalSettings->emergencyJumpLock;
			return true;
		}
	}

	return false;
}


Vector2D Steering::calculate(void)
{
	Vector2D force;

	if (mObstacleAvoidanceIsOn)
	{
		force = force + obstacleAvoidance();
	}

	if (mSeekIsOn)
	{
		force = force + seek();
	}

	return force;
}

// Berechnet die Kraft zum nchstgelegenen Asteroiden
Vector2D Steering::seek(void)
{
	return Vector2D();
}

// Berechnet die Kraft um den Meteroiten auszuweichen. Diese werden als stehende Hindernisse angesehen
Vector2D Steering::obstacleAvoidance(void)
{
	return Vector2D();
}

