
#pragma once


class Vector2D
{
public:
	static Vector2D subtract(const Vector2D& vec1, const Vector2D& vec2);
	static Vector2D normalize(const Vector2D& src);

	Vector2D(void);
	Vector2D(double x, double y);
    Vector2D(const Vector2D& rhs);

	virtual ~Vector2D(void);

	Vector2D& operator=(const Vector2D& rhs);
	Vector2D& operator+=(const Vector2D& rhs);

	Vector2D& operator*=(const double& rhs);

	Vector2D operator-(const Vector2D& rhs) const;
	Vector2D operator+(const Vector2D& rhs) const;

	Vector2D operator*(const double& rhs) const;
	Vector2D operator/(const double& rhs) const;

	double getX(void) const;
	void setX(double x);

	double getY(void) const;
	void setY(double y);

	void normalize(void);

	double getLength(void) const;
	double getLengthSq(void) const;

	double dotProduct(const Vector2D& rhs) const;
	bool approximatelyEqual(const Vector2D& rhs) const;

private:

	double mX;
	double mY;
};
