//
//  APKeysequence.h
//  APlayer
//
//  Created by Holger Sadewasser on 6/21/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APTarget.h"
#import "APKeystroke.h"


@interface APKeySequence : NSObject {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------
  
  NSMutableArray * mKeySequence;
  int mLength;
  int mRotDirection;
  unsigned mRotCount;
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)init;
-(id)initWithCapacity:(unsigned)iNumItems;
-(void)dealloc;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)addKeystroke:(APKeystroke *)iKeystroke;
-(void)addKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount target:(APTarget *)iTarget;
-(void)addKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount;
-(void)clear;
-(unsigned)count;
-(int)length;
-(APKeystroke *)currentKeys;
-(void)removeCurrentKeys;
-(void)sent;
-(void)addShotToTarget:(APTarget *)iTarget repeat:(unsigned)iRepeat;
-(BOOL)insertShotToTarget:(APTarget *)iTarget;
-(void)addHyperspace;

@end
