//
//  APTargetList.m
//  APlayer
//
//  Created by Holger Sadewasser on 6/9/08.
//  Copyright 2008. All rights reserved.
//

#import "APTargetList.h"


@implementation APTargetList

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)init {
  self = [super init];
  if (self != nil) {
    mTargets = [[NSMutableArray alloc] initWithCapacity:40];
    mSaucer = nil;
  }
  return self;
}

-(void)dealloc {
  [mSaucer release];
  [mTargets release];
  [super dealloc];
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)addObject:(APTarget *)iTarget {
  [mTargets addObject:iTarget];
  if ( [[iTarget object] type] == cSaucer ) {
    [iTarget retain];
    [mSaucer release];
    mSaucer = iTarget;
  }
}

-(void)addObjectsFromArray:(APTargetList *)iTargets {
  [mTargets addObjectsFromArray:[iTargets targets]];
  if ( mSaucer == nil ) {
    mSaucer = [iTargets saucer];
  }
}
-(void)removeAllObjects {
  [mTargets removeAllObjects];
  [mSaucer release];
  mSaucer = nil;
}

-(APTarget *)objectAtIndex:(unsigned)iIndex {
  return [mTargets objectAtIndex:iIndex];
}

-(unsigned)count {
  return [mTargets count];
}

-(void)sortUsingSelector:(SEL)iComparator {
  [mTargets sortUsingSelector:iComparator];
}

-(NSArray *)targets {
  return mTargets;
}

-(APTarget *)saucer {
  return mSaucer;
}


@end
