//
//  APTracker.h
//  APlayer
//
//  Created by Holger Sadewasser on 4/19/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APIOChannel.h"
#import "APSaucer.h"
#import "APShip.h"


@interface APTracker : NSObject <IOChannelWriteCallback> {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------

  @public
  int mNumShots;
  int mNumOwnShots;

  APIOChannel * mIOChannel;

  NSMutableArray * mObjects;
  APSaucer * mSaucer;
  APShip * mShip;
  int mNumAsteroids;
  BOOL mFlgShipPresent;
  BOOL mFlgSaucerPresent;
  BOOL mFlgShipInitialized;
  BOOL mFlgSaucerInitialized;
  uint8_t mFrameNo;
  uint8_t mKeys[256];
  int mTimeToLive[256];
  uint8_t mLastPing;
  unsigned int mTotalFrames;
  unsigned int mLostFrames;
  BOOL mFlgFrameNoSet;
  BOOL mFlgSynchronize;
  int mSyncID;

  BOOL mFlgRecordFrames;
  unsigned int mRecordedFrames;
  NSMutableData * mFrames;
  
//  NSMutableArray * mSnapshots;
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

- (id)initWithIOChannel:(APIOChannel *)iIOChannel;
- (void)dealloc;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(NSArray *)interpretScreen:(NSData *)iPacket;
-(uint8_t)lastPing;
-(unsigned int)totalFrames;
-(unsigned int)lostFrames;
-(int)numberOfAsteroids;
-(int)numberOfShots;
-(int)numberOfOwnShots;
-(BOOL)shipPresent;
-(BOOL)saucerPresent;
-(APShip *)ship;
-(APSaucer *)saucer;
//-(void)createSnapshot;
-(NSMutableArray *)objects;
-(void)shotAvailability:(int [])xBuffer;
-(void)setSynchronize:(BOOL)iFlgSynchronize;

@end
