#ifdef COCOA_APP
#import <Cocoa/Cocoa.h>
#else
#include <unistd.h>
#import <Foundation/Foundation.h>
#import "APIOChannel.h"
#import "APPlayer.h"
#endif

BOOL gFlgLogging = NO;

int gTotalTTL11 = 0;
int gTotalTTL1 = 0;
int gTTLCount1 = 0;
int gTotalTTL12 = 0;
int gTotalTTL2 = 0;
int gTTLCount2 = 0;

int main (int argc, char * const argv[]) {
  
#ifndef COCOA_APP
  int arg;
  in_port_t port = 1979;
  char * address = "127.0.0.1";
  
  while ((arg = getopt(argc, argv, "a:p:")) != -1) {
    switch (arg) {
      case 'a':
        address = optarg;
        break;
      case 'p':
        port = strtol(optarg, (char **)NULL, 10);
        break;
      case '?':
      default:
        printf("Valid options:\n");
        printf("\t-a <IP address>    default 127.0.0.1\n");
        printf("\t-p <port>          default 1979\n");
        return 1;
    }
  }
  argc -= optind;
  argv += optind;

  NSLog(@"IP address: %s  port: %d", address, port);
  
  NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
  NSRunLoop * runLoop = [NSRunLoop currentRunLoop];
  APIOChannel * ioChannel = [[APIOChannel alloc] initWithAddress:address port:port];
  APPlayer * player = [[APPlayer alloc] initWithIOChannel:ioChannel maxFrames:0];

  [runLoop run];
  
//  NSLog(@"ttl1: total %d  number %d  average %f  %f", gTotalTTL1, gTTLCount1, (double)gTotalTTL1/(double)gTTLCount1, (double)gTotalTTL11/(double)gTTLCount2);
//  NSLog(@"ttl2: total %d  number %d  average %f  %f", gTotalTTL2, gTTLCount2, (double)gTotalTTL2/(double)gTTLCount2, (double)gTotalTTL12/(double)gTTLCount2);

  [player release];
  [ioChannel release];
  [pool release];
  return 0;

#else
  return NSApplicationMain(argc, (const char **)argv);
#endif
}

