// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include "Tracked_Object.h"

static const int MAX_ASTEROIDS = 30;	// Max number is 27
static const int MAX_SHOTS = 10;

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};



class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	Ship ship;
	bool saucer_present;// UFO sichtbar
	Saucer saucer;
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	int n_player_shots;
	Shot shots[MAX_SHOTS];

	Tracked_Object tracked_ship;
	Tracked_Object *ship_target;
	Tracked_Object *opportunity_target;
	Tracked_Object tracked_saucer;
	Tracked_Object tracked_asteroid[MAX_ASTEROIDS];
	Tracked_Object tracked_shot[MAX_SHOTS];

	bool opportunity_shot;
	bool target_threat;

	int fire_counter;
	int thrust_counter;
	int same_target_counter;
	bool is_thrust_frame;

	GameStatus();
	void clear(void);
	void update_predictions(void);
	void track_objects(void);
	void update_objects(void);
	void update_firing_solutions(void);
	void track_ship(void);
	void track_saucer(void);
	void track_asteroids(void);
	void track_shots(void);
	void turn_ship(KeysPacket &keys);
	bool thrust_ship(void);
	bool fire_shot(void);
	void check_opportunity_shot(void);
	bool ship_can_fire(void);
	bool enter_hyperspace(void);
	void pick_target(void);
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};
