#include "Vector_2d.h"

#define TORUS_X		1024
#define TORUS_Y		768

#define SHOT_RADIUS 2.0
#define VELOCITY_AVERAGING_COEFFICIENT 0.90

#define ASTEROID_RADIUS_SMALL		5.25
#define ASTEROID_RADIUS_MEDIUM		9.0
#define ASTEROID_RADIUS_LARGE		16.5

#define PLAYER_SHIP_RADIUS			17

#define SAUCER_RADIUS_SMALL			5.25
#define SAUCER_RADIUS_LARGE			8.5

#define SHOT_VELOCITY				7.95

#define LEFT_TURN	1
#define RIGHT_TURN	2

#define ACCURACY_FACTOR 0.975


#include "asteroid.h"

typedef struct t_var_struct
{
    double x_shot;
    double y_shot;
    double t_turn;
    double t_fly;
} t_var_struct;

typedef struct t_const_struct
{
    double x_ship;
    double y_ship;
    double fx_ship;
    double fy_ship;
    double x_trgt;
    double y_trgt;
    double vx_trgt;
    double vy_trgt;
    double v_shot;    // total velocity
    double r_turn;    // Turn rate;
} t_const_struct;


class Tracked_Object
{
public:
	Object_Types m_type;

	double m_radius;

	bool m_velocity_known;
	bool m_is_active;
	bool m_is_updated;
	bool m_easy_prey;	// Necessary angle for intercept can be reached easily

// Relevant positions
	struct
	{
		CVector	abs;
		CVector abs_predicted;
		CVector intercept;
	} m_pos;

//	Relevant velocitities
	struct
	{
		CVector abs;
		CVector abs_averaged;
	} m_vel;


//	Relevant directions (for ship)
	struct
	{
		CVector current;
		CVector last[3];
		CVector accurate;
		CVector predicted;
		CVector target;
		int last_turn[3];
		int angle_byte;
		int angle_byte_predicted;
	} m_dir;

	int m_time_to_hit;
	int m_incoming_shots;
	double m_shot_travel_time;
	double m_ship_turn_time;

	Tracked_Object(void);
	void set_inactive(void);

	void track(Asteroid *p_asteroid);
	void track(Shot *p_shot, int shot_idx, Tracked_Object &ship, Tracked_Object &saucer);
	void track(Saucer *p_saucer);
	void track(Ship *p_ship);

	bool enough_shots(void);
	bool can_hit(Tracked_Object *target);

	double current_distance_from(Tracked_Object &other_object);
	double current_distance_from(double x0, double y0);

	void backup_firing_solution_to(Tracked_Object *target);
//	bool sim_firing_solution_to(Tracked_Object *target);
	void old_newton_firing_solution_to(Tracked_Object *target);
	void newton_firing_solution_to(Tracked_Object *target);
	bool newton_iteration(	t_var_struct &t_var,
							t_const_struct &t_con,
							t_var_struct &delta_t_var);
	void update_easy_prey(Tracked_Object *target);

	double distance_from(Tracked_Object &other_object);
	double distance_from(double x0, double y0);

	double minimum_distance_from(Tracked_Object &other_object);
	double time_to_minimum_distance_from(Tracked_Object &other_object);

	double predicted_distance_from(Tracked_Object &other_object);
	double predicted_distance_from(double x0, double y0);

	void predict_position(void);

	void update_angle(void);
};
