#include <math.h>
#include "Vector_2d.h"

CVector::CVector(void)
{
	m_x = 0;
	m_y = 0;
}

CVector::CVector(double x0, double y0)
{
	m_x = x0;
	m_y = y0;
}
CVector::CVector(const CVector& vec0)
{
	m_x = vec0.m_x;
	m_y = vec0.m_y;
}

double CVector::get_x()
{
	return(m_x);
}

double CVector::get_y()
{
	return(m_y);
}
void CVector::set_x(double x0)
{
	m_x = x0;
}

void CVector::set_y(double y0)
{
	m_y = y0;
}

void CVector::set_xy(double x0, double y0)
{
	m_x = x0;
	m_y = y0;
}

void CVector::normalize(void)
{
	double len;

	len = this->length();

	m_x = m_x / len;
	m_y = m_y / len;
}

CVector CVector::operator+(CVector v_sum)
{
	CVector temp;
	temp.m_x = m_x + v_sum.m_x;
	temp.m_y = m_y + v_sum.m_y;
	return(temp);
}


CVector CVector::operator-(CVector v_sub)
{
	CVector temp;
	temp.m_x = m_x - v_sub.m_x;
	temp.m_y = m_y - v_sub.m_y;
	return(temp);
}

CVector CVector::operator*(double mult)
{
	CVector temp;
	temp.m_x = mult * m_x;
	temp.m_y = mult * m_y;
	return(temp);
}

double CVector::dot_prod(CVector v_dp)
{
	return(m_x * v_dp.m_x + m_y * v_dp.m_y);
}

double CVector::cross_prod(CVector v_cp)
{
	return(m_x * v_cp.m_y - m_y * v_cp.m_x);
}

double CVector::length(void)
{
	return(sqrt(m_x * m_x + m_y * m_y));
}

double CVector::dot_prod_norm(CVector v_dp)	// Normalized dot product
{
	if((this->length() * v_dp.length()) == 0.0)
	{	return(1.0);	}

	return(	(m_x * v_dp.m_x + m_y * v_dp.m_y) /
			(this->length() * v_dp.length()		)	);
}

double CVector::cross_prod_norm(CVector v_cp)
{
	if((this->length() * v_cp.length()) == 0.0)
	{	return(0.0);	}

	return(	(m_x * v_cp.m_y - m_y * v_cp.m_x)	/
			(this->length() * v_cp.length())	);
}

// Give "absolute" angle (0/360 = facing right, 90: facing up)
double CVector::angle_abs(void)
{
	CVector dummy;
	double angle;

	dummy.set_xy(1.0, 0.0);
	angle = dummy.angle_to(*this);

	return(angle);
}

double CVector::angle_to(CVector v_angle)
{
	double angle;

	angle = this->dot_prod_norm(v_angle);
	if(angle > 1.0)
	{	angle	= 1.0;	}
	else if(angle < -1.0)
	{	angle = - 1.0;	}
	angle = acos(angle);
	if(cross_prod_norm(v_angle) < 0)
		{	angle = - angle;	}

	return(angle);
}

double CVector::distance_to( CVector v_dist)
{
	CVector temp;
	temp = v_dist - *this;

	return(temp.length());
}

// Die linke untere Ecke ist bei (0, 128), die rechte obere bei (1023, 895).
// Normalize torus coordinates. 0,0 is the middle of the screen
void CVector::torus_wrap(double tsize_x, double tsize_y)
{
	while(m_x < - (tsize_x / 2))
		m_x += tsize_x;
	while(m_x > (tsize_x / 2) - 1)
		m_x -= tsize_x;

	while(m_y < - (tsize_y / 2))
		m_y += tsize_y;
	while(m_y > (tsize_y / 2) - 1)
		m_y -= tsize_y;
}

void CVector::torus_wrap_absolute(void)
{
	while(m_x < 0)
		m_x += 1024;
	while(m_x > 1023)
		m_x -= 1024;

	while(m_y < 128)
		m_y += 896;
	while(m_y > 895)
		m_y -= 896;
}
