class CVector
{
private:
	double m_x, m_y;
public:
	CVector(void);
	CVector(double x0, double y0);
	CVector(const CVector& vec0);
	double get_x();
	double get_y();
	void set_x(double x0);
	void set_y(double y0);
	void set_xy(double x0, double y0);
	void normalize(void);
	CVector operator+(CVector v_sum);
	CVector operator-(CVector v_sub);
	CVector operator*(double mult);
	double dot_prod(CVector v_dp);
	double cross_prod(CVector v_cp);
	double length(void);
	double dot_prod_norm(CVector v_dp);	// Normalized dot product
	double cross_prod_norm(CVector v_cp);
	double angle_abs(void);
	double angle_to(CVector v_angle);
	double distance_to(CVector v_dist);
	void torus_wrap(double tsize_x, double tsize_y); // Perform torus wraparound used in Asteroids
	void torus_wrap_absolute(void); // Perform torus wraparound used in Asteroids
};