package de.fhr.asteroids;

import java.awt.Color;

/**
 * An asteroid object of the game.
 * @author Florian Lutz
 * @version 1.1
 */
final class Asteroid extends Target {

  /**
   * The type of the asteroid.
   */
  private final int type;

  /**
   * Creates a new asteroid with the specified.
   * @param px the x-position
   * @param py the y-position
   * @param type the type of the asteroid
   * @param gsf the scaling factor
   */
  Asteroid(final int px, final int py, final int type, final int gsf) {
    super(px, py, gsf);
    this.type = type;
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.Drawable#draw(de.fhr.asteroids.FlipGraphics)
   */
  public void draw(final FlipGraphics g) {
    final int r = radius();
    g.setColor(Color.WHITE);
    g.drawCircle(px, py, r);
    g.setColor(Color.CYAN);
    drawSpeed(g);
    drawValues(g, -17, -r - 14);
    if (willbehit) {
      g.setColor(Color.ORANGE);
      g.drawCircle(px, py, r + 2);
    }
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.ScreenObject#radius()
   */
  @Override
  int radius() {
    switch (gsf) {
    case 14: // small
      return 8;
    case 15: // medium
      return 16;
    default: // huge
      return 32;
    }
  }

  /**
   * Compares the type and scaling factor of this asteroid.
   * @param t the type to compare with
   * @param g the scaling factor to compare with
   * @return if the type and scalinf are the same
   */
  boolean sameTypeGsf(final int t, final int g) {
    return type == t && gsf == g;
  }
}
