package de.fhr.asteroids;

/**
 * A point to hold calculated vector values.
 * @author Florian Lutz
 * @version 1.1
 */
final class Point extends GameObject {

  /**
   * The angelbyte the ship must turn to in order to reach this point.
   */
  int ab = -1;

  /**
   * Creates a new point at the specified position.
   * @param px the x-value of the point
   * @param py the y-value of the point
   */
  Point(final int px, final int py) {
    super(px, py);
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.Drawable#draw(de.fhr.asteroids.FlipGraphics)
   */
  public void draw(final FlipGraphics g) {
    g.drawLine(px + 4, py, px - 4, py);
    g.drawLine(px, py + 4, px, py - 4);
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.ScreenObject#radius()
   */
  @Override
  int radius() {
    return 0;
  }

  /**
   * Takes over the values from an object of the game.
   * @param o the object
   */
  void take(final GameObject o) {
    px = o.px;
    py = o.py;
    vx = 0;
    vy = 0;
    ab = -1;
    speed = 0;
    updated = false;
  }

  /**
   * Takes over the values from another Point.
   * @param p the other point
   */
  void take(final Point p) {
    px = p.px;
    py = p.py;
    vx = 0;
    vy = 0;
    ab = p.ab;
    speed = 0;
    updated = false;
  }
}
