package de.fhr.asteroids;

import java.awt.Color;

/**
 * A saucer withing the asteroids game.
 * @author Florian Lutz
 * @version 1.1
 */
final class Saucer extends Target {

  /**
   * The height of the saucer.
   */
  private final int h;

  /**
   * The width of the saucer.
   */
  private final int w;

  /**
   * Creates a new saucer with the specified position.
   * @param px the x-value of the saucer position
   * @param py the y-value of the saucer position
   * @param gsf the scaling factor of the sacuer
   */
  Saucer(final int px, final int py, final int gsf) {
    super(px, py, gsf);
    final int r = radius();
    w = 2 * r + r / 2;
    h = 2 * r - r / 2;
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.Drawable#draw(de.fhr.asteroids.FlipGraphics)
   */
  public void draw(final FlipGraphics g) {
    g.setColor(Color.WHITE);
    g.drawOval(px - w / 2, py - h / 2, w, h);
    g.drawLine(px - w / 2, py, px + w / 2, py);
    g.setColor(Color.RED);
    drawSpeed(g);
    drawValues(g, -17, -h / 2 - 14);
    if (willbehit) {
      g.setColor(Color.ORANGE);
      g.drawOval(px - w / 2 - 2, py - h / 2 - 2, w + 4, h + 4);
    }
  }

  /**
   * {@inheritDoc}
   * @see de.fhr.asteroids.GameObject#radius()
   */
  @Override
  int radius() {
    switch (gsf) {
    case 14: // Small
      return 8;
    default: // Huge
      return 16;
    }
  }
}
