// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
// Modifiziert von StS

#include "player.h"
#include <string>

#include <fenv.h>

//#pragma STDC FENV_ACCESS ON

using namespace std;


extern HGE* hge;
extern hgeFont* fnt;
// extern bool RedrawDebugWindow;
extern bool RenderFunc();
extern bool FrameFunc();
//extern ShotVector ShotPredictionTable;

bool RedrawDebugWindow = false;
int cGO = 0;
int TestCounter = 0;
int ShotDelay, ActivePlayerShots;
bool ReCalibrate, OutOfSync;
int OutOfSyncCnt, CalibrateCnt;
int Score = 0;
int GameTime = 0;
int Level = 0;
bool ReadScore;
int LastTargetID;
int raised;
int ShipJobCnt = 0;
int FramesSinceLastUfo, FramesSinceLevelStart;
bool UfoHunt;

FramePacket frame;
KeysPacket keys;
GameStatus game[max_GameObjects];
DebugWindow debugWindow;

int ShotTrackerPtr;
ShotVector ShotTrackerTable[max_ShotTrackers];
ShotVector NextShotTracker;

int AstTrackerPtr;
AstVector AstTrackerTable[max_AstTrackers];
const int UfoID = 0x7654321;
const int TargettingCorrection = 0;
const int FramesBehind = 1;
const float ShotSpeed = 8;
const int ShipRad = 14;
const int SmallSaucerSizeD2 = 6;
const int BigSaucerSizeD2 = 12;
const int ScrYOff = 128;
const int ScrWidth = 1024;
const int ScrHeight = 768;
const int VectorSize = 30;
const int AstScaleDiv2[16] = { 29, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 8, 17 };  // fr Grafiken und Kollisionstest
//const int AstTgtRadTab[16] = { 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 10 };  // fr Berechnung Streuwinkel
//const int AstTgtRadTab[16] = { 24, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 12 };  // fr Berechnung Streuwinkel
const int AstTgtRadTabHi[16] = { 12, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 12 };  // fr Berechnung Streuwinkel
const int AstTgtRadTabMd[16] = { 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 10 };  // fr Berechnung Streuwinkel
const int AstTgtRadTabLo[16] = { 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 8 };  // fr Berechnung Streuwinkel

enum ShipJobs{None, Error, Calibrate, Calibrate2, TurnRight, TurnLeft, WaitAWhile, TestTurnRight, TestShot, Thrust };
ShipJobs CurrentShipJob;

const int CalSteps = 7;
Vector CalTab[CalSteps];

int ShipRotation;
ShipVector SVTable[256];

int Debug_TargetX, Debug_TargetY;
int TgtAX, TgtAY, TgtBX, TgtBY, TgtCX, TgtCY, TgtCnt, TgtAX2, TgtAY2, TgtDeg, TgtDeg2, TgtDegSz, TgtDistance, TgtDist;
float TgtAlpha, TgtBeta, TgtGamma, TgtSteps;
bool IntersectH, IntersectV, IntersectColl;
int IntersectX, IntersectY, IntersectVCnt, IntersectHCnt, IntersectCnt;

int Coll_MaxSmallUnderfire, Coll_MaxMedUnderfire, Coll_MaxBigUnderfire, Coll_MaxSmallSteps, Coll_MaxSteps;
int Best_MaxSmallUnderfire, Best_MaxMedUnderfire, Best_MaxBigUnderfire, Best_MaxSmallSteps, Best_MaxMedMultBulletsSteps, Best_MaxBigMultBulletsSteps;
int Scnd_MaxSmallUnderfire, Scnd_MaxMedUnderfire, Scnd_MaxBigUnderfire, Scnd_MaxSteps, Scnd_MaxMedMultBulletsSteps, Scnd_MaxBigMultBulletsSteps;
int MaxMedObjcount, MaxBigObjcount, MaxSmallTTL, MaxMedTTL, MaxBigTTL, MaxUfoTTL;
bool WaitForUfo;
int UfoTgtY, DontThrustCnt;
int Size2MaxTTL[16];
int nBigAsteroids, nMedAsteroids, nSmallAsteroids;
int NearestObj, MaxUfoUnderfire;
int TweakFlags, LastTweakFlags;

GameStatus *lgame1, *lgame2;
//, *lgame3, *lgame4, *lgame5, *lgame6, *lgame7, *lgame8;


void ChkFPU(int number)
{
    raised = fetestexcept(FE_ALL_EXCEPT & ~FE_INEXACT);
    if (raised)
    {
        printf("FPU Exception at Checkpoint %d: ",number);
        switch (raised)
        {
            case FE_INEXACT:
                printf("FE_INEXACT\n");
                break;
            case FE_DIVBYZERO:
                printf("FE_DIVBYZERO\n");
                break;
            case FE_UNDERFLOW:
                printf("FE_UNDERFLOW\n");
                break;
            case FE_OVERFLOW:
                printf("FE_OVERFLOW\n");
                break;
            case FE_INVALID:
                printf("FE_INVALID\n");
                break;
            default:
                printf("FE_???\n");
        }
        feclearexcept(FE_ALL_EXCEPT);
    }
}

void ClrFPU()
{
    feclearexcept(FE_ALL_EXCEPT);
}


void DrawRect(int x, int y, int w, int h, int col)
{
    y = ScrHeight-y;
    hge->Gfx_RenderLine(x-w,y-h, x+w,y-h, col);
    hge->Gfx_RenderLine(x+w,y-h, x+w,y+h, col);
    hge->Gfx_RenderLine(x+w,y+h, x-w,y+h, col);
    hge->Gfx_RenderLine(x-w,y+h, x-w,y-h, col);
}

void DrawShot(int x, int y, int col)
{
    y = ScrHeight-y;
    hge->Gfx_RenderLine(x-1,y-1, x+1,y+1, col);
    hge->Gfx_RenderLine(x+1,y-1, x-1,y+1, col);
}

void DrawLine(int ax, int ay, int ex, int ey, int col)
{
    hge->Gfx_RenderLine(ax,ScrHeight-ay, ex,ScrHeight-ey, col);
}

void DrawVector(int x, int y, float vx, float vy, float len, int col)
{
    float n, nx, ny, nx1, ny1, nx2, ny2, nx3, ny3;

    y = ScrHeight-y;
    vy = -vy;
    n = sqrtf(vx*vx + vy*vy);
    if (n!=n) printf("Fehler in DrawVector");
    nx = vx/n;
    ny = vy/n;
    nx1 = nx*len;
    ny1 = ny*len;
    nx2 = nx*4;
    ny2 = ny*4;
    nx3 = nx1-nx*10;
    ny3 = ny1-ny*10;

    hge->Gfx_RenderLine(x,y, x+nx1,y+ny1, col);
    hge->Gfx_RenderLine(x+nx1,y+ny1, x+nx3-ny2,y+ny3+nx2, col);
    hge->Gfx_RenderLine(x+nx1,y+ny1, x+nx3+ny2,y+ny3-nx2, col);
    hge->Gfx_RenderLine(x+nx3-ny2,y+ny3+nx2, x+nx3+ny2,y+ny3-nx2, col);
}

void DrawCircle(int x, int y, int r, int col)
{
    float cs = PI*2/12;
    int x1, y1;

        for (int i=1;i<=12;i++)
        {
            x1 = x+r*sin(i*cs);
            y1 = ScrHeight-y+r*cos(i*cs);
            hge->Gfx_RenderLine(x1,y1,x1+1,y1+1, col);
        }
}

void DrawPlayer(int x, int y, float vx, float vy, int col)
{
    float n, nx, ny, nx1, nx2, ny1, ny2;
    y = ScrHeight-y;
    vy = -vy;

    n = sqrtf(vx*vx + vy*vy);
    if (n!=n) printf("Fehler in DrawPlayer");
    nx = vx/n;
    ny = vy/n;
    nx1 = nx*16;
    ny1 = ny*16;
    nx2 = nx*10;
    ny2 = ny*10;

    hge->Gfx_RenderLine(x+nx1,y+ny1, x-nx2-ny2,y-ny2+nx2, col);
    hge->Gfx_RenderLine(x+nx1,y+ny1, x-nx2+ny2,y-ny2-nx2, col);
    hge->Gfx_RenderLine(x-nx2-ny2,y-ny2+nx2, x-nx2+ny2,y-ny2-nx2, col);
}

void RenderDebugScreen()
{
    int i = 0;
    int tx, ty, x, y, t;

    ClrFPU();
    if (RedrawDebugWindow)
    {
        GameStatus &rgame = game[cGO];

        RedrawDebugWindow = false;
        hge->Gfx_BeginScene();
        hge->Gfx_Clear(0);

        fnt->SetColor(0xff00ccff);
        fnt->SetScale(1.0);
        fnt->printf(0, 0, HGETEXT_LEFT, "Level: %d", Level);
        fnt->printf(100, 0, HGETEXT_LEFT, "Score: %d", Score);
        if ( GameTime > 0 )
        {
            fnt->printf(250, 0, HGETEXT_LEFT, "Geschaetzt: %d", int (Score * 18000 / GameTime));
        }

        fnt->printf(450, 0, HGETEXT_LEFT, "Frames: %d", GameTime);
        fnt->SetScale(0.8);
        fnt->printf(0, 15, HGETEXT_LEFT, "Big: %d", nBigAsteroids);
        fnt->printf(0, 25, HGETEXT_LEFT, "Med: %d", nMedAsteroids);
        fnt->printf(0, 35, HGETEXT_LEFT, "Sml: %d", nSmallAsteroids);
        fnt->printf(100, 15, HGETEXT_LEFT, "WaitFUfo: %d", WaitForUfo);
        fnt->printf(100, 25, HGETEXT_LEFT, "FSLstUfo: %d", FramesSinceLastUfo);
        fnt->printf(100, 35, HGETEXT_LEFT, "FSLvStrt: %d", FramesSinceLevelStart);

        if ( true )
        {
            for (i=0;i<rgame.nasteroids;i++)
            {
                t = AstScaleDiv2[rgame.asteroids[i].sf];
                if (rgame.asteroids[i].Collision)
                {
                    DrawRect(rgame.asteroids[i].x, rgame.asteroids[i].y, t, t, 0xffff5555);
                }
                else
                {
                    DrawRect(rgame.asteroids[i].x, rgame.asteroids[i].y, t, t, 0xffcccccc);
                }
                if ( (rgame.asteroids[i].vx || rgame.asteroids[i].vy) != 0 )
                {
                    DrawVector(rgame.asteroids[i].x, rgame.asteroids[i].y, rgame.asteroids[i].vx, rgame.asteroids[i].vy, VectorSize, 0xff00ff00);
    //                DrawCircle(rgame.asteroids[i].TargetX, rgame.asteroids[i].TargetY, rgame.asteroids[i].targetsize, 0xffcc0000);
                    tx = rgame.asteroids[i].x;
                    ty = ScrHeight - rgame.asteroids[i].y;
                    if (rgame.asteroids[i].underfire > 0)
                    {
                        fnt->SetColor(0xff0066ff);
                        fnt->printf(tx, ty-16, HGETEXT_LEFT, "uf: %d", rgame.asteroids[i].underfire);
                        fnt->SetColor(0xff00ccff);
                    }
                    if (rgame.asteroids[i].Collision)
                    {
                        fnt->SetColor(0xffcc0000);
                        fnt->printf(tx, ty-8, HGETEXT_LEFT, "col: -%d", rgame.asteroids[i].IntersectCnt);
                        fnt->SetColor(0xff00ccff);
                    }
                    fnt->printf(tx, ty, HGETEXT_LEFT, "Deg: %d", rgame.asteroids[i].Deg);
    //                fnt->printf(tx, ty+8, HGETEXT_LEFT, "Stps: %d", rgame.asteroids[i].TargetSteps);
                }
            }

            if (rgame.ship_present)
            {
                DrawPlayer(rgame.ship_x, rgame.ship_y, rgame.ship_dx, rgame.ship_dy, 0xffffff44);
                tx = rgame.ship_x;
                ty = ScrHeight - rgame.ship_y + 8;
                fnt->printf(tx, ty+8, HGETEXT_LEFT, "Rot: %d", int(ShipRotation));
                fnt->printf(tx, ty+16, HGETEXT_LEFT, "Deg: %d", int(SVTable[ShipRotation].angle_deg2));
                fnt->printf(tx, ty+24, HGETEXT_LEFT, "JobCnt: %d", int(ShipJobCnt));
                if (TgtCnt > 0)
                {
                    DrawCircle(Debug_TargetX, Debug_TargetY, 25, 0xff7777ff);
                }
            }

            for (i=0;i<rgame.nshots;i++)
            {
                if (rgame.shots[i].fromplayer)
                {
                    t = rgame.shots[i].trackerindex;
                    if ( ShotTrackerTable[t].id != 0)
                    {
                        x = ShotTrackerTable[t].px + ShotTrackerTable[t].TTL * ShotTrackerTable[t].dx;
                        y = ShotTrackerTable[t].py + ShotTrackerTable[t].TTL * ShotTrackerTable[t].dy;
                        DrawLine(ShotTrackerTable[t].px, ShotTrackerTable[t].py, x, y, 0xff111144);
                    }
                    DrawShot(rgame.shots[i].x, rgame.shots[i].y, 0xff44ff44);

                }
                else
                {
                    if ( (rgame.shots[i].vx !=0 | rgame.shots[i].vy != 0) )
                        DrawVector(rgame.shots[i].x, rgame.shots[i].y, rgame.shots[i].vx, rgame.shots[i].vy, VectorSize, 0xff662222);
                    DrawShot(rgame.shots[i].x, rgame.shots[i].y, 0xffff8888);
                }
            }

            for (i=0;i<max_ShotTrackers;i++)
            {
                if (ShotTrackerTable[i].id != 0)
                {
                    float x = ShotTrackerTable[i].x;
                    float y = ShotTrackerTable[i].y;
                    DrawShot(x,y,0xffff0000);
                }
            }


            if (rgame.saucer_present)
            {
                if (rgame.saucer_size == 14)
                {
                    DrawRect(rgame.saucer_x, rgame.saucer_y, 8, 8, 0xffff6666);   // Small Ufo
                }
                else
                {
                    DrawRect(rgame.saucer_x, rgame.saucer_y, 16, 10, 0xffcc3333);
                }
                if ( rgame.saucer_underfire > 0 )
                {
                    fnt->SetColor(0xffcc0000);
                    fnt->printf(rgame.saucer_x, ScrHeight-rgame.saucer_y-16, HGETEXT_LEFT, "uf: %d", rgame.saucer_underfire);
                    fnt->SetColor(0xff00ccff);
                }
                fnt->printf(rgame.saucer_x, ScrHeight-rgame.saucer_y+8, HGETEXT_LEFT, "vx: %f", rgame.saucer_vx);
                fnt->printf(rgame.saucer_x, ScrHeight-rgame.saucer_y+16, HGETEXT_LEFT, "vy: %f", rgame.saucer_vy);
            }
        }

        hge->Gfx_EndScene();
    }
    ChkFPU(10);
}


// This function will be called by HGE once per frame.
bool FrameFunc()
{
    RenderDebugScreen();
    return false;
}


// This function will be called by HGE when
// the application window should be redrawn.
bool RenderFunc()
{
//    RenderDebugScreen();
    return false;
}


bool ReadShipVectors()
{
    FILE   *stream;
    int of, dx, dy;
    float n;

    ClrFPU();
    stream = fopen("ShipRotation_alt.txt","r");
    if (stream==NULL)
        return(0);
    for (int i=0;i<256;i++)
    {
        of = (i+0xc0) & 0xff;
        if (fscanf(stream, "%d, %d, %d, %d", &SVTable[of].dx, &SVTable[of].dy, &SVTable[of].svx, &SVTable[of].svy) != 4)
            return(0);
    }
    fclose(stream);

    // Zu jeder Position den zugehrigen Winkel erstellen
    for (int i=0;i<256;i++)
    {
        SVTable[i].angle2 = 2*PI * (i*3 & 0xff) / 256;
        SVTable[i].angle_deg2 = int (SVTable[i].angle2 * 180 / PI);
        SVTable[i].angle = atan2(SVTable[i].svx, SVTable[i].svy)+PI;
        SVTable[i].angle_deg = int ( fmod( SVTable[i].angle * 180 / PI, 360));
    }
    ChkFPU(20);

    return(1);
}


int normx(int x)
{
    while (x < -512) x += 1024;
    while (x > 511) x -= 1024;
    return x;
}

int normy(int y)
{
    while (y < -384) y += 768;
    while (y > 383) y -= 768;
    return y;
}



void SetShotAngle(GameStatus& rgame, Asteroid& rAst)
{
// Vorhalteposition und Winkel fr den Asteroiden in 4facher Ausfertigung bestimmen
    float vx1, vy1, vx2, vy2, ts, td, tds, td2, a1, a2, a, b, c, s, Alpha, Beta, Gamma;
    int dd, t, tgtsz;

    vx1 = rAst.vx - rgame.ship_vx;
    vy1 = rAst.vy - rgame.ship_vy;
    if ( vx1 || vy1 != 0)
    {
        b = rAst.speed = sqrt(vx1 * vx1 + vy1 * vy1);
        c = ShotSpeed;
// 1. Quadrant
        vx2 = normx(rgame.ship_x - rAst.x);
        vy2 = normy(rgame.ship_y - rAst.y);
        a1 = sqrt(vx2 * vx2 + vy2 * vy2);   // Abstand zum Schiff
        rAst.Q1_Distance = int(a1);
        td = (vx1*vx2 + vy1*vy2) / (b * a1);
        if (td>1) td = 1;
        else if (td<-1) td =-1;
        Gamma = acos(td);
        Beta = asin(b * sin(Gamma) / c);
        Alpha = PI - Beta - Gamma;
        a2 = sqrt(b*b + c*c - 2*b*c*cos(Alpha));
        if (a2 != 0) s = a1 / a2;
        rAst.Q1_TargetX = rAst.x + s * vx1;
        rAst.Q1_TargetY = rAst.y + s * vy1;
        rAst.Q1_TargetSteps = int(s)+2;
// Bewegungsrichtung nur vom Quadranten mit geringstem Abstand
        Alpha = atan2(vx2, vy2)+PI;
        Beta = atan2(vx1, vy1)+PI*2;
        rAst.Deg = int (fmod(((Alpha + PI*4 - Beta)* 180 / PI),360)-180);

// 2. Quadrant
        if (vx2<0) vx2 += 1024;
        else vx2 -= 1024;
        a1 = sqrt(vx2 * vx2 + vy2 * vy2);
        rAst.Q2_Distance = int(a1);
        td = (vx1*vx2 + vy1*vy2) / (b * a1);
        if (td>1) td = 1;
        else if (td<-1) td =-1;
        Gamma = acos(td);
        Beta = asin(b * sin(Gamma) / c);
        Alpha = PI - Beta - Gamma;
        a2 = sqrt(b*b + c*c - 2*b*c*cos(Alpha));
        if (a2 != 0) s = a1 / a2;
        rAst.Q2_TargetX = rAst.x + s * vx1;
        rAst.Q2_TargetY = rAst.y + s * vy1;
        rAst.Q2_TargetSteps = int(s)+2;

// 3. Quadrant
        if (vy2<0) vy2 += 768;
        else vy2 -= 768;
        a1 = sqrt(vx2 * vx2 + vy2 * vy2);   // Abstand zum Schiff
        rAst.Q3_Distance = int(a1);
        td = (vx1*vx2 + vy1*vy2) / (b * a1);
        if (td>1) td = 1;
        else if (td<-1) td =-1;
        Gamma = acos(td);
        Beta = asin(b * sin(Gamma) / c);
        Alpha = PI - Beta - Gamma;
        a2 = sqrt(b*b + c*c - 2*b*c*cos(Alpha));
        if (a2 != 0) s = a1 / a2;
        rAst.Q3_TargetX = rAst.x + s * vx1;
        rAst.Q3_TargetY = rAst.y + s * vy1;
        rAst.Q3_TargetSteps = int(s)+2;

// 4. Quadrant
        if (vx2<0) vx2 += 1024;
        else vx2 -= 1024;
        a1 = sqrt(vx2 * vx2 + vy2 * vy2);   // Abstand zum Schiff
        rAst.Q4_Distance = int(a1);
        td = (vx1*vx2 + vy1*vy2) / (b * a1);
        if (td>1) td = 1;
        else if (td<-1) td =-1;
        Gamma = acos(td);
        Beta = asin(b * sin(Gamma) / c);
        Alpha = PI - Beta - Gamma;
        a2 = sqrt(b*b + c*c - 2*b*c*cos(Alpha));
        if (a2 != 0) s = a1 / a2;
        rAst.Q4_TargetX = rAst.x + s * vx1;
        rAst.Q4_TargetY = rAst.y + s * vy1;
        rAst.Q4_TargetSteps = int(s)+2;
    }
    else
    {
        rAst.Deg = ShipRotation;
        rAst.Q1_TargetX = rAst.x;
        rAst.Q1_TargetY = rAst.y;
        rAst.Q1_TargetSteps = 999;
        rAst.Q2_TargetX = rAst.x;
        rAst.Q2_TargetY = rAst.y;
        rAst.Q2_TargetSteps = 999;
        rAst.Q3_TargetX = rAst.x;
        rAst.Q3_TargetY = rAst.y;
        rAst.Q3_TargetSteps = 999;
        rAst.Q4_TargetX = rAst.x;
        rAst.Q4_TargetY = rAst.y;
        rAst.Q4_TargetSteps = 999;
    }

//  Winkel zum Vorhaltepunkt berechnen
// Quadrant 1
    tgtsz = AstTgtRadTabLo[rAst.sf];
    if (rAst.Q1_TargetSteps > 55) tgtsz = AstTgtRadTabHi[rAst.sf];
    else if (rAst.Q1_TargetSteps > 30) tgtsz = AstTgtRadTabMd[rAst.sf];
    vx1 = normx(rgame.ship_x - rAst.Q1_TargetX);
    vy1 = normy(rgame.ship_y - rAst.Q1_TargetY);
    Alpha = atan2(vx1, vy1)+PI;
    rAst.Q1_TargetDeg = td = int (fmod(Alpha * 180 / PI,360));
    vx2 = sin(Alpha+PI/2) * tgtsz;
    vy2 = cos(Alpha+PI/2) * tgtsz;
    vx1 += vx2;
    vy1 += vy2;
    Beta = atan2(vx1, vy1)+PI;
    td2 = int (fmod(Beta * 180 / PI, 360));
    tds = td - td2;
    while (tds < -180) tds += 360;
    while (tds > 180) tds -= 360;
    rAst.Q1_TargetDegSz = abs(int(tds));
    dd = (SVTable[ShipRotation].angle_deg2 - rAst.Q1_TargetDeg);
    while (dd < -180) dd += 360;
    while (dd > 180) dd -= 360;
    dd = abs(dd) / 4.21875;
    dd -= rAst.TargetDegSz;
    if (dd<0) dd = 0;
    rAst.Q1_TargetDegSteps = dd;

// Quadrant 2
    tgtsz = AstTgtRadTabLo[rAst.sf];
    if (rAst.Q2_TargetSteps > 55) tgtsz = AstTgtRadTabHi[rAst.sf];
    else if (rAst.Q2_TargetSteps > 30) tgtsz = AstTgtRadTabMd[rAst.sf];
    vx1 = normx(rgame.ship_x - rAst.Q2_TargetX);
    vy1 = normy(rgame.ship_y - rAst.Q2_TargetY);
    Alpha = atan2(vx1, vy1)+PI;
    rAst.Q2_TargetDeg = td = int (fmod(Alpha * 180 / PI,360));
    vx2 = sin(Alpha+PI/2) * tgtsz;
    vy2 = cos(Alpha+PI/2) * tgtsz;
    vx1 += vx2;
    vy1 += vy2;
    Beta = atan2(vx1, vy1)+PI;
    td2 = int (fmod(Beta * 180 / PI, 360));
    tds = td - td2;
    while (tds < -180) tds += 360;
    while (tds > 180) tds -= 360;
    rAst.Q2_TargetDegSz = abs(int(tds));
    dd = (SVTable[ShipRotation].angle_deg2 - rAst.Q2_TargetDeg);
    while (dd < -180) dd += 360;
    while (dd > 180) dd -= 360;
    dd = abs(dd) / 4.21875;
    dd -= rAst.TargetDegSz;
    if (dd<0) dd = 0;
    rAst.Q2_TargetDegSteps = dd;

// Quadrant 3
    tgtsz = AstTgtRadTabLo[rAst.sf];
    if (rAst.Q3_TargetSteps > 55) tgtsz = AstTgtRadTabHi[rAst.sf];
    else if (rAst.Q3_TargetSteps > 30) tgtsz = AstTgtRadTabMd[rAst.sf];
    vx1 = normx(rgame.ship_x - rAst.Q3_TargetX);
    vy1 = normy(rgame.ship_y - rAst.Q3_TargetY);
    Alpha = atan2(vx1, vy1)+PI;
    rAst.Q3_TargetDeg = td = int (fmod(Alpha * 180 / PI,360));
    vx2 = sin(Alpha+PI/2) * tgtsz;
    vy2 = cos(Alpha+PI/2) * tgtsz;
    vx1 += vx2;
    vy1 += vy2;
    Beta = atan2(vx1, vy1)+PI;
    td2 = int (fmod(Beta * 180 / PI, 360));
    tds = td - td2;
    while (tds < -180) tds += 360;
    while (tds > 180) tds -= 360;
    rAst.Q3_TargetDegSz = abs(int(tds));
    dd = (SVTable[ShipRotation].angle_deg2 - rAst.Q3_TargetDeg);
    while (dd < -180) dd += 360;
    while (dd > 180) dd -= 360;
    dd = abs(dd) / 4.21875;
    dd -= rAst.TargetDegSz;
    if (dd<0) dd = 0;
    rAst.Q3_TargetDegSteps = dd;

// Quadrant 4
    tgtsz = AstTgtRadTabLo[rAst.sf];
    if (rAst.Q4_TargetSteps > 55) tgtsz = AstTgtRadTabHi[rAst.sf];
    else if (rAst.Q4_TargetSteps > 30) tgtsz = AstTgtRadTabMd[rAst.sf];
    vx1 = normx(rgame.ship_x - rAst.Q4_TargetX);
    vy1 = normy(rgame.ship_y - rAst.Q4_TargetY);
    Alpha = atan2(vx1, vy1)+PI;
    rAst.Q4_TargetDeg = td = int (fmod(Alpha * 180 / PI,360));
    vx2 = sin(Alpha+PI/2) * tgtsz;
    vy2 = cos(Alpha+PI/2) * tgtsz;
    vx1 += vx2;
    vy1 += vy2;
    Beta = atan2(vx1, vy1)+PI;
    td2 = int (fmod(Beta * 180 / PI, 360));
    tds = td - td2;
    while (tds < -180) tds += 360;
    while (tds > 180) tds -= 360;
    rAst.Q4_TargetDegSz = abs(int(tds));
    dd = (SVTable[ShipRotation].angle_deg2 - rAst.Q4_TargetDeg);
    while (dd < -180) dd += 360;
    while (dd > 180) dd -= 360;
    dd = abs(dd) / 4.21875;
    dd -= rAst.TargetDegSz;
    if (dd<0) dd = 0;
    rAst.Q4_TargetDegSteps = dd;

    t = 1;
    dd = rAst.Q1_TargetSteps + rAst.Q1_TargetDegSteps;
    if (dd> rAst.Q2_TargetSteps + rAst.Q2_TargetDegSteps)
    {
        t = 2;
        dd = rAst.Q2_TargetSteps + rAst.Q2_TargetDegSteps;
    }
    if (dd> rAst.Q3_TargetSteps + rAst.Q3_TargetDegSteps)
    {
        t = 3;
        dd = rAst.Q3_TargetSteps + rAst.Q3_TargetDegSteps;
    }
    if (dd> rAst.Q4_TargetSteps + rAst.Q4_TargetDegSteps)
    {
        t = 4;
        dd = rAst.Q4_TargetSteps + rAst.Q4_TargetDegSteps;
    }
    switch (t)
    {
        case 1:
            rAst.TargetX = rAst.Q1_TargetX;
            rAst.TargetY = rAst.Q1_TargetY ;
            rAst.TargetDeg = rAst.Q1_TargetDeg;
            rAst.TargetDegSz = rAst.Q1_TargetDegSz;
            rAst.TargetDistance = rAst.Q1_TargetDistance;
            rAst.TargetSteps = rAst.Q1_TargetSteps;
            rAst.TargetDegSteps = rAst.Q1_TargetDegSteps;
            rAst.Distance = rAst.Q1_Distance;
            break;
        case 2:
            rAst.TargetX = rAst.Q2_TargetX;
            rAst.TargetY = rAst.Q2_TargetY ;
            rAst.TargetDeg = rAst.Q2_TargetDeg;
            rAst.TargetDegSz = rAst.Q2_TargetDegSz;
            rAst.TargetDistance = rAst.Q2_TargetDistance;
            rAst.TargetSteps = rAst.Q2_TargetSteps;
            rAst.TargetDegSteps = rAst.Q2_TargetDegSteps;
            rAst.Distance = rAst.Q2_Distance;
            break;
        case 3:
            rAst.TargetX = rAst.Q3_TargetX;
            rAst.TargetY = rAst.Q3_TargetY ;
            rAst.TargetDeg = rAst.Q3_TargetDeg;
            rAst.TargetDegSz = rAst.Q3_TargetDegSz;
            rAst.TargetDistance = rAst.Q3_TargetDistance;
            rAst.TargetSteps = rAst.Q3_TargetSteps;
            rAst.TargetDegSteps = rAst.Q3_TargetDegSteps;
            rAst.Distance = rAst.Q3_Distance;
            break;
        case 4:
            rAst.TargetX = rAst.Q4_TargetX;
            rAst.TargetY = rAst.Q4_TargetY ;
            rAst.TargetDeg = rAst.Q4_TargetDeg;
            rAst.TargetDegSz = rAst.Q4_TargetDegSz;
            rAst.TargetDistance = rAst.Q4_TargetDistance;
            rAst.TargetSteps = rAst.Q4_TargetSteps;
            rAst.TargetDegSteps = rAst.Q4_TargetDegSteps;
            rAst.Distance = rAst.Q4_Distance;
            break;
    }
}



void SetTarget(float ShipX, float ShipY, float TargetX, float TargetY, float TargetVX, float TargetVY, float ShotStep, float Size)
{
    double A, B, C, a1, a2, b, c, s, Alpha, Beta, Gamma, t, vx1, vy1, vx2, vy2, n1, n2, td;

//  Dreiecksberechnung fr die Berechnung des Schusswinkels:
//
//  Bekannt sind:
//      - Der Bewegungsvektor (SV) des Ziels (C)
//      - Schiffsposition (B)
//      - die Lnge des Schussvektors (ShotStep)
//      - die Strecke BC ist bekannt
//      - durch den Bewegunsvektor SV ist der Winkel Gamma bekannt
//
//      Zuerst wird mithilfe der Seiten AC (Bewegungsvektor),
//      AB (Schussvektor) und Winkel Gamma die Strecke BC2 errechnet.
//
//      Ausgabe:
//      - (TgtAX, TgtAY) ist der Vorhalte-Schussvektor
//      - TgtRot ist der Vorhalte-Winkel

// Winkel Gamma berechnen
//
// -> Gamma berechnen (Winkel zwischen 2 Vektoren)
//      Skalarprodukt von vektor a und vektor b durch die miteinander multiplizierten Lngen
//      der beiden Vektoren ergibt den Cosinus des Winkels

    vx1 = TargetVX;
    vy1 = TargetVY;
    if (vx1 || vy1 != 0)
    {
        vx2 = normx(ShipX - TargetX);
        vy2 = normy(ShipY - TargetY);
        b = sqrt(vx1 * vx1 + vy1 * vy1);
        TgtDist = b;
        a1 = sqrt(vx2 * vx2 + vy2 * vy2);
        td = (vx1*vx2 + vy1*vy2) / (b * a1);
        if (td>1) td = 1;
        else if (td<-1) td =-1;
        Gamma = acos(td);

    //  Seitenlngen fr "1 Zeiteinheit" berechnen
    //  a2 = ?
    //  b = Lnge des Bewegungsvektor
    //  c = Lnge des Schussvektors
        c = ShotStep;
        Beta = asin(b*sin(Gamma)/c);
        Alpha = PI - Beta - Gamma;
        a2 = sqrt(b*b + c*c - 2*b*c*cos(Alpha));
        if (a2 != 0) s = a1 / a2;
        TgtCX = TargetX;
        TgtCY = TargetY;
        TgtBX = ShipX;
        TgtBY = ShipY;
        TgtAX = TgtCX + s * TargetVX;
        TgtAY = TgtCY + s * TargetVY;
        TgtSteps = int(s);
    }
    else
    {
        TgtCX = TargetX;
        TgtCY = TargetY;
        TgtBX = ShipX;
        TgtBY = ShipY;
        TgtAX = TgtCX;
        TgtAY = TgtCY;
        TgtSteps = 1;
    }
    //  Winkel zum Vorhaltepunkt berechnen
    vx1 = normx(ShipX - TgtAX);
    vy1 = normy(ShipY - TgtAY);
    Alpha = atan2(vx1, vy1)+PI;
    TgtDeg = int (fmod(Alpha * 180 / PI, 360));
    TgtDistance = sqrt(vx1*vx1 + vy1*vy1);
//  ungefhren Streuwinkel bestimmen
    vx2 = sin(Alpha+PI/2) * Size;
    vy2 = cos(Alpha+PI/2) * Size;
    vx1 += vx2;
    vy1 += vy2;
    Beta = atan2(vx1, vy1)+PI;
    TgtDeg2 = int (fmod(Beta * 180 / PI, 360));
    TgtDegSz = TgtDeg - TgtDeg2;
    while (TgtDegSz < -180) TgtDegSz += 360;
    while (TgtDegSz > 180) TgtDegSz -= 360;
    TgtDegSz = abs(TgtDegSz);
    TgtAX2 = TgtAX + vx2;
    TgtAY2 = TgtAY + vy2;
}


void GetIntersectionPoints(int x1, int y1, int x2, int y2)
/*  Berechnet die Schnittpunkte der bergebenen Geraden mit den
    Linien (-512,0)-(512,0) und (0,-512)-(0,512)

    Horizontal:
    x3 = -512, y3 = 0, x4 = 512, y4 = 0

            1024 * y1
    ua =    --------------------------------------
            -1024 * (y2 - y1)

    wenn ua<0, entfernt sich der Asteroid vom Schiff

    Vertikal:
    x3 = 0, y3 = -384, x4 = 0, y4 = 384

            -768 * x1
    ua =    --------------------------------------
            768 * (x2 - x1)

    wenn ua<0, entfernt sich der Asteroid vom Schiff

*/
{
    float ua, udiv;

    IntersectX = IntersectY = 0;
    IntersectH = IntersectV = false;
    udiv = -1024 * (y2-y1);
    if (udiv != 0)
    {
        ua = 1024 * y1 / udiv;
        if (ua>=0)
        {
            IntersectX = x1 + ua * (x2-x1);
            IntersectH = true;
        }
    }

    udiv = 768 * (x2-x1);
    if (udiv != 0)
    {
        ua = -768 * x1 / udiv;
        if (ua>=0)
        {
            IntersectY = y1 + ua * (y2-y1);
            IntersectV = true;
        }
    }
}

void ClrShotTrackers()
{
    for (int i=0;i<max_ShotTrackers;i++)
        ShotTrackerTable[i].id = 0;
}

void TweakTargetting(GameStatus& rgame)
{
    int nAsteroids = nSmallAsteroids + nMedAsteroids + nBigAsteroids;
    Coll_MaxSmallUnderfire = 1;
    Coll_MaxMedUnderfire = 2;
    Coll_MaxBigUnderfire = 2;
    Coll_MaxSmallSteps = 40;
    Coll_MaxSteps = 40;
    Best_MaxSmallUnderfire = 1;
    Best_MaxMedUnderfire = 3;
    Best_MaxBigUnderfire = 3;
    Best_MaxSmallSteps = 72;
    Best_MaxMedMultBulletsSteps = 45;
    Best_MaxBigMultBulletsSteps = 45;
    Scnd_MaxSmallUnderfire = 1;
    Scnd_MaxMedUnderfire = 3;
    Scnd_MaxBigUnderfire = 3;
    Scnd_MaxMedMultBulletsSteps = 45;
    Scnd_MaxBigMultBulletsSteps = 45;
    Scnd_MaxSteps = 70;
    MaxMedObjcount = 24;
    MaxBigObjcount = 23;
    MaxSmallTTL = 70;
    MaxMedTTL = 70;
    MaxBigTTL = 70;
    MaxUfoTTL = 60;
    MaxUfoUnderfire = 2;
    TweakFlags = 0;

    if ( !rgame.saucer_present ) UfoTgtY = 0;

    if ( nAsteroids > 18 )
    {
        Best_MaxMedUnderfire = 2;
        Best_MaxBigUnderfire = 2;
        Scnd_MaxMedUnderfire = 2;
        Scnd_MaxBigUnderfire = 2;
    }

    if (Level > 8)
    {
        if ( NearestObj > 330 )
        {
            Best_MaxMedUnderfire = 3;
            Best_MaxBigUnderfire = 3;
            Scnd_MaxMedUnderfire = 3;
            Scnd_MaxBigUnderfire = 3;
        }
        if ( NearestObj < 100 )
        {
            Best_MaxMedUnderfire = 2;
            Best_MaxBigUnderfire = 1;
            Scnd_MaxMedUnderfire = 2;
            Scnd_MaxBigUnderfire = 1;
        }
    }


/*
    if (Level < 8) WaitForUfo = false;
    if (Level > 7 && nSmallAsteroids+nMedAsteroids*2+nBigAsteroids*4 > 12) WaitForUfo = true;
    if (Level > 10 && nSmallAsteroids+nMedAsteroids*2+nBigAsteroids*4 > 9) WaitForUfo = true;
    if (Level > 12 && nSmallAsteroids+nMedAsteroids*2+nBigAsteroids*4 > 6) WaitForUfo = true;
*/
    if ( nBigAsteroids == 0 )
    {
        if ( nMedAsteroids == 0 )
        {
            if ( nSmallAsteroids < 8 )
            {
                Best_MaxSmallSteps = 99;
                MaxSmallTTL = 60;
                TweakFlags |= 1;
                if ((LastTweakFlags & 1)!=1) ClrShotTrackers;
            }
            if ( nSmallAsteroids < 2 )
            {
                MaxSmallTTL = 6;
                TweakFlags |= 2;
                if ((LastTweakFlags & 2)!=2) ClrShotTrackers;
            }
        }
    }

    LastTweakFlags = TweakFlags;
}

void DoSomething(GameStatus& rgame)
{
    keys.clear();   // alle Tasten loslassen
	int min_dist = 0x7fffffff;
	int min_dx = 0;
	int min_dy = 0;
    int min_i = -1;
    int min_i2 = -1;
    int i, t, dd, t2, sx, sy, MaxUF, nUnderfire;
    bool fire, Collision;
    Asteroid* pAst;


    keys.hyperspace(false);
    fire = false;
    nUnderfire = 0;

    Size2MaxTTL[0] = MaxBigTTL;
    Size2MaxTTL[15] = MaxMedTTL;
    Size2MaxTTL[14] = MaxSmallTTL;

    if (rgame.ship_present)
    {
        // Hyperspace bei Bedarf
        for (int i=0; i<rgame.nasteroids;i++)
        {
            pAst = &rgame.asteroids[i];
            if (pAst->underfire > 0) nUnderfire++;
            int dx = normx((pAst->x + pAst->vx*(3-FramesBehind)) - (rgame.ship_x + rgame.ship_vx));
            int dy = normy((pAst->y + pAst->vy*(3-FramesBehind)) - (rgame.ship_y + rgame.ship_vy));
            int dist = sqrt(dx*dx + dy*dy);
            dist -= AstScaleDiv2[pAst->sf];
            if (dist <= ShipRad)  // Flucht, wenn Kollision unausweichlich
            {
                keys.hyperspace(true);
                break;
            }
        }
        for (int i=0; i<rgame.nshots;i++)
        {
            if ( !rgame.shots[i].fromplayer )
            {
                int dx = normx((rgame.shots[i].x + rgame.shots[i].vx*4) - (rgame.ship_x + rgame.ship_vx));
                int dy = normy((rgame.shots[i].y + rgame.shots[i].vy*4) - (rgame.ship_y + rgame.ship_vy));
                int dist = sqrt(dx*dx + dy*dy);
                if (dist <= ShipRad)  // Flucht, wenn Kollision unausweichlich
                {
                    keys.hyperspace(true);
                    break;
                }
            }
        }

        if (CurrentShipJob != Thrust)
        {
            min_dist = 9999;
            Collision = false;
        // Zuerst Asteroiden auf Kollisionskurs abschieen
            for (int i=0; i<rgame.nasteroids; ++i)
            {

                pAst = &rgame.asteroids[i];
                if ( pAst->Collision )
                {
                    if ( pAst->sf == 14 && pAst->TargetSteps >= Coll_MaxSmallSteps ) continue;
                    if ( pAst->TargetSteps >= Coll_MaxSteps ) continue;

                    switch (pAst->sf)
                    {
                        case 0:
                            if ( pAst->underfire >= Coll_MaxBigUnderfire ) continue;
                            break;
                        case 15:
                            if ( pAst->underfire >= Coll_MaxMedUnderfire ) continue;
                            break;
                        case 14:
                            if ( pAst->underfire >= Coll_MaxSmallUnderfire ) continue;
                            break;
                    }
                    if ( pAst->tracked == LastTargetID )
                    {
                        min_i2 = min_i;
                        min_i = i;
                        break;
                    }
                    dd = pAst->TargetSteps;
                    if ( dd < min_dist )
                    {
                        min_dist = dd;
                        min_i2 = min_i;
                        min_i = i;
                        Collision = true;
                    }
                }
            }
            if ( min_i > -1 )
                LastTargetID = rgame.asteroids[min_i].trackid;
            else
                LastTargetID = 0;

            if (!Collision )
            {
        // Ansonsten am besten erreichbares Ziel suchen
//                if (!(rgame.nasteroids == 1 && WaitForUfo))
                {
                    for (int i=0; i<rgame.nasteroids; i++)
                    {
                        pAst = &rgame.asteroids[i];
                        switch (pAst->sf)
                        {
                            case 0:
                                MaxUF = Best_MaxBigUnderfire;
                                if ( (pAst->vx == 0) && (pAst->vy == 0) && (pAst->Distance > 150)) continue;
                                if ( pAst->TargetSteps > Best_MaxBigMultBulletsSteps ) MaxUF--;
                                if ( min_i > -1 )
                                {
                                    if ( rgame.nasteroids > MaxBigObjcount ) continue;
                                }
                                break;
                            case 15:
                                MaxUF = Best_MaxMedUnderfire;
                                if ( pAst->TargetSteps > Best_MaxMedMultBulletsSteps ) MaxUF--;
                                if ( min_i > -1 )
                                {
                                    if ( rgame.nasteroids > MaxMedObjcount ) continue;
                                }
                                break;
                            case 14:
                                MaxUF = Best_MaxSmallUnderfire;
                                break;
                        }
                        if ( pAst->underfire >= MaxUF ) continue;

                        dd = pAst->TargetSteps + pAst->TargetDegSteps; + abs(int(pAst->Deg) / 6);
 //                       if (!pAst->Intersect) dd += pAst->Deg / 5;

                        if ( dd < min_dist )
                        {
                            min_dist = dd;
                            min_i2 = min_i;
                            min_i = i;
                            if (pAst->underfire+1 < MaxUF) min_i2 = i;
                        }
                    }
                }

                if ( rgame.saucer_present && rgame.saucer_underfire < MaxUfoUnderfire )
                {
                    if (rgame.saucer_size == 14) t2 = SmallSaucerSizeD2;
                    else t2 = BigSaucerSizeD2;
                    SetTarget(rgame.ship_x, rgame.ship_y, rgame.saucer_x - rgame.saucer_vx * TargettingCorrection, rgame.saucer_y - rgame.saucer_vy * TargettingCorrection, rgame.saucer_vx, rgame.saucer_vy, ShotSpeed, t2);
                    t = ShipRotation;
                    dd = SVTable[t].angle_deg2 - TgtDeg;
                    while (dd < -180) dd += 360;
                    while (dd > 180) dd -= 360;
                    dd = abs(dd) / 4.21875;
                    dd -= TgtDegSz;
                    if ( dd < 0 ) dd = 0;
                    dd += TgtDist / 25;
                    dd = 1;
                    if ( dd < min_dist )
                    {
                        min_dist = dd;
                        min_i2 = min_i;
                        min_i = UfoID;
                        if (rgame.saucer_underfire+1 < MaxUfoUnderfire) min_i2 = UfoID;
                    }
                }
            }

            if ( min_i == UfoID )
            {
                Debug_TargetX = rgame.saucer_x;
                Debug_TargetY = rgame.saucer_y;
                TgtCnt = 5;
                fire = true;
            }
            else if ( min_i >-1 )
            {
                pAst = &rgame.asteroids[min_i];
                {
                    if (pAst->TargetDeg < 360)
                    {
                        Debug_TargetX = pAst->x;
                        Debug_TargetY = pAst->y;
                        TgtCnt = 5;
                        TgtDeg = pAst->TargetDeg;
                        TgtDegSz = pAst->TargetDegSz;
                        TgtDistance = pAst->TargetDistance;
                        TgtSteps = pAst->TargetSteps;
                        fire = true;
                    }
                }
            }

            if ( ShotDelay == 0 && fire )
            {
                dd = int(SVTable[ShipRotation].angle_deg2 - TgtDeg);
                while (dd < -180) dd += 360;
                while (dd > 180) dd -= 360;
                if ( abs(dd)<= TgtDegSz )
                {
                    if ( min_i == UfoID || !WaitForUfo || (WaitForUfo && (nUnderfire+1 < nSmallAsteroids+nMedAsteroids+nBigAsteroids)))
                    if (ActivePlayerShots < 4)
                    {
                        keys.fire(true);
                        ActivePlayerShots++;
                        t = ShipRotation;   // - rgame.turned & 0xff;
                        float Angle = SVTable[t].angle;
                        float dx = sin(Angle) * ShotSpeed;
                        float dy = cos(Angle) * ShotSpeed;
                        NextShotTracker.x = rgame.ship_x + dx * 20 / 8;
                        NextShotTracker.y = rgame.ship_y + dy * 20 / 8;
                        NextShotTracker.dx = dx;
                        NextShotTracker.dy = dy;
                        NextShotTracker.vx = rgame.ship_vx;
                        NextShotTracker.vy = rgame.ship_vy;
                        NextShotTracker.id = rand() +1;
                        NextShotTracker.rot = t;
                        NextShotTracker.px = rgame.ship_x;
                        NextShotTracker.py = rgame.ship_y;
                        NextShotTracker.TTL = TgtSteps;
                        if ( min_i == UfoID )
                        {
                            rgame.saucer_underfire++;
                            NextShotTracker.target = UfoID;
                            if ( TgtSteps > MaxUfoTTL )
                                NextShotTracker.TTL = MaxUfoTTL;
                            switch (UfoTgtY)
                            {
                                case 0:
                                    UfoTgtY = 2;
                                    break;
                                case 2:
                                    UfoTgtY = -2;
                                    break;
                                case -2:
                                    UfoTgtY = 0;
                                    break;
                            }
                        }
                        else
                        {
                            pAst = &rgame.asteroids[min_i];
                            pAst->underfire++;
                            nUnderfire++;
                            NextShotTracker.target = pAst->trackid;
                            if ( TgtSteps > Size2MaxTTL[pAst->sf] )
                                NextShotTracker.TTL = Size2MaxTTL[pAst->sf];
                        }
                        ShotDelay = 2;

// zum nchsten Ziel drehen
                        if ( (min_i2 >-1) && (min_i2 != UfoID) )
                        {
                            if (rgame.asteroids[min_i2].TargetDeg < 360)
                            {
                                if (CurrentShipJob == None)
                                {
                                    TgtDeg = rgame.asteroids[min_i2].TargetDeg;
                                    dd = int(SVTable[ShipRotation].angle_deg2 - TgtDeg);
                                    while (dd < -180) dd += 360;
                                    while (dd > 180) dd -= 360;
                                    if ( dd > 0 )
                                    {
                                        CurrentShipJob = TurnLeft;
                                        rgame.turned = -1;
                                    }
                                    else if ( dd < 0 )
                                    {
                                        CurrentShipJob = TurnRight;
                                        rgame.turned = 1;
                                    }
                                }
                            }
                        }
                    }
                }

//  else
                {
                    if ( dd > 0 )
                    {
                        if (CurrentShipJob == None)
                        {
                            CurrentShipJob = TurnLeft;
                            rgame.turned = -1;
                        }
                    }
                    else if ( dd < 0 )
                    {
                        if (CurrentShipJob == None)
                        {
                            CurrentShipJob = TurnRight;
                            rgame.turned = 1;
                        }
                    }


                    if (ActivePlayerShots < 4 && ShotDelay == 0)
                    {
                 // whrend der Drehung auf in der Schusslinie vorhandene Ziele feuern

                        if ( rgame.saucer_present && rgame.saucer_underfire < MaxUfoUnderfire )
                        {
                            if (rgame.saucer_size == 14) t2 = SmallSaucerSizeD2;
                            else t2 = BigSaucerSizeD2;
                            SetTarget(rgame.ship_x, rgame.ship_y, rgame.saucer_x - rgame.saucer_vx * TargettingCorrection, rgame.saucer_y - rgame.saucer_vy * TargettingCorrection, rgame.saucer_vx, rgame.saucer_vy, ShotSpeed, t2);
                            dd = int(SVTable[ShipRotation].angle_deg2 - TgtDeg);
                            while (dd < -180) dd += 360;
                            while (dd > 180) dd -= 360;
                            if ( abs(dd)<= TgtDegSz )
                            {
                                keys.fire(true);
                                rgame.saucer_underfire++;
                                ActivePlayerShots++;
                                t = ShipRotation;
                                float Angle = SVTable[t].angle;
                                float dx = sin(Angle) * ShotSpeed;
                                float dy = cos(Angle) * ShotSpeed;
                                NextShotTracker.x = rgame.ship_x + dx * 20 / 8;
                                NextShotTracker.y = rgame.ship_y + dy * 20 / 8;
                                NextShotTracker.dx = dx;
                                NextShotTracker.dy = dy;
                                NextShotTracker.vx = rgame.ship_vx;
                                NextShotTracker.vy = rgame.ship_vy;
                                NextShotTracker.id = rand() %10000 +1;
                                NextShotTracker.rot = t;
                                NextShotTracker.px = rgame.ship_x;
                                NextShotTracker.py = rgame.ship_y;
                                NextShotTracker.target = UfoID;
                                NextShotTracker.TTL = TgtSteps;
                                if ( TgtSteps > MaxUfoTTL )
                                    NextShotTracker.TTL = MaxUfoTTL;
                                ShotDelay = 2;
                                switch (UfoTgtY)
                                {
                                    case 0:
                                        UfoTgtY = 2;
                                        break;
                                    case 2:
                                        UfoTgtY = -2;
                                        break;
                                    case -2:
                                        UfoTgtY = 0;
                                        break;
                                }
                            }
                        }
                        if (ShotDelay == 0 && ActivePlayerShots < 4 )
                        {
//                            if (!(rgame.nasteroids == 1 && WaitForUfo))
                            if ( !WaitForUfo || (WaitForUfo && (nUnderfire+1 < nSmallAsteroids+nMedAsteroids+nBigAsteroids)))
                            {
                                for (i=0;i<rgame.nasteroids;i++)
                                {
                                    pAst = &rgame.asteroids[i];
                                    if ((pAst->TargetDeg < 360) && (pAst->TargetSteps < Scnd_MaxSteps ))
                                    {
                                        switch (pAst->sf)
                                        {
                                            case 0:
                                                if ( (pAst->vx == 0) && (pAst->vy == 0) && (pAst->Distance > 150) ) continue;
                                                MaxUF = Scnd_MaxBigUnderfire;
                                                if ( pAst->TargetSteps > Scnd_MaxBigMultBulletsSteps ) MaxUF--;
                                                if ( rgame.nasteroids > MaxBigObjcount ) continue;
                                                break;
                                            case 15:
                                                MaxUF = Scnd_MaxMedUnderfire;
                                                if ( pAst->TargetSteps > Scnd_MaxMedMultBulletsSteps ) MaxUF--;
                                                if ( rgame.nasteroids > MaxMedObjcount ) continue;
                                                break;
                                            case 14:
                                                MaxUF = Scnd_MaxSmallUnderfire;
                                                break;
                                        }
                                        if ( pAst->underfire >= MaxUF ) continue;
                                        dd = int(SVTable[ShipRotation].angle_deg2 - pAst->TargetDeg);
                                        while (dd < -180) dd += 360;
                                        while (dd > 180) dd -= 360;
                                        if ( abs(dd)<= pAst->TargetDegSz )
                                        {
                                            keys.fire(true);
                                            pAst->underfire++;
                                            ActivePlayerShots++;
                                            t = ShipRotation;
                                            float Angle = SVTable[t].angle;
                                            float dx = sin(Angle) * ShotSpeed;
                                            float dy = cos(Angle) * ShotSpeed;
                                            NextShotTracker.x = rgame.ship_x + dx * 20 / 8;
                                            NextShotTracker.y = rgame.ship_y + dy * 20 / 8;
                                            NextShotTracker.dx = dx;
                                            NextShotTracker.dy = dy;
                                            NextShotTracker.vx = rgame.ship_vx;
                                            NextShotTracker.vy = rgame.ship_vy;
                                            NextShotTracker.id = rand() %10000 +1;
                                            NextShotTracker.rot = t;
                                            NextShotTracker.px = rgame.ship_x;
                                            NextShotTracker.py = rgame.ship_y;
                                            NextShotTracker.target = pAst->trackid;
                                            NextShotTracker.TTL = pAst->TargetSteps;
                                            if ( NextShotTracker.TTL > Size2MaxTTL[pAst->sf] )
                                                NextShotTracker.TTL = Size2MaxTTL[pAst->sf];
                                            ShotDelay = 2;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

// Am Ende des Levels mglichst zum Bildrand gucken
        if ( rgame.nasteroids == 0 && !rgame.saucer_present && DontThrustCnt == 0 )
        {

            if (rgame.ship_x < 512) sx = 150;
            else sx = 1023-150;
            if (rgame.ship_y < 384) sy = 225;
            else sy = 767 - 225;
            int dx = normx(rgame.ship_x - sx);
            int dy = normy(rgame.ship_y - sy);
            int di = sqrt(dx*dx + dy*dy);
            if ( di == 0 ) dd = 1;
            if ( di > 50)
            {
                float Alpha = atan2(dx,dy)+PI;
                t = int (fmod(Alpha * 180 / PI,360));
                dd = int(SVTable[ShipRotation].angle_deg2 - t);
                while (dd < -180) dd += 360;
                while (dd > 180) dd -= 360;
                if ( abs(dd)<= 2 )
                {
                    CurrentShipJob = Thrust;
                    ShipJobCnt = di/14 & 0xfffe;
                    DontThrustCnt = 500;
                }
                else
                {
                    if ( dd>0 )
                    {
                        if (CurrentShipJob == None)
                        {
                            CurrentShipJob = TurnLeft;
                            rgame.turned = -1;
                        }
                    }
                    else if ( dd<0 )
                    {
                        if (CurrentShipJob == None)
                        {
                            CurrentShipJob = TurnRight;
                            rgame.turned = 1;
                        }
                    }
                }
            }
        }
        if ( rgame.nasteroids == 0 && !rgame.saucer_present )
        {
            if (CurrentShipJob == None)
            {
                float vx1 = 512 - rgame.ship_x;
                float vy1 = 384 - rgame.ship_y;
                float Alpha = atan2(vx1, vy1)+PI;
                TgtDeg = int (fmod(Alpha * 180 / PI, 360));
                dd = int(SVTable[ShipRotation].angle_deg2 - TgtDeg);
                while (dd < -180) dd += 360;
                while (dd > 180) dd -= 360;
                if ( dd > 0 )
                {
                    CurrentShipJob = TurnLeft;
                    rgame.turned = -1;
                }
                else if ( dd < 0 )
                {
                    CurrentShipJob = TurnRight;
                    rgame.turned = 1;
                }
            }
        }
    }
}


void Player::Run(void)
{
//	FramePacket frame;
//	KeysPacket keys;
//	GameStatus game[max_GameObjects];
//   DebugWindow debugWindow;

	char prevframe = 0;
	int Tick = 0;
    int LastTick = 0;
    int LastOnScreen = 0;
	int ThrustDelay = 0;
    int ThrustHoldKey = 0;
    int i = 0;
    int LostFrames = 0;
    float dx, dy;

    feraiseexcept((FE_ALL_EXCEPT & ~FE_INEXACT));
    feclearexcept(FE_ALL_EXCEPT);
    ChkFPU(0);
    FramePacket LastFrame;

    ActivePlayerShots = 0;

    if (!ReadShipVectors())
    {
        printf("Kann 'ShipRotation.txt' nicht fehlerfrei einlesen!\n");
        return;
    }

    ChkFPU(1);


    cGO = 0;
    ShotDelay = 0;
    CalibrateCnt = 0;
    CurrentShipJob = Calibrate;

    ShotTrackerPtr = 0;
    for (int i=0;i<max_ShotTrackers;i++)
        ShotTrackerTable[i].id = 0;

    AstTrackerPtr = 0;
    for (int i=0;i<max_AstTrackers;i++)
        AstTrackerTable[i].id = 0;

    if (ShowDebugWindow) {
        if (! (debugWindow.Create()) )
            return;
    }

    GameTime = Score = Level = 0;
    ShipRotation = 0;
    int TargetRotation = 0;
    bool GameStarted = false;
    DontThrustCnt = 0;
    LastTweakFlags = 0;
    FramesSinceLastUfo = 0;
    FramesSinceLevelStart = 0;
	for (;;)
	{
		++Tick;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);
		ReceivePacket(frame);
        if ( GameStarted ) GameTime += abs(char(frame.frameno - prevframe));
		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			LostFrames = frame.frameno - prevframe;
			prevframe = frame.frameno;
		}

        if ( ShotDelay > 0 ) ShotDelay--;
        if ( DontThrustCnt > 0 ) DontThrustCnt--;
        if ( CalibrateCnt > 0 ) CalibrateCnt--;
        FramesSinceLastUfo++;
        FramesSinceLevelStart++;
        GameStatus &rgame = game[cGO];
		InterpretScreen(frame, rgame);

    // GamePointer auf die letzten Game-Objekte
        lgame1 = &game[cGO-1 & max_GameObjects-1];
        lgame2 = &game[cGO-2 & max_GameObjects-1];
    // momentane Geschwindigkeit des Spielerschiffs
        if (lgame1->ship_present && rgame.ship_present)
        {
            rgame.ship_vx = normx(rgame.ship_x - lgame1->ship_x);
            rgame.ship_vy = normy(rgame.ship_y - lgame1->ship_y);
        }
        else
        {
            rgame.ship_vx = 0;
            rgame.ship_vy = 0;
        }
    // momentane Geschwindigkeit des Ufos
        if ( rgame.saucer_present )
        {
            WaitForUfo = false;
            if ( lgame1->saucer_present )
            {
                rgame.saucer_vx = normx(rgame.saucer_x2 - lgame1->saucer_x2);
                rgame.saucer_vy = normy(rgame.saucer_y2 - lgame1->saucer_y2);
            }
            else
            {
                FramesSinceLastUfo = 0;
                if (rgame.saucer_x < 512)
                {
                    rgame.saucer_vx = 2;
                    rgame.saucer_vy = 0;
                }
                else
                {
                    rgame.saucer_vx = -2;
                    rgame.saucer_vy = 0;
                }
            }
        }

// Momentane Position schtzen ;-)
        for (i=0;i<rgame.nasteroids;i++)
        {
            rgame.asteroids[i].x = rgame.asteroids[i].x2 + rgame.asteroids[i].vx*FramesBehind;
            rgame.asteroids[i].y = rgame.asteroids[i].y2 + rgame.asteroids[i].vy*FramesBehind;
        }
        if (rgame.saucer_present)
        {
            rgame.saucer_x = rgame.saucer_x2 + rgame.saucer_vx*FramesBehind;
            rgame.saucer_y = rgame.saucer_y2 + rgame.saucer_vy*FramesBehind;
        }

        ClrFPU();
        TrackAstMotion(rgame);
        ChkFPU(100);
        TrackShotMotion(rgame);
        ChkFPU(200);

        if (GameTime > 0 && lgame1->nasteroids == 0 && rgame.nasteroids > 0)
        {
            Level++;
            FramesSinceLevelStart = 0;
            WaitForUfo = true;
            if (Level < 8) WaitForUfo = false;
        }

        keys.clear();   // alle Tasten loslassen
        if (rgame.ship_present)
        {
        // Wenn das Schiff lnger nicht sichtbar war, erstmal den Drehwinkel ermitteln
            if (Tick-LastOnScreen > 10)
            {
                CurrentShipJob = Calibrate;
            }
            LastOnScreen = Tick;
            GameStarted = true;

            TweakTargetting(rgame);

            DoSomething(rgame);
            ChkFPU(300);
            switch(CurrentShipJob)
            {
                case Thrust:
                    if (ShipJobCnt > 0) ShipJobCnt--;
                    keys.thrust(true);
                    if (ShipJobCnt == 0)
                        CurrentShipJob = None;
                    break;
                // ein paar mal rechts drehen und dabei die Schiffsvektoren dx und dy aufzeichnen, um diese
                // anschlieend mit den Werten in der Schiffsrotationsvektorentabelle vergleichen zu knnen
                // und so den aktuellen Rotationswinkel bestimmen zu knnen
                case Calibrate:
                    CurrentShipJob = Calibrate2;
                    ShipJobCnt = 0;
                    keys.right(true);
                    rgame.turned = 1;
                    printf("Kalibriere..\n");
                    break;
                case Calibrate2:
                    if (Tick == LastTick+1)
                    {
                        CalTab[ShipJobCnt].vx = rgame.ship_dx;
                        CalTab[ShipJobCnt].vy = rgame.ship_dy;
                        ShipJobCnt++;
                        if (ShipJobCnt == CalSteps)
                        {
                            for (int i=0;i<256;i++)
                            {
                                if (CalTab[0].vx == SVTable[i].dx & CalTab[0].vy == SVTable[i].dy)
                                if (CalTab[1].vx == SVTable[(i+1)&0xff].dx & CalTab[1].vy == SVTable[(i+1)&0xff].dy)
                                if (CalTab[2].vx == SVTable[(i+2)&0xff].dx & CalTab[2].vy == SVTable[(i+2)&0xff].dy)
                                if (CalTab[3].vx == SVTable[(i+3)&0xff].dx & CalTab[3].vy == SVTable[(i+3)&0xff].dy)
                                if (CalTab[4].vx == SVTable[(i+4)&0xff].dx & CalTab[4].vy == SVTable[(i+4)&0xff].dy)
                                if (CalTab[5].vx == SVTable[(i+5)&0xff].dx & CalTab[5].vy == SVTable[(i+5)&0xff].dy)
//                                if (CalTab[6].vx == SVTable[(i+6)&0xff].dx & CalTab[6].vy == SVTable[(i+6)&0xff].dy)
                                {
                                    ShipRotation = (i+CalSteps+0xff)&0xff;
                                    CurrentShipJob = None;
                                    ReCalibrate = false;
                                    break;
                                }
                            }
                            if (CurrentShipJob != None)
                            {
                            // Momentanen Drehwinkel nicht gefunden, nochmal versuchen
                                printf("Re-Kalibriere :-/\n");
                                ShipJobCnt = 0;
                                CalTab[0].vx = rgame.ship_dx;
                                CalTab[0].vy = rgame.ship_dy;
                                keys.right(true);
                                rgame.turned = 1;
                            }
//                            CurrentShipJob = TestShot;
                        }
                        else
                        {
                            if (ShipJobCnt<CalSteps-1) {
                                keys.right(true);
                                ShipRotation = (ShipRotation+1)&0xff;
                                rgame.turned = 1;
                            }
                        }
                    }
                    else
                    {
                    // Frame verloren, nochmal versuchen
                        ShipJobCnt = 0;
                        CalTab[0].vx = rgame.ship_dx;
                        CalTab[0].vy = rgame.ship_dy;
                        keys.right(true);
                        rgame.turned = 1;
                    }
                    break;
                case TurnRight:
                    CurrentShipJob = None;
                    ShipRotation = (ShipRotation+1)&0xff;
                    keys.right(true);
                    rgame.turned = 1;
                    break;
                case TurnLeft:
                    CurrentShipJob = None;
                    ShipRotation = (ShipRotation+0xff)&0xff;
                    keys.left(true);
                    rgame.turned = -1;
                    break;

            }
        }


		if (ShowDebugWindow) {
            RedrawDebugWindow = true;             // Window erneuern
            if (!debugWindow.CheckMsgs())   // false = CloseWindow;
                break;                      // --> exit Loop

		}
		LastFrame = frame;
		cGO = cGO+1 & (max_GameObjects-1);
		LastTick = Tick;
        if (TgtCnt >0)
            TgtCnt--;

        for (i=0;i<max_AstTrackers;i++)
        {
            if (AstTrackerTable[i].id != 0)
            {
                float x = AstTrackerTable[i].x;
                float y = AstTrackerTable[i].y;
                y += AstTrackerTable[i].dy;
                x += AstTrackerTable[i].dx;
                if (x < 0) x = x + ScrWidth;
                if (x >= ScrWidth) x = x - ScrWidth;
                if (y < 0) y = y + ScrHeight;
                if (y >= ScrHeight) y = y - ScrHeight;
                AstTrackerTable[i].x = x;
                AstTrackerTable[i].y = y;
            }
        }

        for (i=0;i<max_ShotTrackers;i++)
        {
            if (ShotTrackerTable[i].id != 0)
            {
                float x = ShotTrackerTable[i].x;
                float y = ShotTrackerTable[i].y;
                y += ShotTrackerTable[i].dy + ShotTrackerTable[i].vx;
                x += ShotTrackerTable[i].dx + ShotTrackerTable[i].vy;
                if (x < 0) x = x + ScrWidth;
                if (x >= ScrWidth) x = x - ScrWidth;
                if (y < 0) y = y + ScrHeight;
                if (y >= ScrHeight) y = y - ScrHeight;
                ShotTrackerTable[i].x = x;
                ShotTrackerTable[i].y = y;
                ShotTrackerTable[i].cnt++;
            }
        }
/*
        float x = NextShotTracker.x;
        float y = NextShotTracker.y;
        y += NextShotTracker.dy + NextShotTracker.vx;
        x += NextShotTracker.dx + NextShotTracker.vy;
        if (x < 0) x = x + ScrWidth;
        if (x >= ScrWidth) x = x - ScrWidth;
        if (y < 0) y = y + ScrHeight;
        if (y >= ScrHeight) y = y - ScrHeight;
        NextShotTracker.x = x;
        NextShotTracker.y = y;
*/
	}

    if (ShowDebugWindow) {
        debugWindow.Close();
    }

/*
    ofstream myfile ("ShipRotation3_a.txt");
    if (myfile.is_open())
    {
        for (int i=0;i<256;i++)
        {
            myfile << SVTable[i].dx << ", ";
            myfile << SVTable[i].dy << ", ";
            myfile << SVTable[i].svx << ", ";
            myfile << SVTable[i].svy << ", ";
            myfile << SVTable[i].angle_deg2 << ", ";
            myfile << SVTable[i].nvx << ", ";
            myfile << SVTable[i].nvy << ", ";
            myfile << SVTable[i].angle_deg3 << "\n";
        }
        myfile.close();
    }

    ofstream myfile2 ("ShipRotation_3b.txt");
    if (myfile2.is_open())
    {
        for (int i=0;i<256;i++)
        {
            myfile2 << SVTable[i].dx << ", ";
            myfile2 << SVTable[i].dy << ", ";
            myfile2 << SVTable[i].nvx << ", ";
            myfile2 << SVTable[i].nvy << ", ";
            myfile2 << SVTable[i].angle_deg3 << "\n";
        }
        myfile2.close();
    }
*/
    ChkFPU(400);
}


void Player::TrackAstMotion(GameStatus &rgame)
{
    int id, r, l, ct, t, i;
    float x, y, dx, dy, vx1, vy1, vx2, vy2, vx3, vy3, Alpha, Beta, Gamma, a, a1, a2, b, c, s ;
    int tx, ty, td, td2, tds;
    Asteroid *pAst1, *pAst2, *ap;

    nBigAsteroids = nMedAsteroids = nSmallAsteroids = 0;
    NearestObj = 999;

    for (r=0; r<rgame.nasteroids; r++)
    {
        pAst1 = &rgame.asteroids[r];
        switch ( pAst1->sf )
        {
            case 0:
                nBigAsteroids++;
                break;
            case 14:
                nSmallAsteroids++;
                break;
            case 15:
                nMedAsteroids++;
                break;
        }
        x = pAst1->x;
        y = pAst1->y;
        ct = pAst1->ctype;
        for (l=0; l<lgame1->nasteroids; l++)
        {
            pAst2 = &lgame1->asteroids[l];
            if (!pAst2->tracked)
            {
                if (pAst2->ctype == ct)
                {
                    dx = normx(x - pAst2->x);
                    dy = normy(y - pAst2->y);
                    if ( dx*dx+dy*dy < 6*6 )
                    {
                        pAst2->tracked = true;
                        pAst1->trackid = pAst2->trackid;
                        pAst1->trackprev = pAst2;
                        pAst1->tracklinks = pAst2->tracklinks +1;

                        ap = pAst1->trackprev;
                        for (i=0;i<7;i++)
                        {
                            ap = ap->trackprev;
                            if (ap == NULL)
                                break;
                        }
                        if ( i > 0 )
                        {
                            i++;
                            if (ap != NULL) {
                                dx = normx(pAst1->x2 - ap->x2);
                                dy = normy(pAst1->y2 - ap->y2);
                                pAst1->vx = dx / i;
                                pAst1->vy = dy / i;
                            }
                            for (t=0;t<max_AstTrackers;t++)
                                if (AstTrackerTable[t].id == pAst1->trackid)
                                    break;
                            if (t == max_AstTrackers)   // id nicht gefunden
                            {
                                AstTrackerTable[AstTrackerPtr].x = pAst1->x;
                                AstTrackerTable[AstTrackerPtr].y = pAst1->y;
                                AstTrackerTable[AstTrackerPtr].dx = pAst1->vx;
                                AstTrackerTable[AstTrackerPtr].dy = pAst1->vy;
                                AstTrackerTable[AstTrackerPtr].id = pAst1->trackid;
                                AstTrackerPtr = (AstTrackerPtr +1) % max_AstTrackers;
                            }
                            if (rgame.ship_present)
                            {
                            // Vorhalteposition und Winkel bestimmen
                            // --> SetTarget(...)
                            SetShotAngle(rgame, *pAst1);
                            if ( pAst1->Distance < NearestObj ) NearestObj = pAst1->Distance;

                        // Kollisionsdaten ermitteln

                                dx = normx(pAst1->x - rgame.ship_x);
                                dy = normy(pAst1->y - rgame.ship_y);
                                vx1 = pAst1->vx - rgame.ship_vx;
                                vy1 = pAst1->vy - rgame.ship_vy;
                                GetIntersectionPoints(dx, dy, dx+(vx1*2048), dy+(vy1*2048));
                                if ( IntersectH && IntersectV )
                                {
                                    if ( abs(IntersectX) < abs(IntersectY) )
                                    {
                                        IntersectV = false;
                                        IntersectY = 0;
                                    }
                                    else
                                    {
                                        IntersectH = false;
                                        IntersectX = 0;
                                    }
                                }
                                pAst1->IntersectX = IntersectX + rgame.ship_x;
                                pAst1->IntersectY = IntersectY + rgame.ship_y;
                                if (IntersectH)
                                {
                                    pAst1->IntersectCnt = int(pAst1->Distance / pAst1->speed);
                                    pAst1->IntersectDist = abs(IntersectX) - AstScaleDiv2[pAst1->sf];
//                                    pAst1->Collision = pAst1->IntersectDist <= ShipRad*2;
                                    pAst1->Collision = pAst1->IntersectDist <= ShipRad*2;
                                    pAst1->Intersect = true;
                                }
                                if (IntersectV)
                                {
                                    pAst1->IntersectCnt = int(pAst1->Distance / pAst1->speed);
                                    pAst1->IntersectDist = abs(IntersectY) - AstScaleDiv2[pAst1->sf];
//                                    pAst1->Collision = pAst1->IntersectDist <=  ShipRad*2;
                                    pAst1->Collision = pAst1->IntersectDist <=  ShipRad*2;
                                    pAst1->Intersect = true;
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    // nicht verwendete ids aus der Trackerliste lschen
    for (t=0;t<max_AstTrackers;t++)
    {
        id = AstTrackerTable[t].id;
        for (r=0;r<rgame.nasteroids;r++)
            if (id == rgame.asteroids[r].trackid)
                break;
        if (r == rgame.nasteroids)
            AstTrackerTable[t].id = 0;
    }
}

void Player::TrackShotMotion(GameStatus &rgame)
{
    bool saucer_changed_dir;
    int r, l, ct, id, t;
    float x, y, dx, dy, vx, vy, sx, sy, n;

    if (rgame.saucer_present)
    {
        saucer_changed_dir = (rgame.saucer_vx != lgame1->saucer_vx) || (rgame.saucer_vy != lgame1->saucer_vy);
        if ( saucer_changed_dir ) UfoTgtY = 0;
    }

    // Vektor Schiff"spitze"
    if (lgame1->ship_present && rgame.ship_present)
    {
        n = sqrtf(lgame1->ship_dx*lgame1->ship_dx + lgame1->ship_dy*lgame1->ship_dy);
        vx = lgame1->ship_dx*20/n;
        vy = lgame1->ship_dy*20/n;
        n = sqrtf(rgame.ship_dx*rgame.ship_dx + rgame.ship_dy*rgame.ship_dy);
        sx = rgame.ship_dx*8/n;
        sy = rgame.ship_dy*8/n;
        ActivePlayerShots = 0;
        for (r=0; r<rgame.nshots; r++)
        {
            x = rgame.shots[r].x;
            y = rgame.shots[r].y;

    // testen ,ob vom Spielerschiff abgeschossen
            dx = normx(x - rgame.ship_x - vx);
            dy = normy(y - rgame.ship_y - vy);
            if ( dx*dx+dy*dy < 3*3*2 )
            {
    // vom Player, in Trackerliste eintragen
                rgame.shots[r].fromplayer = true;
                rgame.shots[r].vx = sx;
                rgame.shots[r].vy = sy;
                rgame.shots[r].id = NextShotTracker.id;
                rgame.shots[r].trackerindex = ShotTrackerPtr;
                ShotTrackerTable[ShotTrackerPtr].x = NextShotTracker.x;
                ShotTrackerTable[ShotTrackerPtr].y = NextShotTracker.y;
                ShotTrackerTable[ShotTrackerPtr].dx = NextShotTracker.dx;
                ShotTrackerTable[ShotTrackerPtr].dy = NextShotTracker.dy;
                ShotTrackerTable[ShotTrackerPtr].vx = NextShotTracker.vx;
                ShotTrackerTable[ShotTrackerPtr].vy = NextShotTracker.vy;
                ShotTrackerTable[ShotTrackerPtr].id = NextShotTracker.id;
                ShotTrackerTable[ShotTrackerPtr].px = NextShotTracker.px;
                ShotTrackerTable[ShotTrackerPtr].py = NextShotTracker.py;
                ShotTrackerTable[ShotTrackerPtr].rot = NextShotTracker.rot;
                ShotTrackerTable[ShotTrackerPtr].deg = -1;
                ShotTrackerTable[ShotTrackerPtr].target = NextShotTracker.target;
                ShotTrackerTable[ShotTrackerPtr].TTL = NextShotTracker.TTL;
                ShotTrackerTable[ShotTrackerPtr].cnt = 0;
                ShotTrackerPtr = (ShotTrackerPtr +1) % max_ShotTrackers;
                NextShotTracker.id = 0;
            }
            else
            {
                for (l=0; l<lgame1->nshots; l++)
                {
                    if (!lgame1->shots[l].tracked)
                    {
                        dx = normx(x - lgame1->shots[l].x);
                        dy = normy(y - lgame1->shots[l].y);
                        if ( dx*dx+dy*dy< 12*12*2 )
                        {
                            rgame.shots[r].vx = dx;
                            rgame.shots[r].vy = dy;
                            lgame1->shots[l].tracked = true;
                            if (lgame1->shots[l].fromplayer)
                            {
                                rgame.shots[r].fromplayer = true;
                                rgame.shots[r].id = lgame1->shots[l].id;
                                rgame.shots[r].trackerindex = lgame1->shots[l].trackerindex;
                                ActivePlayerShots++;
                            }
                            break;
                        }
                    }
                }
            }
        }

// testen, ob die Schusswinkel noch in Ordnung sind, ggfls. Schiff ausrichten
        if ( CalibrateCnt == 0)
        {
            for (r=0; r<rgame.nshots; r++)
            {
                if ( rgame.shots[r].fromplayer )
                {
                    l = rgame.shots[r].trackerindex;
                    if ( ShotTrackerTable[l].cnt == 5 ) {
                        dx = normx(ShotTrackerTable[l].px - rgame.shots[r].x);
                        dy = normy(ShotTrackerTable[l].py - rgame.shots[r].y);
                        float Alpha = atan2(dx, dy)+PI;
                        ShotTrackerTable[l].deg = int (fmod(Alpha * 180 / PI,360));
                        if ( abs(ShotTrackerTable[l].deg - SVTable[ShotTrackerTable[l].rot].angle_deg2) >4 )
                        {
                            CurrentShipJob = Calibrate;
                            CalibrateCnt = 100;
    //                        ShotTrackerPtr = 0;                 // Alle momentan beschossenen Ziele lschen
                            for (int i=0;i<max_ShotTrackers;i++)
                                ShotTrackerTable[i].id = 0;
                            break;
                        }
    /*
                        else
                        {
                            t = ShotTrackerTable[l].rot;
                            SVTable[t].nvx = dx;
                            SVTable[t].nvy = dy;
                            SVTable[t].angle_deg3 = ShotTrackerTable[l].deg;
                        }
    */
                    }
                }
            }
        }

        // nicht verwendete ids aus der Trackerliste lschen
        // anvisierte Ziele markieren

        for (l=0;l<max_ShotTrackers;l++)
        {
            id = ShotTrackerTable[l].id;
            for (r=0;r<rgame.nshots;r++)
                if (id == rgame.shots[r].id)
                    break;
            if (r == rgame.nshots)
                ShotTrackerTable[l].id = 0;
            else
            {
                if ( ShotTrackerTable[l].cnt >= ShotTrackerTable[l].TTL )
                {
                // Lebensdauer des Schusses abgelaufen --> Ziel verfehlt
                    ShotTrackerTable[l].target = 0;
                    ShotTrackerTable[l].id = 0;
                }
                else

                {
                    id = ShotTrackerTable[l].target;
                    if ( id == UfoID )
                        if ( saucer_changed_dir )
                        {
                            ShotTrackerTable[l].target = 0;
                            ShotTrackerTable[l].id = 0;
                        }
                        else
                        {
                            rgame.saucer_underfire++;
                        }
                    else
                    {
                        for (r=0;r<rgame.nasteroids;r++)
                        {
                            if ( rgame.asteroids[r].trackid == id )
                            {
                                rgame.asteroids[r].underfire++;
                                break;
                            }
                        }
                    }
                }
            }
        }

        if (ShotDelay > 0)
        {
            id = NextShotTracker.target;
            if ( id == UfoID )
            {
                rgame.saucer_underfire++;
                ActivePlayerShots++;
            }
            else
            {
                for (r=0;r<rgame.nasteroids;r++)
                {
                    if (rgame.asteroids[r].trackid == id)
                    {
                        rgame.asteroids[r].underfire++;
                        ActivePlayerShots++;
                        break;
                    }
                }
            }
        }
    }
}


void Player::InterpretScreen(FramePacket &packet, GameStatus &rgame)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	rgame.clear();
    rgame.turned = 0;

	if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
    if (disass) printf("-----------------------------------------------------------------------\n");
	for (;;)
	{
		int op = vector_ram[pc] >> 12;

		switch (op)
		{
		case 0xa: // LABS
			vy = (vector_ram[pc] & 0x3ff) - ScrYOff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
            if (disass) printf("%03X %04X %04X   LABS (%d, %d), s%d\n", pc, vector_ram[pc], vector_ram[pc+1], vx, vy, vs);
			break;
		case 0xb: // HALT
            if (disass) printf("%03X %04X        HALT\n", pc, vector_ram[pc]);
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				rgame.asteroids[rgame.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				rgame.asteroids[rgame.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				rgame.asteroids[rgame.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				rgame.asteroids[rgame.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				rgame.saucer_present = true;
				rgame.saucer_underfire = 0;
				rgame.saucer_x = vx;
				rgame.saucer_y = vy;
				rgame.saucer_x2 = vx;
				rgame.saucer_y2 = vy;
				rgame.saucer_vx = 0;
				rgame.saucer_size = vs;
				rgame.saucer_vy = 0;
				break;
			case 0x852: // Copyright
                Score = 0;
                ReadScore = true;
                break;
			case 0xa6d: // Schiff
                ReadScore = false;
                break;
            case 0xb2c: // Leerzeichen
                break;
            case 0xadd: // 0
                if (ReadScore)  Score = Score * 10;
                break;
            case 0xb2e: // 1
                if (ReadScore)  Score = Score * 10 + 1;
                break;
            case 0xb32: // 2
                if (ReadScore)  Score = Score * 10 + 2;
                break;
            case 0xb3a: // 3
                if (ReadScore)  Score = Score * 10 + 3;
                break;
            case 0xb41: // 4
                if (ReadScore)  Score = Score * 10 + 4;
                break;
            case 0xb48: // 5
                if (ReadScore)  Score = Score * 10 + 5;
                break;
            case 0xb4f: // 6
                if (ReadScore)  Score = Score * 10 + 6;
                break;
            case 0xb56: // 7
                if (ReadScore)  Score = Score * 10 + 7;
                break;
            case 0xb5b: // 8
                if (ReadScore)  Score = Score * 10 + 8;
                break;
            case 0xb63: // 9
                if (ReadScore)  Score = Score * 10 + 9;
                break;
			}

            if (disass) printf("%03X %04X        JSRL $%3X   (%s)\n", pc, vector_ram[pc], vector_ram[pc] & 0xfff, "Test");
			break;
		case 0xd: // RTSL
            if (disass) printf("%03X %04x         RTSL\n", pc, vector_ram[pc]);
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
            if (disass) printf("%03X %04X         JMPL $%3X\n", pc, vector_ram[pc], vector_ram[pc] & 0xfff);
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = (vector_ram[pc] & 0x3ff);
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				rgame.shots[rgame.nshots++].set(vx, vy);
            if (disass) {
                if (!(disass_skipuseless && vz == 0))
                    printf("%03X %04X %04X   VCTR (%d, %d), s%d, z%d\n", pc, vector_ram[pc], vector_ram[pc+1], dx, dy, sf, vz);
            }
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					rgame.ship_present = true;
					rgame.ship_x = vx;
					rgame.ship_y = vy;
					rgame.ship_vx = 0;
					rgame.ship_vy = 0;
					rgame.ship_dx = v1x - dx;
					rgame.ship_dy = v1y -ScrYOff - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}

}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->x2 = x;
	this->y2 = y;
	this->type = type;
	this->sf = sf;
	this->Deg = 0;
	this->targetsize = AstTgtRadTabHi[sf];
	this->TargetDeg = 9999;
	this->TargetX = 0;
	this->TargetY = 0;
	this->TargetDegSz = 0;
	this->Distance = 999;
	this->vx = 0;
	this->vy = 0;
	this->ctype = (sf+2 & 0xf) *4 + type-1;
	this->tracked = false;
    this->underfire = 0;
	this->trackprev = NULL;
	this->tracklinks = 0;
	this->trackid = rand() % 10000 +1;
	this->Intersect = false;
	this->Collision = false;
	this->TargetSteps = 999;
	this->speed = 0;
	this->Intersect = false;
    this->Collision = false;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
	this->vx = 0;
	this->vy = 0;
	this->fromplayer = false;
	this->tracked = false;
	this->trackerindex = NULL;
	this->id = 0;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}
