// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't


#include <hge.h>
#include <hgefont.h>

#include <windows.h>
#include <iostream.h>
#include <fstream.h>

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string>
#include <math.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif



static const float PI = 3.1415926535898;
static const bool ShowDebugWindow = true;

static const int ThrustDistanceLo = 200*200;
static const int ThrustDistanceMd = 300*300;
static const int ThrustDistanceHi = 400*400;
static const int ThrustDelayLo = 2;
static const int ThrustDelayMd = 4;
static const int ThrustDelayHi = 6;

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;

static const int max_GameObjects = 16;      // Muss eine 2er-Potenz sein (AND-Maskierung mit n-1)
static const int max_ShotTrackers = 8;
static const int max_AstTrackers = 64;

static const bool disass = false;
static const bool disass_skipuseless = true;


class Asteroid
{
public:
	int x;                  // Koordinaten des Mittelpunkts
	int y;
	int x2;
	int y2;
	int type;               // 1 ... 4, uere Form
	int sf;                 // scale factor: 0 = gro, 15 = mittel, 14 = klein
    int Deg;                 // Bewegungsrichtung
    int targetsize;         // (Halbwinkel) Streuradius, in dem der Asteroid noch beschossen wird
    int TargetX;            // Vorhalteposition
    int TargetY;
    int TargetDeg;          // Winkel zur Vorhalteposition
    int TargetDegSz;        // (Halbwinkel) Vorhaltewinkelgre
    int TargetDistance;     // Abstand der Vorhaltepostition zum Spielerschiff
    int TargetSteps;        // Anzahl Frames die der Schuss vom Schiff bis zum Ziel bentigt
    int TargetDegSteps;     // Anzahl Frames die fr die Drehung Richtung Ziel gebraucht werden
    int Distance;           // Abstand zum Spielerschiff
    int Q1_TargetX;
    int Q1_TargetY;
    int Q1_TargetDeg;
    int Q1_TargetDegSz;
    int Q1_TargetDistance;
    int Q1_TargetSteps;
    int Q1_TargetDegSteps;
    int Q1_Distance;
    int Q2_TargetX;
    int Q2_TargetY;
    int Q2_TargetDeg;
    int Q2_TargetDegSz;
    int Q2_TargetDistance;
    int Q2_TargetSteps;
    int Q2_TargetDegSteps;
    int Q2_Distance;
    int Q3_TargetX;
    int Q3_TargetY;
    int Q3_TargetDeg;
    int Q3_TargetDegSz;
    int Q3_TargetDistance;
    int Q3_TargetSteps;
    int Q3_TargetDegSteps;
    int Q3_Distance;
    int Q4_TargetX;
    int Q4_TargetY;
    int Q4_TargetDeg;
    int Q4_TargetDegSz;
    int Q4_TargetDistance;
    int Q4_TargetSteps;
    int Q4_TargetDegSteps;
    int Q4_Distance;
    float speed;            // sqr(vx*vy + vy*vy)
    int ctype;              // scale factor (0-2) * 4 + (type-1)
    bool tracked;
    int underfire;
    int trackid;
    Asteroid * trackprev;   // Backlink
    int tracklinks;         // Anzahl Backlinks
    float vx;
    float vy;
    bool Intersect;
    int IntersectX;
    int IntersectY;
    int IntersectCnt;
    int IntersectDist;
    bool Collision;
	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;
    float vx;
    float vy;
    bool fromplayer;
    bool tracked;
    int trackerindex;
    int id;
	void set(int x, int y);
};

class ShotVector
{
public:
    float x;
    float y;
    int id;
    int px;
    int py;
    float vx;
    float vy;
    int rot;
    int deg;
    int cnt;        // Alter
    int TTL;        // max. Lebensdauer
    int adx;
    int ady;
    int target;
    float dx;
    float dy;
};

class AstVector
{
public:
    float x;
    float y;
    int id;
    float dx;
    float dy;
};


class ShipVector
{
public:
    int dx;
    int dy;
    int svx;
    int svy;
    float angle;
    int angle_deg;
    float angle2;
    int angle_deg2;
    int nvx;
    int nvy;
    int angle_deg3;
};


class VectorList
{
    char text[2048];
};

struct Vector
{
    int vx;
    int vy;
};

class GameStatus
{
public:
    bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	float ship_vx;        // Geschwindigkeit des Schiffes
	float ship_vy;
	bool saucer_present;// UFO sichtbar
    int saucer_underfire;
    int turned;
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_x2;
	int saucer_y2;
	float saucer_vx;
	float saucer_vy;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	VectorList disassembly;
	void clear(void);
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus &rgame);
	void TrackAstMotion(GameStatus &rgame);
	void TrackShotMotion(GameStatus &rgame);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};


class DebugWindow
{
public:
    bool Create();
    void Close();
    bool CheckMsgs();
    MSG msg;

};


