/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.data;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Position;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.gui.SpaceComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Ship
implements IPositionable,
IDrawable {
    private Position position;
    private static final Color COLOR = new Color(192, 192, 192);
    private static final GeneralPath SHIP_SHAPE = new GeneralPath();
    private int dx;
    private int dy;

    public Ship(int curX, int curY, int dx, int dy) {
        this.position = new Position(curX, curY);
        this.dx = dx;
        this.dy = dy;
    }

    public Position getPosition() {
        return this.position;
    }

    public double getDirectionAngle() {
        return Math.atan2(this.dy, this.dx);
    }

    public Vector getDirectionVector() {
        return new Vector(this.dx, this.dy);
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        g.setColor(COLOR);
        AffineTransform at = AffineTransform.getTranslateInstance(this.position.getCurVector().x, this.position.getCurVector().y);
        at.concatenate(AffineTransform.getRotateInstance(this.getDirectionAngle()));
        g.fill(at.createTransformedShape(SHIP_SHAPE));
        textG.setColor(Color.white);
        textG.drawString(String.format("%01.2f", this.getDirectionAngle()), SpaceComponent.calcX(this.position.getCurVector().x + 10), SpaceComponent.calcY(this.position.getCurVector().y + 10));
        textG.drawString(String.format("%03d", (int)this.getPosition().getSpeed()), SpaceComponent.calcX(this.position.getCurVector().x + 10), SpaceComponent.calcY(this.position.getCurVector().y - 10));
        this.getPosition().draw(g, textG);
    }

    public int getDx() {
        return this.dx;
    }

    public void setDx(int dx) {
        this.dx = dx;
    }

    public int getDy() {
        return this.dy;
    }

    public void setDy(int dy) {
        this.dy = dy;
    }

    static {
        SHIP_SHAPE.moveTo(16.0f, 0.0f);
        SHIP_SHAPE.lineTo(-16.0f, 8.0f);
        SHIP_SHAPE.lineTo(-8.0f, 0.0f);
        SHIP_SHAPE.lineTo(-16.0f, -8.0f);
        SHIP_SHAPE.closePath();
    }
}

