/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.gui;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.gui.SpaceComponent;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.net.ConnectionStatus;
import com.dkaedv.asteroids.util.VectorCalculations;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GameStatus gameStatus;
    private TargetList targetList;
    private ConnectionStatus connectionStatus;
    private JLabel livesTextfield;
    private JLabel shipSpeedTextfield;
    private JLabel latencyTextfield;
    private JLabel targetDistanceTextfield;
    private JLabel targetAngleTextfield;
    private JLabel shotSpeedTextfield;

    public MainFrame() {
        this.setTitle("Asteroid Client");
    }

    public void init() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        this.getContentPane().add(mainPanel);
        SpaceComponent display = new SpaceComponent(640, this.gameStatus, this.targetList);
        mainPanel.add(display);
        JPanel infoPanel = new JPanel(new FlowLayout());
        infoPanel.add(new JLabel("Lives:"));
        this.livesTextfield = new JLabel(String.valueOf(this.gameStatus.getLives()));
        infoPanel.add(this.livesTextfield);
        infoPanel.add(new JLabel("Ship Speed:"));
        this.shipSpeedTextfield = new JLabel("000");
        infoPanel.add(this.shipSpeedTextfield);
        infoPanel.add(new JLabel("Latency:"));
        this.latencyTextfield = new JLabel("00");
        infoPanel.add(this.latencyTextfield);
        infoPanel.add(new JLabel("Target Distance:"));
        this.targetDistanceTextfield = new JLabel("000");
        infoPanel.add(this.targetDistanceTextfield);
        infoPanel.add(new JLabel("Target Angle:"));
        this.targetAngleTextfield = new JLabel("000");
        infoPanel.add(this.targetAngleTextfield);
        infoPanel.add(new JLabel("Avg Shot Speed:"));
        this.shotSpeedTextfield = new JLabel("000");
        infoPanel.add(this.shotSpeedTextfield);
        mainPanel.add(infoPanel);
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public void repaint() {
        this.livesTextfield.setText(String.valueOf(this.gameStatus.getLives()));
        if (this.gameStatus.getShip() != null) {
            this.shipSpeedTextfield.setText(String.format("%03d", (int)this.gameStatus.getShip().getPosition().getSpeed()));
            IPositionable target = this.targetList.getFirstTarget();
            if (target != null) {
                Vector targetVector = VectorCalculations.getDifferenceNormalized(this.gameStatus.getShip().getPosition().getCurVector(), target.getPosition().getCurVector());
                this.targetDistanceTextfield.setText(String.format("%03.0f", VectorCalculations.getNorm(targetVector)));
                this.targetAngleTextfield.setText(String.format("%01.2f", Math.atan2(targetVector.y, targetVector.x)));
            }
        }
        this.latencyTextfield.setText(String.format("%03d", this.connectionStatus.getLatency()) + "ms");
        this.shotSpeedTextfield.setText(String.format("%03.0f", this.gameStatus.getAverageShotSpeed()));
        super.repaint();
    }

    public void setGameStatus(GameStatus gameStatus) {
        this.gameStatus = gameStatus;
    }

    public void setTargetList(TargetList targetList) {
        this.targetList = targetList;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }
}

