/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.gui;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.ki.TargetList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpaceComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SpaceComponent.class);
    private GameStatus gameStatus;
    private TargetList targetList;
    private AffineTransform trafo;
    private AffineTransform scaleTrafo;
    private static int width = 0;
    private static int height = 0;

    public SpaceComponent(int width, GameStatus gStatus, TargetList tList) {
        Dimension size = new Dimension(width, 3 * width / 4);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        SpaceComponent.width = width;
        height = 3 * width / 4;
        double scaling = (double)width / 1024.0;
        this.trafo = AffineTransform.getTranslateInstance(0.0, -896.0);
        this.scaleTrafo = AffineTransform.getScaleInstance(scaling, -scaling);
        this.trafo.preConcatenate(this.scaleTrafo);
        this.gameStatus = gStatus;
        this.targetList = tList;
    }

    protected void paintComponent(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)g.create();
        g2.transform(this.trafo);
        this.gameStatus.draw(g2, (Graphics2D)g);
        this.targetList.draw(g2, (Graphics2D)g);
    }

    public static int calcX(int origX) {
        int newX = (int)((double)origX / 1024.0 * (double)width);
        return newX;
    }

    public static int calcY(int origY) {
        int newY = (int)((768.0 - (double)origY + 128.0) / 768.0 * (double)height);
        return newY;
    }
}

