/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.data;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.Shot;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.ki.ShotTargetList;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.net.DisplayDatagram;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GameStatus
extends DisplayDatagram
implements IDrawable {
    private Log log = LogFactory.getLog(GameStatus.class);
    private int collisionStatus = 1;
    private Vector hitVector = null;
    private TargetList targetList;
    private ShotTargetList shotTargetList;
    private List<Double> shotSpeeds = new java.util.Vector<Double>();
    ThreadLocal<Long> waitTimestamp = new ThreadLocal();

    public GameStatus() {
        this.shotSpeeds.add(490.0);
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        try {
            for (Asteroid asteroid : this.getAsteroids()) {
                asteroid.draw(g, textG);
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        try {
            for (Shot shot : this.getShots()) {
                double speed;
                shot.draw(g, textG);
                if (System.currentTimeMillis() - shot.getPosition().getLastVector().timestamp <= 50L || shot.getType() != 1 || !((speed = shot.getPosition().getSpeed()) > 400.0) || !(speed < 600.0)) continue;
                this.shotSpeeds.add(speed);
                if (this.shotSpeeds.size() <= 30) continue;
                this.shotSpeeds.remove(0);
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        if (this.getShip() != null) {
            this.getShip().draw(g, textG);
        }
        if (this.getUfo() != null) {
            this.getUfo().draw(g, textG);
        }
        Color collColor = Color.GREEN;
        if (this.collisionStatus == 2) {
            collColor = Color.YELLOW;
        } else if (this.collisionStatus == 3) {
            collColor = Color.RED;
        }
        textG.setColor(collColor);
        textG.fillRect(0, 0, 10, 10);
        if (this.hitVector != null) {
            g.setColor(Color.BLUE);
            g.fillOval(this.hitVector.x, this.hitVector.y, 10, 10);
        }
        this.shotTargetList.draw(g, textG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForUpdate() throws InterruptedException {
        Object object = this.waitTimestamp;
        synchronized (object) {
            this.waitTimestamp.set(this.getReceiveTimestamp());
        }
        while (this.waitTimestamp.get().equals(this.getReceiveTimestamp())) {
            object = this;
            synchronized (object) {
                this.wait();
            }
        }
    }

    public double getAverageShotSpeed() {
        if (this.shotSpeeds.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        int count = 0;
        try {
            for (Double speed : this.shotSpeeds) {
                sum += speed.doubleValue();
                ++count;
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        return sum / (double)count;
    }

    public synchronized void wakeUpWaiters() {
        this.notifyAll();
    }

    public void setCollisionStatus(int collisionStatus) {
        this.collisionStatus = collisionStatus;
    }

    public void setHitVector(Vector hitVector) {
        this.hitVector = hitVector;
    }

    public void setTargetList(TargetList targetList) {
        this.targetList = targetList;
    }

    public void setShotTargetList(ShotTargetList shotTargetList) {
        this.shotTargetList = shotTargetList;
    }
}

