/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.data;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Position;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Ufo
implements IPositionable,
IDrawable {
    private Position position;
    private int scaleFactor = 0;
    private static final GeneralPath BIG = new GeneralPath();
    private static final GeneralPath SMALL;

    public Ufo(int curX, int curY, int scaleFactor) {
        this.position = new Position(curX, curY);
        this.scaleFactor = scaleFactor;
    }

    public Position getPosition() {
        return this.position;
    }

    public int getRadius() {
        return this.scaleFactor == 15 ? 15 : 8;
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        g.setColor(Color.white);
        g.draw(AffineTransform.getTranslateInstance(this.position.getCurVector().x, this.position.getCurVector().y).createTransformedShape(this.scaleFactor == 15 ? BIG : SMALL));
        this.getPosition().draw(g, textG);
    }

    static {
        int w = 24;
        int h = 8;
        BIG.moveTo(-w, 0.0f);
        BIG.lineTo(w, 0.0f);
        BIG.lineTo(w / 2, -h);
        BIG.lineTo(-w / 2, -h);
        BIG.lineTo(-w, 0.0f);
        BIG.lineTo(-w / 2, h);
        BIG.lineTo(w / 2, h);
        BIG.lineTo(w, 0.0f);
        BIG.moveTo(-h, h);
        BIG.lineTo(-2 * h / 3, 2 * h);
        BIG.lineTo(2 * h / 3, 2 * h);
        BIG.lineTo(h, h);
        SMALL = new GeneralPath(BIG);
        SMALL.transform(AffineTransform.getScaleInstance(0.5, 0.5));
    }
}

