/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Ship;
import com.dkaedv.asteroids.data.Ufo;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.ki.CollisionProtector;
import com.dkaedv.asteroids.ki.DummyController;
import com.dkaedv.asteroids.ki.MultiWeightingStrategy;
import com.dkaedv.asteroids.ki.ShotTargetList;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.net.DatagramSender;
import com.dkaedv.asteroids.util.VectorCalculations;
import java.io.IOException;

public class SimpleTargetController
extends DummyController {
    private ShotTargetList shotTargetList;
    private MultiWeightingStrategy targetStrategy;
    private DatagramSender datagramSender;
    private CollisionProtector collisionProtector;
    private IPositionable target = null;
    private IPositionable oldtarget = null;
    private long recalculationTimestamp = 0L;
    private boolean retarget = true;
    private static final long PREDICTION_TIME = 20L;
    private static final long THRUST_THRESHOLD = 300L;
    private static final long THRUST_MAX_SPEED = 150L;
    private static final long THRUST_STRATEGIC_MAX_SPEED = 100L;
    private static final double STRATEGIC_MIN_DISTANCE = 200.0;
    private static final boolean ENABLE_THRUST = false;
    private static final boolean ENABLE_THRUST_TO_CENTER = false;
    private double rotationSpeed = 0.0045;
    private boolean haveRotationSpeed = true;
    private double startAngle = 0.0;
    private long rotationStartTime = 0L;
    private long runtime = 0L;

    public void run() {
        this.log.debug("Thread running");
        while (true) {
            long starttime = System.currentTimeMillis();
            try {
                this.collisionProtector.doProcessing();
            }
            catch (RuntimeException e1) {
                e1.printStackTrace();
            }
            if (!this.keysDatagram.isWarp()) {
                try {
                    this.targetStrategy.doProcessing();
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
                try {
                    this.doProcessing();
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                this.datagramSender.sendPacket();
            }
            catch (RuntimeException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                this.gameStatus.waitForUpdate();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessing() {
        long runStartTime = System.currentTimeMillis();
        if (this.gameStatus.getShip() != null) {
            if (!this.haveRotationSpeed) {
                Ship ship = this.gameStatus.getShip();
                this.log.debug(ship.getDirectionAngle());
                if (this.rotationStartTime == 0L) {
                    this.keysDatagram.left(2000L);
                    this.startAngle = ship.getDirectionAngle();
                    this.rotationStartTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.rotationStartTime > 500L && ship.getDirectionAngle() > this.startAngle - 0.1 && ship.getDirectionAngle() < this.startAngle + 0.1) {
                    double rotTime = System.currentTimeMillis() - this.rotationStartTime;
                    this.rotationSpeed = Math.PI * 2 / rotTime;
                    this.haveRotationSpeed = true;
                    this.log.debug("Rotation Speed: " + this.rotationSpeed);
                }
            } else {
                TargetList ship = this.targetList;
                synchronized (ship) {
                    this.target = this.targetList.getFirstTarget();
                }
                if (this.target != null) {
                    double angleTolerance;
                    long firstPredictionTime;
                    long predictionTime = firstPredictionTime = this.connectionStatus.getLatency();
                    Ship ship2 = this.gameStatus.getShip();
                    Vector vectorToTarget = VectorCalculations.getDifferenceNormalized(ship2.getPosition().getPredictedVector(predictionTime), this.target.getPosition().getPredictedVector(predictionTime));
                    double targetDistance = VectorCalculations.getNorm(vectorToTarget);
                    Vector predictedTargetPosition = null;
                    long iterationDiff = 1000L;
                    long lastIterationPredictionTime = 10000L;
                    int iterationCount = 0;
                    double shotSpeed = this.gameStatus.getAverageShotSpeed() / 1000.0;
                    while (Math.abs(iterationDiff) > 1L) {
                        predictionTime = (long)((double)firstPredictionTime + targetDistance / shotSpeed);
                        predictedTargetPosition = this.target.getPosition().getPredictedVector(predictionTime);
                        vectorToTarget = VectorCalculations.getDifferenceNormalized(ship2.getPosition().getPredictedVector(predictionTime), predictedTargetPosition);
                        targetDistance = VectorCalculations.getNorm(vectorToTarget);
                        iterationDiff = predictionTime - lastIterationPredictionTime;
                        lastIterationPredictionTime = predictionTime;
                        if (++iterationCount <= 30) continue;
                    }
                    Vector shipDirection = this.getPredictedShipDirection(firstPredictionTime);
                    double diffAngle = VectorCalculations.getAngleBetween(shipDirection, vectorToTarget);
                    this.gameStatus.setHitVector(predictedTargetPosition);
                    this.turnTo(shipDirection, vectorToTarget);
                    this.recalculationTimestamp = System.currentTimeMillis();
                    double radius = 0.0;
                    if (this.target instanceof Asteroid) {
                        radius = ((Asteroid)this.target).getRadius();
                    }
                    if (this.target instanceof Ufo) {
                        radius = ((Ufo)this.target).getRadius();
                    }
                    if ((angleTolerance = Math.abs(Math.atan2(radius = 0.8 * radius, targetDistance))) < 0.037) {
                        angleTolerance = 0.037;
                    }
                    if (Math.abs(diffAngle) < angleTolerance && (this.gameStatus.getUfo() == null && this.gameStatus.getShots().size() < 4 || this.gameStatus.getUfo() != null && this.gameStatus.getShots().size() < 6)) {
                        this.keysDatagram.fire(1L);
                        this.shotTargetList.registerShot(this.target);
                        this.retarget = true;
                    }
                } else {
                    Vector vectorToTarget;
                    long predictionTime = 20L + this.connectionStatus.getLatency();
                    Vector shipDirection = this.gameStatus.getShip().getDirectionVector();
                    double diffAngle = VectorCalculations.getAngleBetween(shipDirection, vectorToTarget = VectorCalculations.getDifferenceNormalized(this.gameStatus.getShip().getPosition().getPredictedVector(predictionTime), new Vector(0, 0)));
                    if (Math.abs(diffAngle) < 0.1) {
                        this.keysDatagram.stopTurning();
                    } else {
                        this.turnTo(shipDirection, vectorToTarget);
                    }
                }
            }
        } else {
            this.target = null;
        }
        this.runtime = System.currentTimeMillis() - runStartTime;
    }

    private boolean willHit(Ship ship, IPositionable target, long predictionTime) {
        if (ship == null || target == null) {
            return false;
        }
        try {
            Vector shipCurPos = ship.getPosition().getPredictedVector(predictionTime);
            Vector targetCurPos = target.getPosition().getPredictedVector(predictionTime);
            double shipAngle = ship.getDirectionAngle() + Math.PI;
            double targetAngle = target.getPosition().getAngle() + Math.PI;
            double s1 = Math.tan(shipAngle);
            double s2 = Math.tan(targetAngle);
            double a1 = (double)shipCurPos.y - s1 * (double)shipCurPos.x;
            double a2 = (double)targetCurPos.y - s2 * (double)targetCurPos.x;
            double crossX = (a2 - a1) / (s1 - s2);
            double crossY = (s1 * a2 - s2 * a1) / (s1 - s2);
            Vector hitVector = new Vector((int)crossX, (int)crossY);
            this.gameStatus.setHitVector(hitVector);
            double distShip = VectorCalculations.getDistance(shipCurPos, hitVector);
            double distTarget = VectorCalculations.getDistance(targetCurPos, hitVector);
            double timeShot = distShip / 480.0;
            double timeTarget = distTarget / target.getPosition().getSpeed();
            double timeDiff = Math.abs(timeShot - timeTarget);
            if (timeDiff < 0.3) {
                return true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void turnTo(Vector shipDirection, Vector vectorToTarget) {
        double angle = Math.abs(VectorCalculations.getAngleBetween(shipDirection, vectorToTarget));
        long movementMs = (long)(angle / this.rotationSpeed);
        if (shipDirection.x * vectorToTarget.y - shipDirection.y * vectorToTarget.x > 0) {
            this.keysDatagram.left(movementMs);
        } else {
            this.keysDatagram.right(movementMs);
        }
    }

    private Vector getPredictedShipDirection(long predTime) {
        double curAngle = this.gameStatus.getShip().getDirectionAngle();
        if (this.keysDatagram.isLeft()) {
            curAngle += (double)predTime * this.rotationSpeed;
        } else if (this.keysDatagram.isRight()) {
            curAngle -= (double)predTime * this.rotationSpeed;
        }
        return new Vector((int)(Math.cos(curAngle) * 1000.0), (int)(Math.sin(curAngle) * 1000.0));
    }

    public void setShotTargetList(ShotTargetList shotTargetList) {
        this.shotTargetList = shotTargetList;
    }

    public void setTargetStrategy(MultiWeightingStrategy targetStrategy) {
        this.targetStrategy = targetStrategy;
    }

    public void setDatagramSender(DatagramSender datagramSender) {
        this.datagramSender = datagramSender;
    }

    public void setCollisionProtector(CollisionProtector collisionProtector) {
        this.collisionProtector = collisionProtector;
    }
}

