/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.ki.rater;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.RatedTarget;
import com.dkaedv.asteroids.data.Ship;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.ki.rater.BaseTargetRater;
import com.dkaedv.asteroids.util.VectorCalculations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AngleRater
extends BaseTargetRater {
    private Log log = LogFactory.getLog(AngleRater.class);
    double maxAngle = 3.0;

    public void rateTarget(GameStatus gameStatus, TargetList targetList, RatedTarget target) {
        Ship ship = gameStatus.getShip();
        Vector vectorToTarget = VectorCalculations.getDifferenceNormalized(ship.getPosition().getCurVector(), target.getTarget().getPosition().getCurVector());
        double angle = VectorCalculations.getAngleBetween(ship.getDirectionVector(), vectorToTarget);
        double angleAbsDiff = Math.abs(ship.getDirectionAngle() - Math.atan2(vectorToTarget.y, vectorToTarget.x));
        if (angleAbsDiff > Math.PI) {
            angle += 1.5707963267948966;
        }
        if (angle > this.maxAngle) {
            this.log.debug("Increasing max angle to " + angle);
            this.maxAngle = angle;
        }
        double score = (1.0 - angle / this.maxAngle) * 100.0;
        this.rateIt(target, (int)score);
    }
}

