/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.net;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.Ship;
import com.dkaedv.asteroids.data.Shot;
import com.dkaedv.asteroids.data.Ufo;
import com.dkaedv.asteroids.net.ConnectionStatus;
import com.dkaedv.asteroids.net.DisplayDatagram;
import com.dkaedv.asteroids.net.FrameInfo;
import com.dkaedv.asteroids.util.DistanceComparator;
import com.dkaedv.asteroids.util.VectorCalculations;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Collections;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatagramReceiver
extends Thread {
    private Log log = LogFactory.getLog(DatagramReceiver.class);
    private DatagramSocket socket;
    private GameStatus gameStatus;
    private ConnectionStatus connectionStatus;

    public void run() {
        this.log.debug("Thread running");
        try {
            while (true) {
                DatagramPacket dgram = new DatagramPacket(new byte[FrameInfo.MAME_DATAGRAM_SIZE], FrameInfo.MAME_DATAGRAM_SIZE);
                this.socket.receive(dgram);
                int receiveSerial = FrameInfo.asInt(dgram.getData()[1025]);
                this.connectionStatus.calculateLatency(receiveSerial, System.currentTimeMillis());
                DisplayDatagram displayDatagram = this.interpretDatagram(dgram.getData());
                displayDatagram.setReceiveTimestamp(System.currentTimeMillis());
                this.updateGameStatus(displayDatagram);
                this.gameStatus.wakeUpWaiters();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    DisplayDatagram interpretDatagram(byte[] data) {
        DisplayDatagram dgram = new DisplayDatagram();
        int[] vectorRamWords = new int[FrameInfo.VECTOR_RAM_SIZE / 2];
        int r = 0;
        for (int w = 0; w < 512; ++w) {
            vectorRamWords[w] = FrameInfo.asInt(data[r]) | FrameInfo.asInt(data[r + 1]) << 8;
            r += 2;
        }
        int gsf = 0;
        int pos_x = 0;
        int pos_y = 0;
        int dy = 0;
        int dx = 0;
        int sf = 0;
        int vz = 0;
        int v1x = 0;
        int v1y = 0;
        int shipdetect = 0;
        for (int i = 0; i < vectorRamWords.length; ++i) {
            int opcode = vectorRamWords[i] >> 12;
            switch (opcode) {
                case 10: {
                    pos_y = vectorRamWords[i] & 0x3FF;
                    pos_x = vectorRamWords[i + 1] & 0x3FF;
                    gsf = vectorRamWords[i + 1] >> 12;
                    break;
                }
                case 11: {
                    return dgram;
                }
                case 12: {
                    switch (vectorRamWords[i] & 0xFFF) {
                        case 2291: {
                            dgram.getAsteroids().add(new Asteroid(pos_x, pos_y, 1, gsf));
                            break;
                        }
                        case 2303: {
                            dgram.getAsteroids().add(new Asteroid(pos_x, pos_y, 2, gsf));
                            break;
                        }
                        case 2317: {
                            dgram.getAsteroids().add(new Asteroid(pos_x, pos_y, 3, gsf));
                            break;
                        }
                        case 2330: {
                            dgram.getAsteroids().add(new Asteroid(pos_x, pos_y, 4, gsf));
                            break;
                        }
                        case 2669: {
                            dgram.setLives(dgram.getLives() + 1);
                            break;
                        }
                        case 2345: {
                            dgram.setUfo(new Ufo(pos_x, pos_y, gsf));
                        }
                    }
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    break;
                }
                default: {
                    dy = vectorRamWords[i] & 0x3FF;
                    if ((vectorRamWords[i] & 0x400) != 0) {
                        dy = -dy;
                    }
                    dx = vectorRamWords[i + 1] & 0x3FF;
                    if ((vectorRamWords[i + 1] & 0x400) != 0) {
                        dx = -dx;
                    }
                    sf = opcode;
                    vz = vectorRamWords[i + 1] >> 12;
                    if (dx == 0 && dy == 0 && vz == 15) {
                        dgram.getShots().add(new Shot(pos_x, pos_y));
                    }
                    if (opcode == 6 && vz == 12 && dx != 0 && dy != 0) {
                        switch (shipdetect) {
                            case 0: {
                                v1x = dx;
                                v1y = dy;
                                ++shipdetect;
                                break;
                            }
                            case 1: {
                                dgram.setShip(new Ship(pos_x, pos_y, v1x - dx, v1y - dy));
                                ++shipdetect;
                            }
                        }
                        break;
                    }
                    if (shipdetect != true) break;
                    shipdetect = 0;
                }
            }
            if (opcode > 10) continue;
            ++i;
        }
        return dgram;
    }

    private void updateGameStatus(DisplayDatagram dgram) {
        Vector<Asteroid> currentAsteroids = new Vector<Asteroid>();
        currentAsteroids.addAll(this.gameStatus.getAsteroids());
        for (Asteroid a : dgram.getAsteroids()) {
            if (currentAsteroids.size() > 0) {
                Collections.sort(currentAsteroids, new DistanceComparator(a.getPosition().getCurVector()));
                Asteroid updateAsteroid = (Asteroid)currentAsteroids.get(0);
                if (updateAsteroid.getScaleFactor() == a.getScaleFactor() && updateAsteroid.getType() == a.getType()) {
                    updateAsteroid.getPosition().updatePosition(a.getPosition().getCurVector());
                    currentAsteroids.remove(updateAsteroid);
                    continue;
                }
                this.gameStatus.getAsteroids().add(a);
                continue;
            }
            this.gameStatus.getAsteroids().add(a);
        }
        this.gameStatus.getAsteroids().removeAll(currentAsteroids);
        if (this.gameStatus.getShip() != null && dgram.getShip() != null) {
            this.gameStatus.getShip().getPosition().updatePosition(dgram.getShip().getPosition().getCurVector());
            this.gameStatus.getShip().setDx(dgram.getShip().getDx());
            this.gameStatus.getShip().setDy(dgram.getShip().getDy());
        } else {
            this.gameStatus.setShip(dgram.getShip());
        }
        if (this.gameStatus.getUfo() != null && dgram.getUfo() != null) {
            this.gameStatus.getUfo().getPosition().updatePosition(dgram.getUfo().getPosition().getCurVector());
        } else {
            this.gameStatus.setUfo(dgram.getUfo());
        }
        Vector<Shot> currentShots = new Vector<Shot>();
        currentShots.addAll(this.gameStatus.getShots());
        double avgShotSpeed = this.gameStatus.getAverageShotSpeed();
        for (Shot s : dgram.getShots()) {
            Collections.sort(currentShots, new DistanceComparator(s.getPosition().getCurVector()));
            boolean updatedShot = false;
            if (currentShots.size() > 0) {
                Vector currentShotsDup = new Vector(currentShots);
                for (Shot updateShot : currentShotsDup) {
                    if (updatedShot) continue;
                    double shotDistance = VectorCalculations.getDistance(updateShot, s);
                    double timeDiff = s.getPosition().getCurVector().timestamp - updateShot.getPosition().getCurVector().timestamp;
                    if (updateShot.getType() == 1 && shotDistance < avgShotSpeed / 1000.0 * timeDiff * 1.5 && shotDistance > avgShotSpeed / 1000.0 * timeDiff * 0.5) {
                        updateShot.getPosition().updatePosition(s.getPosition().getCurVector());
                        currentShots.remove(updateShot);
                        updatedShot = true;
                        continue;
                    }
                    if (updateShot.getType() != 2 || !(shotDistance < 20.0)) continue;
                    updateShot.getPosition().updatePosition(s.getPosition().getCurVector());
                    currentShots.remove(updateShot);
                    updatedShot = true;
                }
            }
            if (updatedShot) continue;
            this.gameStatus.getShots().add(s);
            if (this.gameStatus.getUfo() != null && this.gameStatus.getShip() != null) {
                double distanceToShip = VectorCalculations.getDistance(this.gameStatus.getShip(), s);
                double distanceToUfo = VectorCalculations.getDistance(this.gameStatus.getUfo(), s);
                if (distanceToUfo < distanceToShip && distanceToUfo < 30.0) {
                    s.setType(2);
                    continue;
                }
                s.setType(1);
                continue;
            }
            if (this.gameStatus.getShip() != null) {
                s.setType(1);
                continue;
            }
            if (this.gameStatus.getUfo() == null) continue;
            s.setType(2);
        }
        this.gameStatus.getShots().removeAll(currentShots);
        this.gameStatus.setLives(dgram.getLives());
        this.gameStatus.setReceiveTimestamp(dgram.getReceiveTimestamp());
    }

    public void setSocket(DatagramSocket socket) {
        this.socket = socket;
    }

    public void setGameStatus(GameStatus gameStatus) {
        this.gameStatus = gameStatus;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }
}

