/*
 * Created on Apr 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.data;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Asteroid implements IPositionable, IDrawable {
    private int scaleFactor = 0;
    private int type = 0;
    private Position position;

    public final static int NORMAL_SCALE = 8;

    // Drawing Support
    // taken from Rammi (rammi@caff.de)
    private static final GeneralPath PATH0 = new GeneralPath();
    private static final GeneralPath PATH1 = new GeneralPath();
    private static final GeneralPath PATH2 = new GeneralPath();
    private static final GeneralPath PATH3 = new GeneralPath();
    static {
      PATH0.moveTo(1, 0);
      PATH0.lineTo(4, 1);
      PATH0.lineTo(4, 2);
      PATH0.lineTo(1, 4);
      PATH0.lineTo(-2, 4);
      PATH0.lineTo(-1, 3);
      PATH0.lineTo(-4, 3);
      PATH0.lineTo(-4, -1);
      PATH0.lineTo(-2, -4);
      PATH0.lineTo(1, -3);
      PATH0.lineTo(2, -4);
      PATH0.lineTo(4, -2);
      PATH0.closePath();

      PATH1.moveTo(3, 0);
      PATH1.lineTo(4, 2);
      PATH1.lineTo(2, 4);
      PATH1.lineTo(0, 2);
      PATH1.lineTo(-2, 4);
      PATH1.lineTo(-4, 2);
      PATH1.lineTo(-4, -2);
      PATH1.lineTo(-2, -4);
      PATH1.lineTo(1, -4);
      PATH1.lineTo(4, -2);
      PATH1.closePath();

      PATH2.moveTo(4, 1);
      PATH2.lineTo(2, 4);
      PATH2.lineTo(-1, 4);
      PATH2.lineTo(-4, 1);
      PATH2.lineTo(-2, 0);
      PATH2.lineTo(-4, -1);
      PATH2.lineTo(-2, -4);
      PATH2.lineTo(0, -1);
      PATH2.lineTo(0, -4);
      PATH2.lineTo(2, -4);
      PATH2.lineTo(4, -1);
      PATH2.closePath();

      PATH3.moveTo(2, 1);
      PATH3.lineTo(4, 2);
      PATH3.lineTo(2, 4);
      PATH3.lineTo(0, 3);
      PATH3.lineTo(-2, 4);
      PATH3.lineTo(-4, 2);
      PATH3.lineTo(-3, 0);
      PATH3.lineTo(-4, -2);
      PATH3.lineTo(-2, -4);
      PATH3.lineTo(-1, -3);
      PATH3.lineTo(2, -4);
      PATH3.lineTo(4, -1);
      PATH3.closePath();
    }
    /** The asteroid shapes sorted by type. */
    private static final Shape[] SHAPES = new Shape[] {
            PATH1,
            PATH3,
            PATH2,
            PATH0,
    };


    public Asteroid(int curX, int curY, int type, int scaleFactor) {
        position = new Position(curX, curY);
        this.type = type;
        this.scaleFactor = scaleFactor;
    }

    public Position getPosition() {
        return position;
    }


    public void draw(Graphics2D g, Graphics2D textG) {
        g.setColor(Color.gray);
        AffineTransform trafo = new AffineTransform(getDrawScale(), 0, 0, getDrawScale(), position.getCurVector().x, position.getCurVector().y);
        g.draw(trafo.createTransformedShape(SHAPES[type-1]));

        getPosition().draw(g, textG);
    }

    private int getDrawScale() {
        switch (scaleFactor) {
            case 0:
                return NORMAL_SCALE;
            case 15:
                return NORMAL_SCALE/2;
            case 14:
                return NORMAL_SCALE/4;
        }

      return NORMAL_SCALE;
    }

    /**
     * Returns the approximate radius of the asteroid.
     *
     * @return
     */
    public int getRadius() {
        return 4*getDrawScale();
    }

    /**
     * @return the scaleFactor
     */
    public int getScaleFactor() {
        return scaleFactor;
    }

    /**
     * @return the type
     */
    public int getType() {
        return type;
    }


}
