/*
 * Created on Apr 18, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.data;

public class GameInfo {

    /** Extent of x and y coordinates. */
    public final static int EXTENT = 1024;
    /** Border above and below y because of 4/3 screen aspect ratio. */
    public final static int BORDER_Y = EXTENT/8;
    /** The minimal y coordinate used. */
    public final static int MIN_Y = BORDER_Y;
    /** The screen extend in x direction. */
    public final static int EXTENT_X = EXTENT;
    /** The screen extent in y direction. */
    public final static int EXTENT_Y = EXTENT - 2*BORDER_Y;
    /** The maximal y coordinate used. */
    public final static int MAX_Y = BORDER_Y + EXTENT_Y - 1;

    /** Rotation speed of ship as [radiants / ms]
     * TODO Find the right value from c't
     */
    //public final static double ROTATION_SPEED = 4.2E-3;

    /**
     * Shot speed (pixels / ms)
     *
     * was 0.540
     * also tried 0.400, 0.450
     */
    public final static double SHOT_SPEED = 0.480;
}
