/*
 * Created on Apr 17, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.data;

import java.awt.Color;
import java.awt.Graphics2D;

public class Shot implements IPositionable, IDrawable {
    private Position position;
    private int type = 0; // 1 = Ship shot, 2 = Ufo shot

    public final static int TYPE_SHIP = 1;
    public final static int TYPE_UFO = 2;

    public Shot(int curX, int curY) {
        position = new Position(curX, curY);
    }

    public Position getPosition() {
        return position;
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        if (type == TYPE_UFO) {
            g.setColor(Color.red);
        } else if (type == TYPE_SHIP) {
            g.setColor(Color.green);
        } else {
            g.setColor(Color.white);
        }

        g.fillOval(getPosition().getCurVector().x - 4, getPosition().getCurVector().y - 4, 8, 8);

        getPosition().draw(g, textG);
    }

    /**
     * @return the type
     */
    public int getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    public void setType(int type) {
        this.type = type;
    }


}
